/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.gui.list.data_provider;

import com.mojang.brigadier.context.CommandContext;
import de.sijo.player_trading.data.model.Trade;
import de.sijo.player_trading.data.persistence.TradeRepository;
import de.sijo.player_trading.gui.list.data_provider.AbstractTradeListDataProvider;
import de.sijo.player_trading.gui.list.data_provider.TradeListActionType;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;

public class TradeListDataProviderAllTrades
extends AbstractTradeListDataProvider {
    private final String playerName;

    public TradeListDataProviderAllTrades(CommandContext<CommandSourceStack> context) {
        this.playerName = ((CommandSourceStack)context.getSource()).getPlayer().getName().getString();
    }

    public TradeListDataProviderAllTrades(String playerName) {
        this.playerName = playerName;
    }

    @Override
    public List<Trade> getTrades() {
        return TradeRepository.getInstance().getAllPendingTrades().stream().filter(x -> !this.playerName.equals(x.offerPlayerName())).toList();
    }

    @Override
    public String getDisplayName() {
        return "List Trades";
    }

    @Override
    public String getButtonTooltip() {
        return "Accept Trade";
    }

    @Override
    public TradeListActionType getTradeActionType() {
        return TradeListActionType.ACCEPT_TRADE;
    }
}

