/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.gui.list;

import com.mojang.blaze3d.systems.RenderSystem;
import de.sijo.player_trading.data.model.Trade;
import de.sijo.player_trading.gui.AbstractTradeNavigationScreen;
import de.sijo.player_trading.gui.TradeMenuType;
import de.sijo.player_trading.gui.list.TradeListMenu;
import de.sijo.player_trading.gui.list.data_provider.AbstractTradeListDataProvider;
import de.sijo.player_trading.gui.list.data_provider.TradeListActionType;
import de.sijo.player_trading.network.data_update.RequestTradeListDataUpdatePacket;
import de.sijo.player_trading.network.logic.TradeActionPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class TradeListScreen
extends AbstractTradeNavigationScreen<TradeListMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"textures/gui/listtrades_gui.png");
    private static final ResourceLocation CLAIM_TRADE_ACTION_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"textures/gui/buttons/action/claim_trade.png");
    private static final ResourceLocation ACCEPT_TRADE_ACTION_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"textures/gui/buttons/action/accept_trade.png");
    private static final ResourceLocation CANCEL_TRADE_ACTION_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"textures/gui/buttons/action/cancel_trade.png");
    private static final ResourceLocation SCROLL_UP_BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"textures/gui/buttons/scroll/up.png");
    private static final ResourceLocation SCROLL_DOWN_BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"textures/gui/buttons/scroll/down.png");
    private static final int TRADES_PER_PAGE = 3;
    private static final int SEARCH_BOX_X = 7;
    private static final int SEARCH_BOX_Y = 16;
    private static final int SEARCH_BOX_WIDTH = 100;
    private static final int SEARCH_BOX_HEIGHT = 12;
    private static final int SCROLL_UP_X = 156;
    private static final int SCROLL_UP_Y = 30;
    private static final int SCROLL_DOWN_X = 156;
    private static final int SCROLL_DOWN_Y = 105;
    private static final int SCROLL_BUTTON_SIZE = 13;
    private static final int SCROLLBAR_X = 156;
    private static final int SCROLLBAR_Y = 43;
    private static final int SCROLLBAR_WIDTH = 13;
    private static final int SCROLLBAR_HEIGHT = 62;
    private static final int SCROLLBAR_TRACK_COLOR = -14013910;
    private static final int SCROLLBAR_THUMB_COLOR = -9803158;
    private static final int SCROLLBAR_THUMB_HOVER_COLOR = -7697782;
    private static final int TILE_ACTION_BUTTON_SIZE = 16;
    private static final int TRADE_TILES_START_Y = 30;
    private static final int TRADE_TILE_HEIGHT = 30;
    private static final int TRADE_TILES_LEFT = 7;
    private static final int TRADE_TILES_RIGHT = 154;
    private List<Trade> trades;
    private List<Trade> filteredTrades;
    private int scrollOffset = 0;
    private Button scrollUpButton;
    private Button scrollDownButton;
    private EditBox searchBox;
    private ItemStack hoveredItem = null;
    private boolean isDraggingScrollbar = false;
    private int scrollbarDragOffset = 0;

    public TradeListScreen(TradeListMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title, switch (menu.getDataProvider().getTradeActionType()) {
            default -> throw new MatchException(null, null);
            case TradeListActionType.CLAIM_TRADE -> TradeMenuType.CLAIM_TRADES;
            case TradeListActionType.ACCEPT_TRADE -> TradeMenuType.LIST_TRADES;
            case TradeListActionType.CANCEL_TRADE -> TradeMenuType.PENDING_TRADES;
        });
        this.imageHeight = 218;
        this.inventoryLabelY = this.imageHeight - 94;
        AbstractTradeListDataProvider dataProvider = menu.getDataProvider();
        if (dataProvider == null) {
            throw new IllegalStateException("Menu Data Provider isn't Available");
        }
        this.trades = dataProvider.getTrades();
        this.filteredTrades = List.copyOf(this.trades);
    }

    @Override
    protected void init() {
        super.init();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.searchBox = new EditBox(this.font, x + 7, y + 16, 100, 12, (Component)Component.literal((String)"Item Search"));
        this.searchBox.setMaxLength(50);
        this.searchBox.setHint((Component)Component.literal((String)"Search"));
        this.searchBox.setResponder(this::onSearchTextChanged);
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        this.scrollUpButton = Button.builder((Component)Component.literal((String)""), this::onScrollUp).bounds(x + 156, y + 30, 13, 13).build();
        this.addRenderableWidget((GuiEventListener)this.scrollUpButton);
        this.scrollDownButton = Button.builder((Component)Component.literal((String)""), this::onScrollDown).bounds(x + 156, y + 105, 13, 13).build();
        this.addRenderableWidget((GuiEventListener)this.scrollDownButton);
        this.updateScrollButtons();
    }

    private void onSearchTextChanged(String searchText) {
        this.updateFilteredTrades(searchText);
        this.scrollOffset = 0;
        this.updateScrollButtons();
    }

    private void updateFilteredTrades(String searchText) {
        if (searchText == null || searchText.trim().isEmpty()) {
            this.filteredTrades = List.copyOf(this.trades);
        } else {
            this.filteredTrades = new ArrayList<Trade>();
            String searchLower = searchText.toLowerCase();
            for (Trade trade : this.trades) {
                String itemName;
                String displayName;
                boolean matches = trade.offerPlayerName().toLowerCase().contains(searchLower);
                for (ItemStack item : trade.ItemsRequest()) {
                    if (item == null || item.isEmpty()) continue;
                    displayName = item.getDisplayName().getString().toLowerCase();
                    itemName = item.getItem().toString().toLowerCase();
                    if (!displayName.contains(searchLower) && !itemName.contains(searchLower)) continue;
                    matches = true;
                    break;
                }
                if (!matches) {
                    for (ItemStack item : trade.ItemsOffer()) {
                        if (item == null || item.isEmpty()) continue;
                        displayName = item.getDisplayName().getString().toLowerCase();
                        itemName = item.getItem().toString().toLowerCase();
                        if (!displayName.contains(searchLower) && !itemName.contains(searchLower)) continue;
                        matches = true;
                        break;
                    }
                }
                if (!matches) continue;
                this.filteredTrades.add(trade);
            }
        }
    }

    private void onScrollUp(Button button) {
        if (this.scrollOffset > 0) {
            --this.scrollOffset;
            this.updateScrollButtons();
        }
    }

    private void onScrollDown(Button button) {
        if (this.scrollOffset < Math.max(0, this.filteredTrades.size() - 3)) {
            ++this.scrollOffset;
            this.updateScrollButtons();
        }
    }

    private void updateScrollButtons() {
        if (this.scrollUpButton != null) {
            boolean bl = this.scrollUpButton.active = this.scrollOffset > 0;
        }
        if (this.scrollDownButton != null) {
            this.scrollDownButton.active = this.scrollOffset < Math.max(0, this.filteredTrades.size() - 3);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderTradeTiles(guiGraphics, x, y, mouseX, mouseY);
        this.renderScrolButtons(guiGraphics, x, y);
        this.renderScrollbar(guiGraphics, x, y, mouseX, mouseY);
        if (this.hoveredItem != null && !this.hoveredItem.isEmpty()) {
            guiGraphics.renderTooltip(this.font, this.hoveredItem, mouseX, mouseY);
        }
    }

    private void renderScrolButtons(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(SCROLL_DOWN_BUTTON_TEXTURE, x + 156, y + 105, 0.0f, 0.0f, 13, 13, 13, 13);
        guiGraphics.blit(SCROLL_UP_BUTTON_TEXTURE, x + 156, y + 30, 0.0f, 0.0f, 13, 13, 13, 13);
    }

    private void renderScrollbar(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        int scrollbarX = x + 156;
        int scrollbarY = y + 43;
        guiGraphics.fill(scrollbarX, scrollbarY, scrollbarX + 13, scrollbarY + 62, -14013910);
        int maxScrollOffset = Math.max(0, this.filteredTrades.size() - 3);
        if (maxScrollOffset > 0) {
            int thumbHeight = Math.max(8, 186 / Math.max(3, this.filteredTrades.size()));
            int thumbY = scrollbarY + (62 - thumbHeight) * this.scrollOffset / maxScrollOffset;
            boolean mouseOverThumb = mouseX >= scrollbarX && mouseX <= scrollbarX + 13 && mouseY >= thumbY && mouseY <= thumbY + thumbHeight;
            int thumbColor = mouseOverThumb || this.isDraggingScrollbar ? -7697782 : -9803158;
            guiGraphics.fill(scrollbarX + 1, thumbY, scrollbarX + 13 - 1, thumbY + thumbHeight, thumbColor);
        }
    }

    private void renderTradeTiles(GuiGraphics guiGraphics, int guiLeft, int guiTop, int mouseX, int mouseY) {
        int tradeIndex;
        this.hoveredItem = null;
        for (int i = 0; i < 3 && (tradeIndex = this.scrollOffset + i) < this.filteredTrades.size(); ++i) {
            Trade trade = this.filteredTrades.get(tradeIndex);
            int yPos = guiTop + 30 + i * 30;
            guiGraphics.fill(guiLeft + 7, yPos, guiLeft + 154, yPos + 28, -7631989);
            guiGraphics.fill(guiLeft + 8, yPos + 1, guiLeft + 154 - 1, yPos + 27, -13158601);
            String playerText = trade.offerPlayerName();
            guiGraphics.drawString(this.font, playerText, guiLeft + 10, yPos + 2, 0xFFFFFF, false);
            this.renderTradeSlots(guiGraphics, trade.ItemsRequest(), guiLeft + 10, yPos + 11, 3, mouseX, mouseY);
            guiGraphics.drawString(this.font, "\u2192", guiLeft + 68, yPos + 15, 0xFFFFFF, false);
            this.renderTradeSlots(guiGraphics, trade.ItemsOffer(), guiLeft + 81, yPos + 11, 3, mouseX, mouseY);
            this.renderActionButton(guiGraphics, guiLeft, yPos, mouseX, mouseY);
        }
    }

    private void renderActionButton(GuiGraphics guiGraphics, int guiLeft, int yPos, int mouseX, int mouseY) {
        TradeListActionType actionType = ((TradeListMenu)this.menu).getDataProvider().getTradeActionType();
        int buttonX = guiLeft + 135;
        int buttonY = yPos + 11;
        boolean isHovered = mouseX >= buttonX && mouseX <= buttonX + 16 && mouseY >= buttonY && mouseY <= buttonY + 16;
        int bgColor = isHovered ? -9803158 : -12566464;
        guiGraphics.fill(buttonX, buttonY, buttonX + 16, buttonY + 16, bgColor);
        guiGraphics.fill(buttonX + 1, buttonY + 1, buttonX + 16 - 1, buttonY + 16 - 1, -14013910);
        guiGraphics.blit(this.getActionTexture(actionType), buttonX, buttonY, 0.0f, 0.0f, 16, 16, 16, 16);
        if (isHovered) {
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)((TradeListMenu)this.menu).getDataProvider().getButtonTooltip()), mouseX, mouseY);
        }
    }

    private ResourceLocation getActionTexture(TradeListActionType actionType) {
        return switch (actionType) {
            default -> throw new MatchException(null, null);
            case TradeListActionType.CANCEL_TRADE -> CANCEL_TRADE_ACTION_TEXTURE;
            case TradeListActionType.ACCEPT_TRADE -> ACCEPT_TRADE_ACTION_TEXTURE;
            case TradeListActionType.CLAIM_TRADE -> CLAIM_TRADE_ACTION_TEXTURE;
        };
    }

    private void renderTradeSlots(GuiGraphics guiGraphics, ItemStack[] items, int x, int y, int maxSlots, int mouseX, int mouseY) {
        for (int i = 0; i < maxSlots; ++i) {
            int slotX = x + i * 18;
            guiGraphics.fill(slotX, y, slotX + 16, y + 16, -11184811);
            guiGraphics.fill(slotX + 1, y + 1, slotX + 15, y + 15, -13158601);
            if (i >= items.length || items[i] == null || items[i].isEmpty()) continue;
            ItemStack item = items[i];
            guiGraphics.renderItem(item, slotX, y);
            if (item.getCount() > 1) {
                guiGraphics.renderItemDecorations(this.font, item, slotX, y, String.valueOf(item.getCount()));
            }
            if (mouseX < slotX || mouseX > slotX + 16 || mouseY < y || mouseY > y + 16) continue;
            this.hoveredItem = item;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int tradeIndex;
        int maxScrollOffset;
        boolean clickedOnSearchBox;
        int guiLeft = (this.width - this.imageWidth) / 2;
        int guiTop = (this.height - this.imageHeight) / 2;
        boolean bl = clickedOnSearchBox = mouseX >= (double)(guiLeft + 7) && mouseX <= (double)(guiLeft + 7 + 100) && mouseY >= (double)(guiTop + 16) && mouseY <= (double)(guiTop + 16 + 12);
        if (!clickedOnSearchBox && this.searchBox != null) {
            this.searchBox.setFocused(false);
        }
        int scrollbarX = guiLeft + 156;
        int scrollbarY = guiTop + 43;
        if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + 13) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + 62) && (maxScrollOffset = Math.max(0, this.filteredTrades.size() - 3)) > 0) {
            int thumbHeight = Math.max(8, 186 / Math.max(3, this.filteredTrades.size()));
            int thumbY = scrollbarY + (62 - thumbHeight) * this.scrollOffset / maxScrollOffset;
            if (mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight)) {
                this.isDraggingScrollbar = true;
                this.scrollbarDragOffset = (int)(mouseY - (double)thumbY);
                return true;
            }
            double clickPosition = (mouseY - (double)scrollbarY) / 62.0;
            int newScrollOffset = (int)(clickPosition * (double)maxScrollOffset);
            this.scrollOffset = Math.max(0, Math.min(maxScrollOffset, newScrollOffset));
            this.updateScrollButtons();
            return true;
        }
        for (int i = 0; i < 3 && (tradeIndex = this.scrollOffset + i) < this.filteredTrades.size(); ++i) {
            int yPos = guiTop + 30 + i * 30;
            int buttonX = guiLeft + 135;
            int buttonY = yPos + 11;
            if (!(mouseX >= (double)buttonX) || !(mouseX <= (double)(buttonX + 16)) || !(mouseY >= (double)buttonY) || !(mouseY <= (double)(buttonY + 16))) continue;
            Trade trade = this.filteredTrades.get(tradeIndex);
            PacketDistributor.sendToServer((CustomPacketPayload)new TradeActionPacket(trade), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.requestDataRefresh();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        boolean mouseOverTradeArea;
        int guiLeft = (this.width - this.imageWidth) / 2;
        int guiTop = (this.height - this.imageHeight) / 2;
        boolean bl = mouseOverTradeArea = mouseX >= (double)(guiLeft + 7) && mouseX <= (double)(guiLeft + 154) && mouseY >= (double)(guiTop + 30) && mouseY <= (double)(guiTop + 30 + 90);
        if (mouseOverTradeArea) {
            if (deltaY > 0.0) {
                if (this.scrollOffset > 0) {
                    --this.scrollOffset;
                    this.updateScrollButtons();
                    return true;
                }
            } else if (deltaY < 0.0 && this.scrollOffset < Math.max(0, this.filteredTrades.size() - 3)) {
                ++this.scrollOffset;
                this.updateScrollButtons();
                return true;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isDraggingScrollbar = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDraggingScrollbar) {
            int guiLeft = (this.width - this.imageWidth) / 2;
            int guiTop = (this.height - this.imageHeight) / 2;
            int scrollbarY = guiTop + 43;
            int maxScrollOffset = Math.max(0, this.filteredTrades.size() - 3);
            if (maxScrollOffset > 0) {
                int thumbHeight = Math.max(8, 186 / Math.max(3, this.filteredTrades.size()));
                int maxThumbY = scrollbarY + 62 - thumbHeight;
                double thumbPosition = (mouseY - (double)this.scrollbarDragOffset - (double)scrollbarY) / (double)(62 - thumbHeight);
                thumbPosition = Math.max(0.0, Math.min(1.0, thumbPosition));
                int newScrollOffset = (int)(thumbPosition * (double)maxScrollOffset);
                this.scrollOffset = Math.max(0, Math.min(maxScrollOffset, newScrollOffset));
                this.updateScrollButtons();
                return true;
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.searchBox != null && this.searchBox.isFocused()) {
                this.searchBox.setFocused(false);
                return true;
            }
            this.minecraft.player.closeContainer();
            return true;
        }
        return this.searchBox != null && !this.searchBox.keyPressed(keyCode, scanCode, modifiers) && !this.searchBox.canConsumeInput() ? super.keyPressed(keyCode, scanCode, modifiers) : true;
    }

    public void updateTradeData(List<Trade> trades) {
        this.trades = trades;
        String currentSearchText = this.searchBox != null ? this.searchBox.getValue() : "";
        this.updateFilteredTrades(currentSearchText);
        this.scrollOffset = 0;
        this.updateScrollButtons();
    }

    public void requestDataRefresh() {
        PacketDistributor.sendToServer((CustomPacketPayload)new RequestTradeListDataUpdatePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

