/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.gui.list;

import de.sijo.player_trading.gui.list.TradeListMenu;
import de.sijo.player_trading.gui.list.data_provider.AbstractTradeListDataProvider;
import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.IContainerFactory;
import org.jetbrains.annotations.NotNull;

public class TradeListMenuProvider
implements MenuProvider,
IContainerFactory<TradeListMenu> {
    private final AbstractTradeListDataProvider dataProvider;

    public TradeListMenuProvider(AbstractTradeListDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    @NotNull
    public Component getDisplayName() {
        return Component.literal((String)this.dataProvider.getDisplayName());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), player.registryAccess());
        this.dataProvider.writeToBuffer(buffer);
        return new TradeListMenu(containerId, playerInventory, buffer);
    }

    public TradeListMenu create(int windowId, Inventory inv, RegistryFriendlyByteBuf data) {
        return new TradeListMenu(windowId, inv, data);
    }
}

