/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.gui.list;

import de.sijo.player_trading.data.model.Trade;
import de.sijo.player_trading.data.update_watcher.TradeDataUpdateHandlerListTrades;
import de.sijo.player_trading.gui.AbstractTradeNavigationMenu;
import de.sijo.player_trading.gui.list.data_provider.AbstractTradeListDataProvider;
import de.sijo.player_trading.gui.list.data_provider.TradeListActionType;
import de.sijo.player_trading.init.ModMenuTypes;
import de.sijo.player_trading.logic.AcceptTrade;
import de.sijo.player_trading.logic.CancelTrade;
import de.sijo.player_trading.logic.ClaimTrade;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TradeListMenu
extends AbstractTradeNavigationMenu {
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int NEVER_CLOSE = 10;
    private final TradeDataUpdateHandlerListTrades dataUpdateHandler;

    public TradeListMenu(int containerId, Inventory inv, @NotNull RegistryFriendlyByteBuf extraData) {
        super((MenuType)ModMenuTypes.LIST_TRADES_MENU.get(), containerId, inv, extraData);
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.dataUpdateHandler = new TradeDataUpdateHandlerListTrades(serverPlayer, this.serializedDataProvider.getTradeActionType());
            this.dataUpdateHandler.startThread();
        } else {
            this.dataUpdateHandler = null;
        }
    }

    public AbstractTradeListDataProvider getDataProvider() {
        return this.serializedDataProvider;
    }

    public void executeTradeAction(Trade trade) {
        TradeListActionType actionType = this.serializedDataProvider.getTradeActionType();
        boolean result = false;
        try {
            result = switch (actionType) {
                default -> throw new MatchException(null, null);
                case TradeListActionType.CLAIM_TRADE -> {
                    if (ClaimTrade.claimSpecific(this.player, trade.id()) == 10) {
                        yield true;
                    }
                    yield false;
                }
                case TradeListActionType.ACCEPT_TRADE -> {
                    if (AcceptTrade.acceptTrade(this.player, trade.id()) == 10) {
                        yield true;
                    }
                    yield false;
                }
                case TradeListActionType.CANCEL_TRADE -> CancelTrade.cancelTrade(this.player, trade.id()) == 10;
            };
        }
        catch (Exception e) {
            this.player.sendSystemMessage((Component)Component.literal((String)("Error executing trade action: " + e.getMessage())).withStyle(ChatFormatting.RED));
        }
        if (result) {
            this.player.closeContainer();
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 9) {
            if (!this.moveItemStackTo(sourceStack, 9, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 0, 9, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    @Override
    public void removed(@Nonnull Player player) {
        super.removed(player);
        if (this.dataUpdateHandler != null) {
            this.dataUpdateHandler.stopThread();
        }
    }

    private void addPlayerInventory(Inventory inventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 136 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory inventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 194));
        }
    }
}

