/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.gui.create;

import com.mojang.blaze3d.systems.RenderSystem;
import de.sijo.player_trading.gui.AbstractTradeNavigationScreen;
import de.sijo.player_trading.gui.TradeMenuType;
import de.sijo.player_trading.gui.create.CreateTradeMenu;
import de.sijo.player_trading.gui.slot.PhantomSlot;
import de.sijo.player_trading.network.gui.SyncPhantomSlotPacket;
import de.sijo.player_trading.network.logic.CreateTradePacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class CreateTradeScreen
extends AbstractTradeNavigationScreen<CreateTradeMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"textures/gui/createtrade_gui.png");
    private Button createTradeButton;

    public CreateTradeScreen(CreateTradeMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title, TradeMenuType.CREATE_TRADE);
    }

    @Override
    protected void init() {
        super.init();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.createTradeButton = Button.builder((Component)Component.literal((String)"Create Trade"), this::onCreateTradeButtonPressed).bounds(x + 97, y + 68, 72, 12).build();
        this.addRenderableWidget((GuiEventListener)this.createTradeButton);
    }

    private void onCreateTradeButtonPressed(Button button) {
        if (!((CreateTradeMenu)this.menu).isValidTrade()) {
            this.minecraft.player.sendSystemMessage((Component)Component.literal((String)"\u00a7cBoth offer and request sides must have at least one item!"));
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new CreateTradePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.drawString(this.font, "Offer", x + 8, y + 22, 0x404040, false);
        guiGraphics.drawString(this.font, "Request", x + 116, y + 22, 0x404040, false);
        this.updateCreateTradeButton();
    }

    public int getGuiLeft() {
        return (this.width - this.imageWidth) / 2;
    }

    public int getGuiTop() {
        return (this.height - this.imageHeight) / 2;
    }

    private void updateCreateTradeButton() {
        if (this.createTradeButton != null) {
            this.createTradeButton.active = ((CreateTradeMenu)this.menu).isValidTrade();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int guiLeft = (this.width - this.imageWidth) / 2;
        int guiTop = (this.height - this.imageHeight) / 2;
        PhantomSlot[] phantomSlots = ((CreateTradeMenu)this.menu).getPhantomRequestSlots();
        for (int i = 0; i < phantomSlots.length; ++i) {
            PhantomSlot phantomSlot;
            int slotX = guiLeft + 116 + i * 18;
            int slotY = guiTop + 34;
            if (!(mouseX >= (double)slotX) || !(mouseX < (double)(slotX + 16)) || !(mouseY >= (double)slotY) || !(mouseY < (double)(slotY + 16)) || (phantomSlot = phantomSlots[i]) == null) continue;
            return this.handlePhantomSlotClick(phantomSlot, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private boolean handlePhantomSlotClick(PhantomSlot phantomSlot, int button) {
        ItemStack carriedItem = ((CreateTradeMenu)this.menu).getCarried();
        boolean hasControlDown = CreateTradeScreen.hasControlDown();
        boolean hasShiftDown = CreateTradeScreen.hasShiftDown();
        boolean hasAltDown = CreateTradeScreen.hasAltDown();
        if (button == 0) {
            if (!carriedItem.isEmpty()) {
                ItemStack current = phantomSlot.getItem();
                if (current.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)current, (ItemStack)carriedItem)) {
                    ItemStack newItem = carriedItem.copyWithCount(carriedItem.getCount());
                    ((CreateTradeMenu)this.menu).setPhantomItem(phantomSlot.getContainerSlot(), newItem);
                    PacketDistributor.sendToServer((CustomPacketPayload)new SyncPhantomSlotPacket(phantomSlot.getContainerSlot(), newItem), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else {
                if (hasControlDown && hasShiftDown) {
                    phantomSlot.decreaseCount(10);
                } else if (hasShiftDown) {
                    phantomSlot.decreaseCount(1);
                } else if (hasControlDown) {
                    phantomSlot.increaseCount(10);
                } else if (hasAltDown) {
                    phantomSlot.increaseCount(64);
                } else {
                    phantomSlot.increaseCount(1);
                }
                if (!phantomSlot.getItem().isEmpty()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new SyncPhantomSlotPacket(phantomSlot.getContainerSlot(), phantomSlot.getItem()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        } else if (button == 1) {
            if (!carriedItem.isEmpty()) {
                ItemStack current = phantomSlot.getItem();
                if (current.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)current, (ItemStack)carriedItem)) {
                    ItemStack newItem = carriedItem.copyWithCount(1);
                    ((CreateTradeMenu)this.menu).setPhantomItem(phantomSlot.getContainerSlot(), newItem);
                    PacketDistributor.sendToServer((CustomPacketPayload)new SyncPhantomSlotPacket(phantomSlot.getContainerSlot(), newItem), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else {
                phantomSlot.clearPhantomItem();
                PacketDistributor.sendToServer((CustomPacketPayload)SyncPhantomSlotPacket.clear(phantomSlot.getContainerSlot()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return true;
    }
}

