/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.gui.create;

import de.sijo.player_trading.PlayerTradingMod;
import de.sijo.player_trading.data.model.Trade;
import de.sijo.player_trading.data.persistence.TradeRepository;
import de.sijo.player_trading.gui.AbstractTradeNavigationMenu;
import de.sijo.player_trading.gui.TradeMenuType;
import de.sijo.player_trading.gui.slot.PhantomSlot;
import de.sijo.player_trading.init.ModMenuTypes;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class CreateTradeMenu
extends AbstractTradeNavigationMenu {
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int OFFER_SLOT_COUNT = 3;
    private static final int REQUEST_SLOT_COUNT = 3;
    private static final int TE_INVENTORY_SLOT_COUNT = 6;
    private final Level level;
    private final ItemStackHandler offerSlots;
    private final SimpleContainer requestContainer;
    private final PhantomSlot[] phantomRequestSlots;

    public CreateTradeMenu(int containerId, Inventory inv) {
        super((MenuType)ModMenuTypes.CREATE_TRADE_MENU.get(), containerId, inv, TradeMenuType.CREATE_TRADE);
        this.level = inv.player.level();
        this.offerSlots = new ItemStackHandler(3);
        this.requestContainer = new SimpleContainer(3);
        this.phantomRequestSlots = new PhantomSlot[3];
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.createTradeView();
    }

    public CreateTradeMenu(int containerId, Inventory inv, RegistryFriendlyByteBuf extraData) {
        this(containerId, inv);
    }

    public void clicked(int slotId, int dragType, ClickType click, Player player) {
        Slot slot;
        Slot slot2 = slot = slotId > -1 && slotId < this.slots.size() ? (Slot)this.slots.get(slotId) : null;
        if (slot instanceof PhantomSlot) {
            PhantomSlot phantomSlot = (PhantomSlot)slot;
            ItemStack carriedItem = this.getCarried();
            if (click == ClickType.PICKUP) {
                if (dragType == 0) {
                    ItemStack current;
                    if (!carriedItem.isEmpty() && ((current = phantomSlot.getItem()).isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)current, (ItemStack)carriedItem))) {
                        this.setPhantomItem(phantomSlot.getContainerSlot(), carriedItem.copy());
                    }
                } else if (dragType == 1) {
                    if (!carriedItem.isEmpty()) {
                        ItemStack current = phantomSlot.getItem();
                        if (current.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)current, (ItemStack)carriedItem)) {
                            this.setPhantomItem(phantomSlot.getContainerSlot(), carriedItem.copyWithCount(1));
                        }
                    } else {
                        phantomSlot.clearPhantomItem();
                    }
                }
            }
            return;
        }
        super.clicked(slotId, dragType, click, player);
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return !(slot instanceof PhantomSlot);
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 39, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 39) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 42) {
            if (sourceSlot instanceof PhantomSlot) {
                PhantomSlot phantomSlot = (PhantomSlot)sourceSlot;
                phantomSlot.set(ItemStack.EMPTY);
                return ItemStack.EMPTY;
            }
        } else {
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    @Override
    public void removed(@Nonnull Player player) {
        super.removed(player);
        if (!this.level.isClientSide()) {
            for (int i = 0; i < this.offerSlots.getSlots(); ++i) {
                ItemStack itemStack = this.offerSlots.getStackInSlot(i);
                if (itemStack.isEmpty()) continue;
                player.getInventory().placeItemBackInInventory(itemStack);
                this.offerSlots.setStackInSlot(i, ItemStack.EMPTY);
            }
            this.requestContainer.clearContent();
        }
    }

    private void addPlayerInventory(Inventory inventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory inventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 142));
        }
    }

    private void createTradeView() {
        int i;
        for (i = 0; i < 3; ++i) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.offerSlots, i, 8 + i * 18, 34));
        }
        for (i = 0; i < 3; ++i) {
            PhantomSlot phantomSlot;
            this.phantomRequestSlots[i] = phantomSlot = new PhantomSlot((Container)this.requestContainer, i, 116 + i * 18, 34);
            this.addSlot(phantomSlot);
        }
    }

    public void createTrade(Player player) {
        int i;
        PlayerTradingMod.LOGGER.info("Player {} attempting to create trade", (Object)player.getName().getString());
        if (!this.isValidTrade()) {
            PlayerTradingMod.LOGGER.warn("Trade creation failed for player {}: invalid trade (missing offer or request items)", (Object)player.getName().getString());
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cCannot create trade: Both offer and request sides must have at least one item!"));
            return;
        }
        int itemsOfferedNumber = 3;
        int itemsRequestedNumber = 3;
        ItemStack[] itemsOffered = new ItemStack[itemsOfferedNumber];
        ItemStack[] itemsRequested = new ItemStack[itemsRequestedNumber];
        for (i = 0; i < itemsOfferedNumber; ++i) {
            itemsOffered[i] = this.offerSlots.getStackInSlot(i);
        }
        for (i = 0; i < itemsRequestedNumber; ++i) {
            itemsRequested[i] = this.requestContainer.getItem(i);
        }
        StringBuilder offerDetails = new StringBuilder();
        StringBuilder requestDetails = new StringBuilder();
        for (ItemStack stack : itemsOffered) {
            if (stack == null || stack.isEmpty()) continue;
            if (offerDetails.length() > 0) {
                offerDetails.append(", ");
            }
            offerDetails.append(stack.getCount()).append("x ").append(stack.getItem().toString());
        }
        for (ItemStack stack : itemsRequested) {
            if (stack == null || stack.isEmpty()) continue;
            if (requestDetails.length() > 0) {
                requestDetails.append(", ");
            }
            requestDetails.append(stack.getCount()).append("x ").append(stack.getItem().toString());
        }
        PlayerTradingMod.LOGGER.info("Creating trade for player {} - Offering: [{}], Requesting: [{}]", new Object[]{player.getName().getString(), offerDetails.toString(), requestDetails.toString()});
        for (int i2 = 0; i2 < itemsOfferedNumber; ++i2) {
            this.offerSlots.setStackInSlot(i2, ItemStack.EMPTY);
        }
        TradeRepository repository = TradeRepository.getInstance();
        int tradeId = repository.getNextId();
        Trade tradeOffer = Trade.createOffer(tradeId, itemsOffered, itemsRequested, player.getUUID(), player.getName().getString());
        try {
            repository.addTrade(tradeOffer);
            PlayerTradingMod.LOGGER.info("Successfully created trade #{} for player {} - data persisted to SavedData", (Object)tradeId, (Object)player.getName().getString());
        }
        catch (Exception e) {
            PlayerTradingMod.LOGGER.error("Failed to persist trade #{} for player {}: {}", new Object[]{tradeId, player.getName().getString(), e.getMessage(), e});
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cFailed to create trade due to storage error!"));
            return;
        }
        player.sendSystemMessage((Component)Component.literal((String)("\u00a7aTrade offer #" + tradeOffer.id() + " created successfully!")));
        StringBuilder offerText = new StringBuilder();
        StringBuilder requestText = new StringBuilder();
        boolean hasOffer = false;
        for (ItemStack stack : itemsOffered) {
            if (stack == null || stack.isEmpty()) continue;
            if (hasOffer) {
                offerText.append(", ");
            }
            offerText.append(stack.getCount()).append("x ").append(stack.getHoverName().getString());
            hasOffer = true;
        }
        boolean hasRequest = false;
        for (ItemStack stack : itemsRequested) {
            if (stack == null || stack.isEmpty()) continue;
            if (hasRequest) {
                requestText.append(", ");
            }
            requestText.append(stack.getCount()).append("x ").append(stack.getHoverName().getString());
            hasRequest = true;
        }
        if (hasOffer || hasRequest) {
            String details = "\u00a77Offering: \u00a7f" + (hasOffer ? offerText.toString() : "Nothing") + " \u00a77| Requesting: \u00a7f" + (hasRequest ? requestText.toString() : "Nothing");
            player.sendSystemMessage((Component)Component.literal((String)details));
        }
        player.closeContainer();
    }

    public PhantomSlot[] getPhantomRequestSlots() {
        return this.phantomRequestSlots;
    }

    public PhantomSlot getPhantomSlot(int index) {
        if (index >= 0 && index < this.phantomRequestSlots.length) {
            return this.phantomRequestSlots[index];
        }
        return null;
    }

    public SimpleContainer getRequestContainer() {
        return this.requestContainer;
    }

    private boolean hasOfferItems() {
        for (int i = 0; i < this.offerSlots.getSlots(); ++i) {
            if (this.offerSlots.getStackInSlot(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean hasRequestItems() {
        for (int i = 0; i < this.requestContainer.getContainerSize(); ++i) {
            ItemStack item = this.requestContainer.getItem(i);
            if (item == null || item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isValidTrade() {
        return this.hasOfferItems() && this.hasRequestItems();
    }

    public void setPhantomItem(int slotIndex, ItemStack itemStack) {
        if (slotIndex >= 0 && slotIndex < this.requestContainer.getContainerSize()) {
            if (!itemStack.isEmpty()) {
                ItemStack template = itemStack.copy();
                this.requestContainer.setItem(slotIndex, template);
                if (this.phantomRequestSlots[slotIndex] != null) {
                    this.phantomRequestSlots[slotIndex].setChanged();
                }
            } else {
                this.requestContainer.setItem(slotIndex, ItemStack.EMPTY);
                if (this.phantomRequestSlots[slotIndex] != null) {
                    this.phantomRequestSlots[slotIndex].setChanged();
                }
            }
        }
    }
}

