/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.sijo.player_trading.gui.TradeMenuType;
import de.sijo.player_trading.network.gui.NavigateMenuPacket;
import de.sijo.player_trading.network.logic.ClaimAllPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class AbstractTradeNavigationScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected static final int ICON_BUTTON_SIZE = 18;
    protected static final int ICON_BUTTON_SPACING = 2;
    protected static final int ICON_COLUMN_X = -25;
    protected static final int ICON_COLUMN_START_Y = 30;
    private static final ResourceLocation CLAIM_TRADE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"textures/gui/buttons/menu/claim_trade.png");
    private static final ResourceLocation CLAIM_ALL_TRADES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"textures/gui/buttons/menu/claim_all_trades.png");
    private static final ResourceLocation LIST_TRADE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"textures/gui/buttons/menu/list_trade.png");
    private static final ResourceLocation CREATE_TRADE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"textures/gui/buttons/menu/create_trade.png");
    private static final ResourceLocation PENDING_TRADES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"textures/gui/buttons/menu/cancel_trade.png");
    private static final ResourceLocation CLAIM_TRADE_NOTIF_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"textures/gui/buttons/menu/notification/claim_trade.png");
    private static final ResourceLocation LIST_TRADE_NOTIF_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"textures/gui/buttons/menu/notification/list_trade.png");
    private static final ResourceLocation PENDING_TRADES_NOTIF_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"textures/gui/buttons/menu/notification/cancel_trade.png");
    private static final int CLAIM_MENU_BUTTON_X = -25;
    private static final int LIST_TRADE_MENU_BUTTON_X = -25;
    private static final int CREATE_TRADE_MENU_BUTTON_X = -25;
    private static final int PENDING_TRADE_MENU_BUTTON_X = -25;
    private static final int CLAIM_ALL_TRADES_BUTTON_X = -25;
    private static final int CLAIM_MENU_BUTTON_Y = 30;
    private static final int LIST_TRADE_MENU_BUTTON2_Y = 50;
    private static final int CREATE_TRADE_MENU_BUTTON3_Y = 70;
    private static final int PENDING_TRADE_MENU_BUTTON4_Y = 90;
    private static final int CLAIM_ALL_TRADES_BUTTON_Y = 110;
    protected Button claimButton;
    protected Button listTradeButton;
    protected Button createTradeButton;
    protected Button pendingTradesButton;
    protected Button claimAllTradesButton;
    protected Component hoveredButtonTooltip;
    private TradeMenuType menuType;
    private ResourceLocation claimTradeTexture = CLAIM_TRADE_TEXTURE;
    private ResourceLocation listTradeTexture = LIST_TRADE_TEXTURE;
    private ResourceLocation pendingTradeTexture = PENDING_TRADES_TEXTURE;
    private ResourceLocation claimAllTradesTexture = CLAIM_ALL_TRADES_TEXTURE;

    protected AbstractTradeNavigationScreen(T menu, Inventory playerInventory, Component title, TradeMenuType type) {
        super(menu, playerInventory, title);
        this.menuType = type;
    }

    protected void init() {
        super.init();
        this.initTradeIconButtons();
    }

    protected void initTradeIconButtons() {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.claimButton = this.createIconButton(x + -25, y + 30, this::onClaimTradeClick);
        this.addRenderableWidget((GuiEventListener)this.claimButton);
        this.listTradeButton = this.createIconButton(x + -25, y + 50, this::onListTradeClick);
        this.addRenderableWidget((GuiEventListener)this.listTradeButton);
        this.createTradeButton = this.createIconButton(x + -25, y + 70, this::onCreateTradeClick);
        this.addRenderableWidget((GuiEventListener)this.createTradeButton);
        this.pendingTradesButton = this.createIconButton(x + -25, y + 90, this::onPendingTradesClick);
        this.addRenderableWidget((GuiEventListener)this.pendingTradesButton);
        this.claimAllTradesButton = this.createIconButton(x + -25, y + 110, this::onClaimALlTradesClick);
        this.addRenderableWidget((GuiEventListener)this.claimAllTradesButton);
        this.updateButtonStates();
    }

    private Button createIconButton(int x, int y, Button.OnPress onPress) {
        return Button.builder((Component)Component.literal((String)""), (Button.OnPress)onPress).bounds(x, y, 18, 18).build();
    }

    protected void renderTradeIconButtons(GuiGraphics guiGraphics, int guiLeft, int guiTop, int mouseX, int mouseY) {
        this.renderIconButton(guiGraphics, guiLeft, guiTop, -25, 30, this.claimTradeTexture, this.claimButton);
        this.renderIconButton(guiGraphics, guiLeft, guiTop, -25, 50, this.listTradeTexture, this.listTradeButton);
        this.renderIconButton(guiGraphics, guiLeft, guiTop, -25, 70, CREATE_TRADE_TEXTURE, this.createTradeButton);
        this.renderIconButton(guiGraphics, guiLeft, guiTop, -25, 90, this.pendingTradeTexture, this.pendingTradesButton);
        this.renderIconButton(guiGraphics, guiLeft, guiTop, -25, 110, this.claimAllTradesTexture, this.claimAllTradesButton);
        this.checkButtonHover(guiLeft, guiTop, mouseX, mouseY);
    }

    private void renderIconButton(GuiGraphics guiGraphics, int guiLeft, int guiTop, int buttonX, int buttonY, ResourceLocation texture, Button button) {
        if (button != null) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            int iconX = guiLeft + buttonX;
            int iconY = guiTop + buttonY;
            guiGraphics.blit(texture, iconX, iconY, 0.0f, 0.0f, 18, 18, 18, 18);
        }
    }

    private void checkButtonHover(int guiLeft, int guiTop, int mouseX, int mouseY) {
        this.hoveredButtonTooltip = null;
        if (this.isMouseOverButton(mouseX, mouseY, guiLeft + -25, guiTop + 30)) {
            this.hoveredButtonTooltip = Component.literal((String)"Claim Trades");
        } else if (this.isMouseOverButton(mouseX, mouseY, guiLeft + -25, guiTop + 50)) {
            this.hoveredButtonTooltip = Component.literal((String)"List Trades");
        } else if (this.isMouseOverButton(mouseX, mouseY, guiLeft + -25, guiTop + 70)) {
            this.hoveredButtonTooltip = Component.literal((String)"Create New Trade");
        } else if (this.isMouseOverButton(mouseX, mouseY, guiLeft + -25, guiTop + 90)) {
            this.hoveredButtonTooltip = Component.literal((String)"View Pending Trades");
        } else if (this.isMouseOverButton(mouseX, mouseY, guiLeft + -25, guiTop + 110)) {
            this.hoveredButtonTooltip = Component.literal((String)"Claim All Trades");
        }
    }

    private boolean isMouseOverButton(int mouseX, int mouseY, int buttonX, int buttonY) {
        return mouseX >= buttonX && mouseX < buttonX + 18 && mouseY >= buttonY && mouseY < buttonY + 18;
    }

    protected void renderTradeButtonTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.hoveredButtonTooltip != null) {
            guiGraphics.renderTooltip(this.font, this.hoveredButtonTooltip, mouseX, mouseY);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderTradeIconButtons(guiGraphics, x, y, mouseX, mouseY);
        this.renderTradeButtonTooltips(guiGraphics, mouseX, mouseY);
    }

    protected void onClaimTradeClick(Button button) {
        if (button.active) {
            PacketDistributor.sendToServer((CustomPacketPayload)new NavigateMenuPacket(TradeMenuType.CLAIM_TRADES), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void onListTradeClick(Button button) {
        if (button.active) {
            PacketDistributor.sendToServer((CustomPacketPayload)new NavigateMenuPacket(TradeMenuType.LIST_TRADES), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void onCreateTradeClick(Button button) {
        if (button.active) {
            PacketDistributor.sendToServer((CustomPacketPayload)new NavigateMenuPacket(TradeMenuType.CREATE_TRADE), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void onPendingTradesClick(Button button) {
        if (button.active) {
            PacketDistributor.sendToServer((CustomPacketPayload)new NavigateMenuPacket(TradeMenuType.PENDING_TRADES), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void onClaimALlTradesClick(Button button) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ClaimAllPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        button.setFocused(false);
        this.setFocused(null);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.removeWidget((GuiEventListener)this.claimAllTradesButton);
        this.claimAllTradesButton = this.createIconButton(x + -25, y + 110, this::onClaimALlTradesClick);
        this.addRenderableWidget((GuiEventListener)this.claimAllTradesButton);
    }

    private void updateButtonStates() {
        switch (this.menuType) {
            case CLAIM_TRADES: {
                this.claimButton.active = false;
                this.listTradeButton.active = true;
                this.createTradeButton.active = true;
                this.pendingTradesButton.active = true;
                break;
            }
            case LIST_TRADES: {
                this.listTradeButton.active = false;
                this.claimButton.active = true;
                this.createTradeButton.active = true;
                this.pendingTradesButton.active = true;
                break;
            }
            case CREATE_TRADE: {
                this.createTradeButton.active = false;
                this.claimButton.active = true;
                this.listTradeButton.active = true;
                this.pendingTradesButton.active = true;
                break;
            }
            case PENDING_TRADES: {
                this.pendingTradesButton.active = false;
                this.claimButton.active = true;
                this.listTradeButton.active = true;
                this.createTradeButton.active = true;
            }
        }
    }

    public void updateMenuNotificationState(boolean pendingMenu, boolean listMenu, boolean claimMenu) {
        if (pendingMenu) {
            this.pendingTradeTexture = PENDING_TRADES_NOTIF_TEXTURE;
        }
        if (listMenu) {
            this.listTradeTexture = LIST_TRADE_NOTIF_TEXTURE;
        }
        if (claimMenu) {
            this.claimTradeTexture = CLAIM_TRADE_NOTIF_TEXTURE;
        }
    }
}

