/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.gui;

import de.sijo.player_trading.data.update_watcher.TradeDataUpdateHandlerMenuNotification;
import de.sijo.player_trading.gui.TradeMenuType;
import de.sijo.player_trading.gui.list.data_provider.AbstractTradeListDataProvider;
import de.sijo.player_trading.gui.list.data_provider.TradeListActionType;
import de.sijo.player_trading.gui.list.data_provider.TradeListDataProviderDeserialize;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public abstract class AbstractTradeNavigationMenu
extends AbstractContainerMenu {
    protected final Player player;
    protected final AbstractTradeListDataProvider serializedDataProvider;
    private TradeDataUpdateHandlerMenuNotification notifUpdateHandler;

    protected AbstractTradeNavigationMenu(MenuType<?> menuType, int containerId, Inventory inv, TradeMenuType tradeMenuType) {
        super(menuType, containerId);
        this.player = inv.player;
        this.serializedDataProvider = null;
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.notifUpdateHandler = new TradeDataUpdateHandlerMenuNotification(tradeMenuType, serverPlayer);
            this.notifUpdateHandler.startThread();
        } else {
            this.notifUpdateHandler = null;
        }
    }

    protected AbstractTradeNavigationMenu(MenuType<?> menuType, int containerId, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(menuType, containerId);
        this.player = inv.player;
        if (extraData == null) {
            this.serializedDataProvider = null;
            this.notifUpdateHandler = null;
            return;
        }
        this.serializedDataProvider = new TradeListDataProviderDeserialize(extraData);
        TradeMenuType tradeMenuType = switch (this.serializedDataProvider.getTradeActionType()) {
            default -> throw new MatchException(null, null);
            case TradeListActionType.CLAIM_TRADE -> TradeMenuType.CLAIM_TRADES;
            case TradeListActionType.ACCEPT_TRADE -> TradeMenuType.LIST_TRADES;
            case TradeListActionType.CANCEL_TRADE -> TradeMenuType.PENDING_TRADES;
        };
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.notifUpdateHandler = new TradeDataUpdateHandlerMenuNotification(tradeMenuType, serverPlayer);
            this.notifUpdateHandler.startThread();
        } else {
            this.notifUpdateHandler = null;
        }
    }

    public void removed(@Nonnull Player player) {
        super.removed(player);
        if (this.notifUpdateHandler != null) {
            this.notifUpdateHandler.stopThread();
        }
    }
}

