/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.data.update_watcher;

import de.sijo.player_trading.data.update_watcher.TradeDataUpdateHandler;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class TradeDataUpdateNotificationManager {
    private static TradeDataUpdateNotificationManager instance;
    private final Set<TradeDataUpdateHandler> registeredHandlers = ConcurrentHashMap.newKeySet();

    private TradeDataUpdateNotificationManager() {
    }

    public static TradeDataUpdateNotificationManager getInstance() {
        if (instance == null) {
            instance = new TradeDataUpdateNotificationManager();
        }
        return instance;
    }

    public void registerHandler(TradeDataUpdateHandler handler) {
        this.registeredHandlers.add(handler);
    }

    public void unregisterHandler(TradeDataUpdateHandler handler) {
        this.registeredHandlers.remove(handler);
    }

    public void notifyDataChanged() {
        if (this.registeredHandlers.isEmpty()) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            for (TradeDataUpdateHandler handler : this.registeredHandlers) {
                try {
                    handler.onDataChanged();
                }
                catch (Exception e) {
                    System.err.println("Error notifying data update handler: " + e.getMessage());
                    this.registeredHandlers.remove(handler);
                }
            }
        });
    }
}

