/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.data.update_watcher;

import de.sijo.player_trading.data.persistence.TradeRepository;
import de.sijo.player_trading.data.update_watcher.TradeDataUpdateHandler;
import de.sijo.player_trading.data.update_watcher.TradeDataUpdateNotificationManager;
import de.sijo.player_trading.gui.TradeMenuType;
import de.sijo.player_trading.gui.list.TradeListMenu;
import de.sijo.player_trading.gui.list.data_provider.TradeListDataProviderAllTrades;
import de.sijo.player_trading.gui.list.data_provider.TradeListDataProviderForPlayer;
import de.sijo.player_trading.gui.list.data_provider.TradeListDataProviderListClaim;
import de.sijo.player_trading.network.gui.UpdateMenuNotifPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public class TradeDataUpdateHandlerMenuNotification
implements TradeDataUpdateHandler {
    private final TradeDataUpdateNotificationManager notificationManager;
    private final TradeMenuType tradeMenuType;
    private final ServerPlayer serverPlayer;
    private volatile boolean active = false;
    private boolean pendingMenuActive = false;
    private boolean listMenuActive = false;
    private boolean claimMenuActive = false;
    private boolean pendingMenuNotified = false;
    private boolean listMenuNotified = false;
    private boolean claimMenuNotified = false;
    private int pendingMenuHashCode;
    private int listMenuHashCode;
    private int claimMenuHashCode;
    private TradeListDataProviderAllTrades ListTradesDataProvider;
    private TradeListDataProviderListClaim claimTradesDataProvider;
    private TradeListDataProviderForPlayer pendingTradesDataProvider;

    public TradeDataUpdateHandlerMenuNotification(TradeMenuType tradeMenuType, ServerPlayer player) {
        this.tradeMenuType = tradeMenuType;
        this.serverPlayer = player;
        this.notificationManager = TradeDataUpdateNotificationManager.getInstance();
        switch (tradeMenuType) {
            case LIST_TRADES: {
                this.listMenuActive = true;
                break;
            }
            case CLAIM_TRADES: {
                this.claimMenuActive = true;
                break;
            }
            case PENDING_TRADES: {
                this.pendingMenuActive = true;
                break;
            }
        }
        this.ListTradesDataProvider = new TradeListDataProviderAllTrades(player.getName().getString());
        this.claimTradesDataProvider = new TradeListDataProviderListClaim(player.getUUID());
        this.pendingTradesDataProvider = new TradeListDataProviderForPlayer(player.getName().getString());
        this.pendingMenuHashCode = TradeRepository.calculateDataHashForTrades(this.pendingTradesDataProvider.getTrades());
        this.claimMenuHashCode = TradeRepository.calculateDataHashForTrades(this.claimTradesDataProvider.getTrades());
        this.listMenuHashCode = TradeRepository.calculateDataHashForTrades(this.ListTradesDataProvider.getTrades());
    }

    @Override
    public void startThread() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.notificationManager.registerHandler(this);
    }

    @Override
    public void stopThread() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.notificationManager.unregisterHandler(this);
    }

    @Override
    public void onDataChanged() {
        if (!this.active || this.serverPlayer == null || !this.serverPlayer.isAlive()) {
            this.stopThread();
            return;
        }
        if (!(this.serverPlayer.containerMenu instanceof TradeListMenu)) {
            this.stopThread();
            return;
        }
        this.checkNewData();
    }

    private void checkNewData() {
        boolean changed = false;
        if (!this.pendingMenuNotified && !this.pendingMenuActive && this.pendingMenuHashCode != TradeRepository.calculateDataHashForTrades(this.pendingTradesDataProvider.getTrades())) {
            this.pendingMenuNotified = true;
            changed = true;
        }
        if (!this.listMenuNotified && !this.listMenuActive && this.listMenuHashCode != TradeRepository.calculateDataHashForTrades(this.ListTradesDataProvider.getTrades())) {
            this.listMenuNotified = true;
            changed = true;
        }
        if (!this.claimMenuNotified && !this.claimMenuActive && this.claimMenuHashCode != TradeRepository.calculateDataHashForTrades(this.claimTradesDataProvider.getTrades())) {
            this.claimMenuNotified = true;
            changed = true;
        }
        if (changed) {
            PacketDistributor.sendToPlayer((ServerPlayer)this.serverPlayer, (CustomPacketPayload)new UpdateMenuNotifPacket(this.pendingMenuNotified, this.listMenuNotified, this.claimMenuNotified), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

