/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.data.update_watcher;

import de.sijo.player_trading.data.model.Trade;
import de.sijo.player_trading.data.persistence.TradeRepository;
import de.sijo.player_trading.data.update_watcher.TradeDataUpdateHandler;
import de.sijo.player_trading.data.update_watcher.TradeDataUpdateNotificationManager;
import de.sijo.player_trading.gui.list.TradeListMenu;
import de.sijo.player_trading.gui.list.data_provider.AbstractTradeListDataProvider;
import de.sijo.player_trading.gui.list.data_provider.TradeListActionType;
import de.sijo.player_trading.gui.list.data_provider.TradeListDataProviderAllTrades;
import de.sijo.player_trading.gui.list.data_provider.TradeListDataProviderForPlayer;
import de.sijo.player_trading.gui.list.data_provider.TradeListDataProviderListClaim;
import de.sijo.player_trading.network.data_update.NewTradeListDataPacket;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.connection.ConnectionType;

public class TradeDataUpdateHandlerListTrades
implements TradeDataUpdateHandler {
    private final ServerPlayer serverPlayer;
    private final AbstractTradeListDataProvider dataProvider;
    private final TradeDataUpdateNotificationManager notificationManager;
    private int dataHash;
    private volatile boolean active = false;

    public TradeDataUpdateHandlerListTrades(ServerPlayer serverPlayer, TradeListActionType actionType) {
        this.serverPlayer = serverPlayer;
        this.dataProvider = switch (actionType) {
            default -> throw new MatchException(null, null);
            case TradeListActionType.CLAIM_TRADE -> new TradeListDataProviderListClaim(serverPlayer.getUUID());
            case TradeListActionType.ACCEPT_TRADE -> new TradeListDataProviderAllTrades(serverPlayer.getName().getString());
            case TradeListActionType.CANCEL_TRADE -> new TradeListDataProviderForPlayer(serverPlayer.getName().getString());
        };
        this.notificationManager = TradeDataUpdateNotificationManager.getInstance();
        List<Trade> trades = this.dataProvider.getTrades();
        this.dataHash = TradeRepository.calculateDataHashForTrades(trades);
    }

    @Override
    public void startThread() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.notificationManager.registerHandler(this);
    }

    @Override
    public void stopThread() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.notificationManager.unregisterHandler(this);
    }

    @Override
    public void onDataChanged() {
        if (!this.active || this.serverPlayer == null || !this.serverPlayer.isAlive()) {
            this.stopThread();
            return;
        }
        if (!(this.serverPlayer.containerMenu instanceof TradeListMenu)) {
            this.stopThread();
            return;
        }
        this.checkNewData();
    }

    private void checkNewData() {
        List<Trade> trades = this.dataProvider.getTrades();
        int localDataHash = TradeRepository.calculateDataHashForTrades(trades);
        if (localDataHash != this.dataHash) {
            this.dataHash = localDataHash;
            RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), this.serverPlayer.registryAccess(), ConnectionType.NEOFORGE);
            buffer.writeInt(trades.size());
            for (Trade trade : trades) {
                trade.writeToBuffer(buffer);
            }
            PacketDistributor.sendToPlayer((ServerPlayer)this.serverPlayer, (CustomPacketPayload)new NewTradeListDataPacket(buffer.array()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

