/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.data.persistence;

import de.sijo.player_trading.PlayerTradingMod;
import de.sijo.player_trading.data.model.Trade;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;

public class TradingSavedData
extends SavedData {
    private final Map<Integer, Trade> allTrades = new ConcurrentHashMap<Integer, Trade>();
    private final Object lock = new Object();
    private int idCounter = 0;

    public static TradingSavedData create() {
        PlayerTradingMod.LOGGER.info("Creating new trading data storage");
        return new TradingSavedData();
    }

    public static TradingSavedData load(CompoundTag tag, HolderLookup.Provider registryLookup) {
        PlayerTradingMod.LOGGER.info("Loading trading data from persistent storage");
        if (tag.isEmpty()) {
            PlayerTradingMod.LOGGER.info("No existing trading data found, creating new storage");
            return TradingSavedData.create();
        }
        TradingSavedData data = new TradingSavedData();
        try {
            if (tag.contains("allTrades")) {
                ListTag tradesTag = tag.getList("allTrades", 10);
                for (int i = 0; i < tradesTag.size(); ++i) {
                    try {
                        CompoundTag tradeTag = tradesTag.getCompound(i);
                        Trade trade = data.loadTradeFromTag(tradeTag, registryLookup);
                        data.allTrades.put(trade.id(), trade);
                        continue;
                    }
                    catch (Exception e) {
                        PlayerTradingMod.LOGGER.error("Failed to load trade at index {}: {}", new Object[]{i, e.getMessage(), e});
                    }
                }
            } else {
                Trade trade;
                int i;
                if (tag.contains("tradeOffers")) {
                    ListTag offersTag = tag.getList("tradeOffers", 10);
                    for (i = 0; i < offersTag.size(); ++i) {
                        try {
                            CompoundTag offerTag = offersTag.getCompound(i);
                            trade = data.loadTradeFromTag(offerTag, registryLookup);
                            data.allTrades.put(trade.id(), trade);
                            continue;
                        }
                        catch (Exception e) {
                            PlayerTradingMod.LOGGER.error("Failed to load legacy trade offer at index {}: {}", new Object[]{i, e.getMessage(), e});
                        }
                    }
                }
                if (tag.contains("completedTrades")) {
                    ListTag completedTag = tag.getList("completedTrades", 10);
                    for (i = 0; i < completedTag.size(); ++i) {
                        try {
                            CompoundTag tradeTag = completedTag.getCompound(i);
                            trade = data.loadTradeFromTag(tradeTag, registryLookup);
                            data.allTrades.put(trade.id(), trade);
                            continue;
                        }
                        catch (Exception e) {
                            PlayerTradingMod.LOGGER.error("Failed to load legacy completed trade at index {}: {}", new Object[]{i, e.getMessage(), e});
                        }
                    }
                }
            }
            if (tag.contains("idCounter")) {
                data.idCounter = tag.getInt("idCounter");
            }
            PlayerTradingMod.LOGGER.info("Successfully loaded trading data - {} total trades", (Object)data.allTrades.size());
            return data;
        }
        catch (Exception e) {
            PlayerTradingMod.LOGGER.error("Failed to load trading data: {}", (Object)e.getMessage(), (Object)e);
            return TradingSavedData.create();
        }
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registryLookup) {
        PlayerTradingMod.LOGGER.info("Saving trading data: {} total trades", (Object)this.allTrades.size());
        try {
            ListTag tradesTag = new ListTag();
            for (Trade trade : this.allTrades.values()) {
                CompoundTag tradeTag = new CompoundTag();
                this.saveTradeToTag(trade, tradeTag, registryLookup);
                tradesTag.add((Object)tradeTag);
            }
            tag.put("allTrades", (Tag)tradesTag);
            tag.putInt("idCounter", this.idCounter);
            PlayerTradingMod.LOGGER.info("Trading data saved successfully to persistent storage");
            return tag;
        }
        catch (Exception e) {
            PlayerTradingMod.LOGGER.error("Failed to save trading data: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    public Stream<Trade> getAllTrades() {
        return this.allTrades.values().stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrade(Trade trade) {
        Object object = this.lock;
        synchronized (object) {
            this.allTrades.put(trade.id(), trade);
            this.setDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean removeTrade(Trade trade) {
        Object object = this.lock;
        synchronized (object) {
            boolean result = this.allTrades.remove(trade.id()) == null;
            this.setDirty();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean replacePendingTrade(Trade oldTrade, Trade newTrade) {
        Object object = this.lock;
        synchronized (object) {
            Trade existing = this.allTrades.get(oldTrade.id());
            if (existing == null || !existing.isPending() || !existing.equals(oldTrade)) {
                return false;
            }
            this.allTrades.put(newTrade.id(), newTrade);
            this.setDirty();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean removePendingTrade(Trade trade) {
        Object object = this.lock;
        synchronized (object) {
            Trade existing = this.allTrades.get(trade.id());
            if (existing == null || !existing.isPending() || !existing.equals(trade)) {
                return false;
            }
            this.allTrades.remove(trade.id());
            this.setDirty();
            return true;
        }
    }

    public Trade getTradeById(int id) {
        return this.allTrades.get(id);
    }

    public Trade getPendingTradeById(int id) {
        Trade trade = this.allTrades.get(id);
        return trade != null && trade.isPending() ? trade : null;
    }

    public synchronized int getNextId() {
        int nextId = ++this.idCounter;
        this.setDirty();
        return nextId;
    }

    private void saveTradeToTag(Trade trade, CompoundTag tag, HolderLookup.Provider registryLookup) {
        tag.putInt("id", trade.id());
        tag.putString("offerPlayerId", trade.offerPlayerId().toString());
        tag.putString("offerPlayerName", trade.offerPlayerName());
        if (trade.acceptPlayerId() != null) {
            tag.putString("acceptPlayerId", trade.acceptPlayerId().toString());
            tag.putString("acceptPlayerName", trade.acceptPlayerName());
            tag.putLong("completedTime", trade.completedTime());
        }
        ListTag offeredItemsTag = new ListTag();
        for (ItemStack stack : trade.ItemsOffer()) {
            if (stack.isEmpty()) continue;
            CompoundTag stackTag = (CompoundTag)stack.save(registryLookup);
            offeredItemsTag.add((Object)stackTag);
        }
        tag.put("itemsOffer", (Tag)offeredItemsTag);
        ListTag requestedItemsTag = new ListTag();
        for (ItemStack stack : trade.ItemsRequest()) {
            if (stack.isEmpty()) continue;
            CompoundTag stackTag = (CompoundTag)stack.save(registryLookup);
            requestedItemsTag.add((Object)stackTag);
        }
        tag.put("itemsRequest", (Tag)requestedItemsTag);
    }

    private Trade loadTradeFromTag(CompoundTag tradeTag, HolderLookup.Provider registryLookup) {
        int id = tradeTag.getInt("id");
        UUID offerPlayerId = UUID.fromString(tradeTag.getString("offerPlayerId"));
        String offerPlayerName = tradeTag.getString("offerPlayerName");
        UUID acceptPlayerId = null;
        String acceptPlayerName = null;
        long completedTime = 0L;
        if (tradeTag.contains("acceptPlayerId")) {
            acceptPlayerId = UUID.fromString(tradeTag.getString("acceptPlayerId"));
            acceptPlayerName = tradeTag.getString("acceptPlayerName");
            completedTime = tradeTag.getLong("completedTime");
        }
        ListTag offeredItemsTag = tradeTag.getList("itemsOffer", 10);
        ArrayList<ItemStack> offeredItems = new ArrayList<ItemStack>();
        for (int i = 0; i < offeredItemsTag.size(); ++i) {
            CompoundTag stackNbt = offeredItemsTag.getCompound(i);
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)registryLookup, (Tag)stackNbt).orElse(ItemStack.EMPTY);
            if (stack.isEmpty()) continue;
            offeredItems.add(stack);
        }
        ListTag requestedItemsTag = tradeTag.getList("itemsRequest", 10);
        ArrayList<ItemStack> requestedItems = new ArrayList<ItemStack>();
        for (int i = 0; i < requestedItemsTag.size(); ++i) {
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)registryLookup, (Tag)requestedItemsTag.getCompound(i)).orElse(ItemStack.EMPTY);
            if (stack.isEmpty()) continue;
            requestedItems.add(stack);
        }
        return new Trade(id, offeredItems.toArray(new ItemStack[0]), requestedItems.toArray(new ItemStack[0]), offerPlayerId, offerPlayerName, acceptPlayerId, acceptPlayerName, completedTime);
    }
}

