/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.data.persistence;

import de.sijo.player_trading.data.model.Trade;
import de.sijo.player_trading.data.persistence.TradingSavedData;
import de.sijo.player_trading.data.update_watcher.TradeDataUpdateNotificationManager;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class TradeRepository {
    private static TradeRepository instance;
    private MinecraftServer server;
    private volatile int cachedDataHash = 0;
    private volatile boolean hashValid = false;

    private TradeRepository() {
    }

    public static TradeRepository getInstance() {
        if (instance == null) {
            instance = new TradeRepository();
        }
        return instance;
    }

    public static int calculateDataHashForTrades(List<Trade> trades) {
        return Objects.hash(trades.toArray());
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    private TradingSavedData getSavedData() {
        if (this.server == null) {
            throw new IllegalStateException("Server not set in TradeRepository");
        }
        ServerLevel overworld = this.server.overworld();
        return (TradingSavedData)overworld.getDataStorage().computeIfAbsent(new SavedData.Factory(TradingSavedData::create, TradingSavedData::load), "trading_data");
    }

    public List<Trade> getAllTrades() {
        return this.getSavedData().getAllTrades().toList();
    }

    public List<Trade> getAllPendingTrades() {
        return this.getSavedData().getAllTrades().filter(Trade::isPending).toList();
    }

    public List<Trade> getCompletedTrades() {
        return this.getSavedData().getAllTrades().filter(Trade::isCompleted).toList();
    }

    public void addTrade(Trade trade) {
        this.getSavedData().addTrade(trade);
        this.invalidateHashCache();
    }

    public boolean removeTrade(Trade trade) {
        boolean removed = this.getSavedData().removeTrade(trade);
        if (removed) {
            this.invalidateHashCache();
        }
        return removed;
    }

    public boolean replacePendingTrade(Trade oldTrade, Trade newTrade) {
        boolean replaced = this.getSavedData().replacePendingTrade(oldTrade, newTrade);
        if (replaced) {
            this.invalidateHashCache();
        }
        return replaced;
    }

    public boolean removePendingTrade(Trade trade) {
        boolean removed = this.getSavedData().removePendingTrade(trade);
        if (removed) {
            this.invalidateHashCache();
        }
        return removed;
    }

    public Trade getPendingTradeById(int id) {
        return this.getSavedData().getPendingTradeById(id);
    }

    public int getNextId() {
        return this.getSavedData().getNextId();
    }

    public Trade getTradeById(int id) {
        return this.getSavedData().getTradeById(id);
    }

    public List<String> getPlayerNamesOfPendingTrades() {
        return this.getSavedData().getAllTrades().filter(Trade::isPending).map(Trade::offerPlayerName).distinct().toList();
    }

    public List<String> getPendingTradeIDs() {
        return this.getSavedData().getAllTrades().filter(Trade::isPending).map(Trade::id).map(Object::toString).toList();
    }

    public List<String> getPendingTradeIdsForPlayer(UUID playerId) {
        return this.getSavedData().getAllTrades().filter(offer -> offer.isPending() && offer.offerPlayerId().equals(playerId)).map(Trade::id).map(Object::toString).toList();
    }

    public Trade getCompletedTradeById(int id) {
        return this.getSavedData().getAllTrades().filter(trade -> trade.isCompleted() && trade.id() == id).findFirst().orElse(null);
    }

    public List<Trade> getCompletedTradesForSeller(UUID sellerId) {
        return this.getSavedData().getAllTrades().filter(trade -> trade.isCompleted() && trade.offerPlayerId().equals(sellerId)).toList();
    }

    public List<String> getCompletedTradeIdsForSeller(UUID sellerId) {
        return this.getSavedData().getAllTrades().filter(trade -> trade.isCompleted() && trade.offerPlayerId().equals(sellerId)).map(trade -> String.valueOf(trade.id())).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDataHash() {
        if (!this.hashValid) {
            TradeRepository tradeRepository = this;
            synchronized (tradeRepository) {
                if (!this.hashValid) {
                    this.cachedDataHash = this.calculateDataHash();
                    this.hashValid = true;
                }
            }
        }
        return this.cachedDataHash;
    }

    private void invalidateHashCache() {
        this.hashValid = false;
        TradeDataUpdateNotificationManager.getInstance().notifyDataChanged();
    }

    private int calculateDataHash() {
        return TradeRepository.calculateDataHashForTrades(this.getAllTrades());
    }

    public boolean hasDataChanged(int lastKnownHash) {
        return this.getDataHash() != lastKnownHash;
    }
}

