/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.data.persistence;

import de.sijo.player_trading.data.persistence.NotificationSavedData;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class PendingNotificationRepository {
    private static PendingNotificationRepository instance;
    private MinecraftServer server;

    private PendingNotificationRepository() {
    }

    public static PendingNotificationRepository getInstance() {
        if (instance == null) {
            instance = new PendingNotificationRepository();
        }
        return instance;
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    private NotificationSavedData getSavedData() {
        if (this.server == null) {
            throw new IllegalStateException("Server not set in PendingNotificationRepository");
        }
        ServerLevel overworld = this.server.overworld();
        return (NotificationSavedData)overworld.getDataStorage().computeIfAbsent(new SavedData.Factory(NotificationSavedData::create, NotificationSavedData::load), "notification_data");
    }

    public void addNotification(UUID playerId, String message) {
        this.getSavedData().addNotification(playerId, message);
    }

    public List<String> getNotifications(UUID playerId) {
        return this.getSavedData().getNotifications(playerId);
    }

    public void removeNotifications(UUID playerId) {
        this.getSavedData().removeNotifications(playerId);
    }

    public boolean hasNotifications(UUID playerId) {
        return this.getSavedData().hasNotifications(playerId);
    }
}

