/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.data.persistence;

import de.sijo.player_trading.PlayerTradingMod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;

public class NotificationSavedData
extends SavedData {
    private Map<UUID, List<String>> pendingNotifications = new HashMap<UUID, List<String>>();

    public static NotificationSavedData create() {
        PlayerTradingMod.LOGGER.info("Creating new notification data storage");
        return new NotificationSavedData();
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registryLookup) {
        PlayerTradingMod.LOGGER.info("Saving notification data: {} players with notifications", (Object)this.pendingNotifications.size());
        try {
            CompoundTag notificationsTag = new CompoundTag();
            for (Map.Entry<UUID, List<String>> entry : this.pendingNotifications.entrySet()) {
                ListTag playerNotifications = new ListTag();
                for (String notification : entry.getValue()) {
                    playerNotifications.add((Object)StringTag.valueOf((String)notification));
                }
                notificationsTag.put(entry.getKey().toString(), (Tag)playerNotifications);
            }
            tag.put("pendingNotifications", (Tag)notificationsTag);
            PlayerTradingMod.LOGGER.info("Notification data saved successfully to persistent storage");
            return tag;
        }
        catch (Exception e) {
            PlayerTradingMod.LOGGER.error("Failed to save notification data: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    public static NotificationSavedData load(CompoundTag tag, HolderLookup.Provider registryLookup) {
        PlayerTradingMod.LOGGER.info("Loading notification data from persistent storage");
        if (tag.isEmpty()) {
            PlayerTradingMod.LOGGER.info("No existing notification data found, creating new storage");
            return NotificationSavedData.create();
        }
        NotificationSavedData data = new NotificationSavedData();
        try {
            if (tag.contains("pendingNotifications")) {
                CompoundTag notificationsTag = tag.getCompound("pendingNotifications");
                for (String playerIdStr : notificationsTag.getAllKeys()) {
                    try {
                        UUID playerId = UUID.fromString(playerIdStr);
                        ListTag playerNotifications = notificationsTag.getList(playerIdStr, 8);
                        ArrayList<String> notifications = new ArrayList<String>();
                        for (int i = 0; i < playerNotifications.size(); ++i) {
                            notifications.add(playerNotifications.getString(i));
                        }
                        data.pendingNotifications.put(playerId, notifications);
                    }
                    catch (Exception e) {
                        PlayerTradingMod.LOGGER.error("Failed to load notifications for player {}: {}", new Object[]{playerIdStr, e.getMessage(), e});
                    }
                }
            }
            PlayerTradingMod.LOGGER.info("Successfully loaded notification data - {} players with notifications", (Object)data.pendingNotifications.size());
            return data;
        }
        catch (Exception e) {
            PlayerTradingMod.LOGGER.error("Failed to load notification data: {}", (Object)e.getMessage(), (Object)e);
            return NotificationSavedData.create();
        }
    }

    public boolean hasNotifications(UUID playerId) {
        return this.pendingNotifications.containsKey(playerId) && !this.pendingNotifications.get(playerId).isEmpty();
    }

    public List<String> getNotifications(UUID playerId) {
        return new ArrayList<String>(this.pendingNotifications.getOrDefault(playerId, Collections.emptyList()));
    }

    public void addNotification(UUID playerId, String notification) {
        this.pendingNotifications.computeIfAbsent(playerId, k -> new ArrayList()).add(notification);
        this.setDirty();
    }

    public void removeNotifications(UUID playerId) {
        List<String> removed = this.pendingNotifications.remove(playerId);
        if (removed != null) {
            this.setDirty();
        }
    }
}

