/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.data.model;

import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Trade(int id, ItemStack[] ItemsOffer, ItemStack[] ItemsRequest, UUID offerPlayerId, String offerPlayerName, @Nullable UUID acceptPlayerId, @Nullable String acceptPlayerName, long completedTime) {
    public static final int HASH_CONSTANT = 31;

    public static Trade createOffer(int id, ItemStack[] itemsOffer, ItemStack[] itemsRequest, UUID offerPlayerId, String offerPlayerName) {
        return new Trade(id, itemsOffer, itemsRequest, offerPlayerId, offerPlayerName, null, null, 0L);
    }

    public static Trade createCompleted(int id, ItemStack[] itemsOffer, ItemStack[] itemsRequest, UUID offerPlayerId, String offerPlayerName, UUID acceptPlayerId, String acceptPlayerName, long completedTime) {
        return new Trade(id, itemsOffer, itemsRequest, offerPlayerId, offerPlayerName, acceptPlayerId, acceptPlayerName, completedTime);
    }

    public static Trade readFromBuffer(RegistryFriendlyByteBuf buffer) {
        int id = buffer.readInt();
        UUID offerPlayerId = buffer.readUUID();
        String offerPlayerName = buffer.readUtf();
        UUID acceptPlayerId = buffer.readBoolean() ? buffer.readUUID() : null;
        String acceptPlayerName = acceptPlayerId != null ? buffer.readUtf() : null;
        long completedTime = acceptPlayerId != null ? buffer.readLong() : 0L;
        int offerCount = buffer.readInt();
        ItemStack[] itemsOffer = new ItemStack[offerCount];
        for (int j = 0; j < offerCount; ++j) {
            itemsOffer[j] = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        }
        int requestCount = buffer.readInt();
        ItemStack[] itemsRequest = new ItemStack[requestCount];
        for (int j = 0; j < requestCount; ++j) {
            itemsRequest[j] = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        }
        return new Trade(id, itemsOffer, itemsRequest, offerPlayerId, offerPlayerName, acceptPlayerId, acceptPlayerName, completedTime);
    }

    public Trade complete(UUID acceptPlayerId, String acceptPlayerName, long completedTime) {
        return new Trade(this.id, this.ItemsOffer, this.ItemsRequest, this.offerPlayerId, this.offerPlayerName, acceptPlayerId, acceptPlayerName, completedTime);
    }

    public boolean isCompleted() {
        return this.acceptPlayerId != null;
    }

    public boolean isPending() {
        return this.acceptPlayerId == null;
    }

    public void writeToBuffer(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.writeUUID(this.offerPlayerId);
        buffer.writeUtf(this.offerPlayerName);
        buffer.writeBoolean(this.acceptPlayerId != null && this.acceptPlayerName != null);
        if (this.acceptPlayerId != null && this.acceptPlayerName != null) {
            buffer.writeUUID(this.acceptPlayerId);
            buffer.writeUtf(this.acceptPlayerName);
            buffer.writeLong(this.completedTime);
        }
        this.writeItemStacksToBuffer(buffer, this.ItemsOffer);
        this.writeItemStacksToBuffer(buffer, this.ItemsRequest);
    }

    private void writeItemStacksToBuffer(RegistryFriendlyByteBuf buffer, ItemStack[] itemsOffer) {
        ArrayList<ItemStack> nonEmptyOfferItems = new ArrayList<ItemStack>();
        for (ItemStack item : itemsOffer) {
            if (item == null || item.isEmpty()) continue;
            nonEmptyOfferItems.add(item);
        }
        buffer.writeInt(nonEmptyOfferItems.size());
        for (ItemStack item : nonEmptyOfferItems) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)item);
        }
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isCompleted()) {
            sb.append("Completed Trade #").append(this.id).append(":\n");
            sb.append("  Seller: ").append(this.offerPlayerName).append("\n");
            sb.append("  Buyer: ").append(this.acceptPlayerName).append("\n");
            sb.append("  Items received: ");
            if (this.ItemsRequest.length == 0) {
                sb.append("Nothing");
            } else {
                this.appendItemList(sb, this.ItemsRequest);
            }
        } else {
            sb.append("Trade Offer #").append(this.id).append(" by ").append(this.offerPlayerName).append(":\n");
            sb.append("  OFFERING: ");
            if (this.ItemsOffer.length == 0) {
                sb.append("Nothing");
            } else {
                this.appendItemList(sb, this.ItemsOffer);
            }
            sb.append("\n");
            sb.append("  REQUESTING: ");
            if (this.ItemsRequest.length == 0) {
                sb.append("Nothing");
            } else {
                this.appendItemList(sb, this.ItemsRequest);
            }
        }
        return sb.toString();
    }

    private void appendItemList(StringBuilder sb, ItemStack[] items) {
        boolean firstItem = true;
        for (ItemStack stack : items) {
            if (stack == null || stack.isEmpty()) continue;
            if (!firstItem) {
                sb.append(", ");
            }
            sb.append(stack.getCount()).append("x ").append(stack.getHoverName().getString());
            firstItem = false;
        }
        if (firstItem) {
            sb.append("Nothing");
        }
    }

    @Override
    public int hashCode() {
        int result = 31 * Objects.hash(this.id, this.offerPlayerId, this.offerPlayerName, this.acceptPlayerId, this.acceptPlayerName, this.completedTime);
        result = 31 * result + this.hashItemStacks(this.ItemsOffer);
        result = 31 * result + this.hashItemStacks(this.ItemsRequest);
        return result;
    }

    private int hashItemStacks(ItemStack[] items) {
        if (items == null) {
            return 0;
        }
        int result = 1;
        for (ItemStack item : items) {
            result = 31 * result + ItemStack.hashItemAndComponents((ItemStack)item);
        }
        return result;
    }
}

