/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sijo.player_trading.data.persistence.TradeRepository;
import de.sijo.player_trading.logic.AcceptTrade;
import de.sijo.player_trading.logic.CancelTrade;
import de.sijo.player_trading.logic.ClaimTrade;
import de.sijo.player_trading.logic.CreateTrade;
import de.sijo.player_trading.logic.ListTrades;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class TradeCommand {
    public static final String TRADE_ID_PARAMETER = "tradeId";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"trade").executes(TradeCommand::executeUsage)).then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(TradeCommand::executeListAllTrades)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.greedyString()).suggests(TradeCommand.getPlayerWithTradesSuggestions()).executes(TradeCommand::executeListTradesGuiFilteredByPlayer)))).then(Commands.literal((String)"pending").executes(TradeCommand::listOwnTradesGui))).then(Commands.literal((String)"create").executes(TradeCommand::executeCreateTradeCommand))).then(Commands.literal((String)"accept").then((ArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)TRADE_ID_PARAMETER, (ArgumentType)IntegerArgumentType.integer((int)1)).executes(TradeCommand::executeAcceptTrade)).suggests(TradeCommand.getAvailableTradeIdsSuggestions())))).then(Commands.literal((String)"cancel").then((ArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)TRADE_ID_PARAMETER, (ArgumentType)IntegerArgumentType.integer((int)1)).executes(TradeCommand::executeCancelTrade)).suggests(TradeCommand.getPlayerOwnTradesSuggestions())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"claim").executes(TradeCommand::executeClaimAll)).then((ArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)TRADE_ID_PARAMETER, (ArgumentType)IntegerArgumentType.integer((int)1)).executes(TradeCommand::executeClaimSpecific)).suggests(TradeCommand.getPlayerCompletedTradesSuggestions()))).then(Commands.literal((String)"list").executes(TradeCommand::executeListClaimableTrades))));
    }

    private static int executeUsage(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        player.sendSystemMessage((Component)Component.literal((String)"Trade Commands:").withStyle(ChatFormatting.YELLOW));
        player.sendSystemMessage((Component)Component.literal((String)"  ").append((Component)Component.literal((String)"/trade list").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" - Open trade list GUI").withStyle(ChatFormatting.GRAY)));
        player.sendSystemMessage((Component)Component.literal((String)"  ").append((Component)Component.literal((String)"/trade list [player]").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" - Open trade list GUI filtered by player").withStyle(ChatFormatting.GRAY)));
        player.sendSystemMessage((Component)Component.literal((String)"  ").append((Component)Component.literal((String)"/trade create").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" - Open trade creation GUI").withStyle(ChatFormatting.GRAY)));
        player.sendSystemMessage((Component)Component.literal((String)"  ").append((Component)Component.literal((String)"/trade pending").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" - View your own pending trades in GUI").withStyle(ChatFormatting.GRAY)));
        player.sendSystemMessage((Component)Component.literal((String)"  ").append((Component)Component.literal((String)"/trade accept <id>").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" - Accept a trade").withStyle(ChatFormatting.GRAY)));
        player.sendSystemMessage((Component)Component.literal((String)"  ").append((Component)Component.literal((String)"/trade claim").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" - Claim all your completed trades").withStyle(ChatFormatting.GRAY)));
        player.sendSystemMessage((Component)Component.literal((String)"  ").append((Component)Component.literal((String)"/trade claim <id>").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" - Claim specific completed trade").withStyle(ChatFormatting.GRAY)));
        player.sendSystemMessage((Component)Component.literal((String)"  ").append((Component)Component.literal((String)"/trade claim list").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" - List your completed trades in GUI").withStyle(ChatFormatting.GRAY)));
        player.sendSystemMessage((Component)Component.literal((String)"  ").append((Component)Component.literal((String)"/trade cancel <id>").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" - Cancel your own trade").withStyle(ChatFormatting.GRAY)));
        return 0;
    }

    private static int executeAcceptTrade(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int tradeId = IntegerArgumentType.getInteger(context, (String)TRADE_ID_PARAMETER);
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        return AcceptTrade.acceptTrade((Player)player, tradeId);
    }

    private static int executeCancelTrade(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int tradeId = IntegerArgumentType.getInteger(context, (String)TRADE_ID_PARAMETER);
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        return CancelTrade.cancelTrade((Player)player, tradeId);
    }

    public static int executeListClaimableTrades(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        return ClaimTrade.listClaimableTradesGui((Player)player);
    }

    private static int executeClaimAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        return ClaimTrade.claimAll((Player)player);
    }

    private static int executeClaimSpecific(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int tradeId = IntegerArgumentType.getInteger(context, (String)TRADE_ID_PARAMETER);
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        return ClaimTrade.claimSpecific((Player)player, tradeId);
    }

    private static int executeCreateTradeCommand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        return CreateTrade.createTradeGui((Player)player);
    }

    private static int executeListAllTrades(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        return ListTrades.ListAllTrades((Player)player);
    }

    private static int listOwnTradesGui(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        return ListTrades.listOwnTradesGui((Player)player);
    }

    private static int executeListTradesGuiFilteredByPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String selectedPlayerName = StringArgumentType.getString(context, (String)"player");
        return ListTrades.listTradesGuiFilteredByPlayer((Player)player, selectedPlayerName);
    }

    private static SuggestionProvider<CommandSourceStack> getPlayerWithTradesSuggestions() {
        return (context, builder) -> {
            List<String> playersWithTrades = TradeRepository.getInstance().getPlayerNamesOfPendingTrades();
            return SharedSuggestionProvider.suggest(playersWithTrades, (SuggestionsBuilder)builder);
        };
    }

    private static SuggestionProvider<CommandSourceStack> getAvailableTradeIdsSuggestions() {
        return (context, builder) -> {
            List<String> tradeIds = TradeRepository.getInstance().getPendingTradeIDs();
            return SharedSuggestionProvider.suggest(tradeIds, (SuggestionsBuilder)builder);
        };
    }

    private static SuggestionProvider<CommandSourceStack> getPlayerCompletedTradesSuggestions() {
        return (context, builder) -> {
            try {
                ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
                List<String> completedTradeIds = TradeRepository.getInstance().getCompletedTradeIdsForSeller(player.getUUID());
                return SharedSuggestionProvider.suggest(completedTradeIds, (SuggestionsBuilder)builder);
            }
            catch (Exception e) {
                return builder.buildFuture();
            }
        };
    }

    private static SuggestionProvider<CommandSourceStack> getPlayerOwnTradesSuggestions() {
        return (context, builder) -> {
            try {
                ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
                List<String> ownTradeIds = TradeRepository.getInstance().getPendingTradeIdsForPlayer(player.getUUID());
                return SharedSuggestionProvider.suggest(ownTradeIds, (SuggestionsBuilder)builder);
            }
            catch (Exception e) {
                return builder.buildFuture();
            }
        };
    }
}

