/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import de.sijo.player_trading.command.TradeCommand;
import de.sijo.player_trading.data.persistence.PendingNotificationRepository;
import de.sijo.player_trading.data.persistence.TradeRepository;
import de.sijo.player_trading.gui.create.CreateTradeScreen;
import de.sijo.player_trading.gui.list.TradeListScreen;
import de.sijo.player_trading.init.ModMenuTypes;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.slf4j.Logger;

@Mod(value="player_trading")
public class PlayerTradingMod {
    public static final String MODID = "player_trading";
    public static final Logger LOGGER = LogUtils.getLogger();

    public PlayerTradingMod(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerMenuScreens);
        NeoForge.EVENT_BUS.register((Object)this);
        ModMenuTypes.MENU_TYPES.register(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Trading Marketplace mod initialized");
    }

    private void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)ModMenuTypes.CREATE_TRADE_MENU.get(), CreateTradeScreen::new);
        event.register((MenuType)ModMenuTypes.LIST_TRADES_MENU.get(), TradeListScreen::new);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Trading Marketplace server starting");
        TradeRepository.getInstance().setServer(event.getServer());
        PendingNotificationRepository.getInstance().setServer(event.getServer());
        LOGGER.info("Trading repositories initialized with persistent storage");
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        LOGGER.info("Trading Marketplace server stopping - data automatically saved");
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        TradeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        LOGGER.info("Trading commands registered");
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PendingNotificationRepository notificationRepo = PendingNotificationRepository.getInstance();
            if (notificationRepo.hasNotifications(player2.getUUID())) {
                List<String> notifications = notificationRepo.getNotifications(player2.getUUID());
                for (String notification : notifications) {
                    player2.sendSystemMessage((Component)Component.literal((String)notification).withStyle(ChatFormatting.GREEN));
                }
                notificationRepo.removeNotifications(player2.getUUID());
                LOGGER.info("Sent {} pending trade notifications to player {}", (Object)notifications.size(), (Object)player2.getName().getString());
            }
        }
    }
}

