/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.inventory.container;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.part.aspect.AspectRegistry;

public class ContainerAspectSettings
extends InventoryContainer {
    public static final String BUTTON_EXIT = "button_exit";
    public static final int BUTTON_SETTINGS = 1;
    private static final int PAGE_SIZE = 3;
    private final Optional<PartTarget> target;
    private final Optional<IPartContainer> partContainer;
    private final Optional<IPartType> partType;
    private final Level world;
    private final IAspect<?, ?> aspect;
    private final BiMap<Integer, IAspectPropertyTypeInstance> propertyIds = HashBiMap.create();

    public ContainerAspectSettings(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (Container)new SimpleContainer(0), Optional.empty(), Optional.empty(), Optional.empty(), ContainerAspectSettings.readAspect(packetBuffer));
    }

    protected static IAspect<?, ?> readAspect(FriendlyByteBuf packetBuffer) {
        String name = packetBuffer.readUtf();
        return Objects.requireNonNull(AspectRegistry.getInstance().getAspect(ResourceLocation.parse((String)name)), String.format("Could not find an aspect by name %s", name));
    }

    public ContainerAspectSettings(int id, Inventory playerInventory, Container inventory, Optional<PartTarget> target, Optional<IPartContainer> partContainer, Optional<IPartType> partType, IAspect<?, ?> aspect) {
        super((MenuType)RegistryEntries.CONTAINER_ASPECT_SETTINGS.get(), id, playerInventory, inventory);
        this.target = target;
        this.partType = partType;
        this.partContainer = partContainer;
        this.world = this.player.getCommandSenderWorld();
        this.aspect = aspect;
        this.addPlayerInventory(this.player.getInventory(), 8, 131);
        for (IAspectPropertyTypeInstance property : aspect.getPropertyTypes()) {
            this.propertyIds.put((Object)this.getNextValueId(), (Object)property);
        }
        this.putButtonAction(BUTTON_EXIT, (s, containerExtended) -> {
            if (!this.world.isClientSide()) {
                PartHelpers.openContainerPart((ServerPlayer)playerInventory.player, this.getTarget().get().getCenter(), this.getPartType().get());
            }
        });
    }

    public BiMap<Integer, IAspectPropertyTypeInstance> getPropertyIds() {
        return this.propertyIds;
    }

    public Optional<IPartType> getPartType() {
        return this.partType;
    }

    public IAspect getAspect() {
        return this.aspect;
    }

    public Optional<PartTarget> getTarget() {
        return this.target;
    }

    protected void initializeValues() {
        super.initializeValues();
        IAspectProperties properties = this.aspect.getProperties(this.getPartType().get(), this.getTarget().get(), this.getPartState().get());
        for (IAspectPropertyTypeInstance property : this.aspect.getPropertyTypes()) {
            this.setValue(ValueDeseralizationContext.ofAllEnabled(), property, (IValue)properties.getValue(property));
        }
    }

    public void setValue(ValueDeseralizationContext valueDeseralizationContext, IAspectPropertyTypeInstance property, IValue value) {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)((Integer)this.propertyIds.inverse().get((Object)property)), (Tag)ValueHelpers.serializeRaw(valueDeseralizationContext, value));
    }

    public Optional<IPartState> getPartState() {
        return this.partContainer.map(p -> p.getPartState(this.getTarget().get().getCenter().getSide()));
    }

    public boolean stillValid(Player player) {
        return true;
    }

    protected int getSizeInventory() {
        return 0;
    }

    public <T extends IValueType<V>, V extends IValue> V getPropertyValue(ValueDeseralizationContext valueDeseralizationContext, IAspectPropertyTypeInstance<T, V> property) {
        Tag value;
        if (this.propertyIds.containsValue(property) && (value = ValueNotifierHelpers.getValueNbt((IValueNotifier)this, (int)((Integer)this.propertyIds.inverse().get(property)))) != null) {
            return (V)ValueHelpers.deserializeRaw(valueDeseralizationContext, property.getType(), value);
        }
        return null;
    }

    public void onUpdate(int valueId, CompoundTag value) {
        IAspectPropertyTypeInstance property;
        super.onUpdate(valueId, value);
        if (!this.world.isClientSide() && (property = (IAspectPropertyTypeInstance)this.propertyIds.get((Object)valueId)) != null) {
            IPartType partType = this.getPartType().get();
            PartTarget target = this.getTarget().get();
            IPartState partState = this.getPartState().get();
            IAspectProperties aspectProperties = this.aspect.getProperties(partType, target, partState);
            aspectProperties = aspectProperties.clone();
            Object trueValue = ValueHelpers.deserializeRaw(ValueDeseralizationContext.of(this.world), property.getType(), value.get(ValueNotifierHelpers.KEY));
            aspectProperties.setValue(property, trueValue);
            this.aspect.setProperties(partType, target, partState, aspectProperties);
            NetworkHelpers.getNetwork(target.getCenter()).ifPresent(network -> network.getEventBus().post(new VariableContentsUpdatedEvent((INetwork)network)));
        }
    }
}

