/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeCategory;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public abstract class ValueTypeCategoryBase<V extends IValue>
extends ValueTypeBase<V>
implements IValueTypeCategory<V> {
    @Nullable
    protected final Set<IValueType<?>> elements;

    public ValueTypeCategoryBase(String typeName, int color, ChatFormatting colorFormat, Set<IValueType<?>> elements, Class<V> valueClass) {
        super(typeName, color, colorFormat, valueClass);
        this.elements = Collections.unmodifiableSet(elements);
    }

    public ValueTypeCategoryBase(String typeName, int color, ChatFormatting colorFormat, Class<V> valueClass) {
        super(typeName, color, colorFormat, valueClass);
        this.elements = null;
    }

    @Override
    public boolean isCategory() {
        return true;
    }

    @Override
    public V getDefault() {
        return (V)ValueTypeBoolean.ValueBoolean.of(false);
    }

    @Override
    public String getTranslationKey() {
        return this.getUnlocalizedPrefix();
    }

    @Override
    public MutableComponent toCompactString(V value) {
        return null;
    }

    @Override
    public boolean correspondsTo(IValueType<?> valueType) {
        return valueType == this || this.elements == null ? true : this.elements.contains(valueType);
    }

    @Override
    public Tag serialize(ValueDeseralizationContext valueDeseralizationContext, V value) {
        throw new UnsupportedOperationException("This operation is not allowed");
    }

    @Override
    public V deserialize(ValueDeseralizationContext valueDeseralizationContext, Tag value) {
        throw new UnsupportedOperationException("This operation is not allowed");
    }

    @Override
    protected String getModId() {
        return "integrateddynamics";
    }

    @Override
    public Set<IValueType<?>> getElements() {
        return this.elements == null ? Collections.emptySet() : Collections.unmodifiableSet(this.elements);
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return null;
    }
}

