/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.advancement.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.cyclops.cyclopscore.advancement.criterion.ICriterionInstanceTestable;
import org.cyclops.integrateddynamics.api.advancement.criterion.VariableFacadePredicate;
import org.cyclops.integrateddynamics.core.helper.Codecs;
import org.cyclops.integrateddynamics.core.logicprogrammer.event.LogicProgrammerVariableFacadeCreatedEvent;

public class VariableCreatedTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final Codec<Instance> CODEC = RecordCodecBuilder.create(p_311401_ -> p_311401_.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)BuiltInRegistries.BLOCK.byNameCodec().optionalFieldOf("block").forGetter(Instance::block), (App)Codecs.VARIABLE_FACADE.optionalFieldOf("variable_facade").forGetter(Instance::variableFacadePredicate)).apply((Applicative)p_311401_, Instance::new));

    public VariableCreatedTrigger() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public Codec<Instance> codec() {
        return CODEC;
    }

    public void test(ServerPlayer player, LogicProgrammerVariableFacadeCreatedEvent event) {
        this.trigger(player, instance -> instance.test(player, event));
    }

    @SubscribeEvent
    public void onEvent(LogicProgrammerVariableFacadeCreatedEvent event) {
        if (event.getPlayer() != null && event.getPlayer() instanceof ServerPlayer) {
            this.test((ServerPlayer)event.getPlayer(), event);
        }
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<Block> block, Optional<VariableFacadePredicate> variableFacadePredicate) implements SimpleCriterionTrigger.SimpleInstance,
    ICriterionInstanceTestable<LogicProgrammerVariableFacadeCreatedEvent>
    {
        public boolean test(ServerPlayer player, LogicProgrammerVariableFacadeCreatedEvent event) {
            return (this.block.isEmpty() || event.getBlockState().getBlock() == this.block.get()) && this.variableFacadePredicate.orElse(VariableFacadePredicate.ANY).test(event.getVariableFacade());
        }
    }
}

