/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.integration.mekanism;

import com.direwolf20.laserio.client.blockentityrenders.LaserNodeBERender;
import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.blocks.LaserNode;
import com.direwolf20.laserio.common.events.ServerTickHandler;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.direwolf20.laserio.integration.mekanism.MekanismStatics;
import com.direwolf20.laserio.integration.mekanism.client.chemicalparticle.ChemicalFlowParticleData;
import com.direwolf20.laserio.integration.mekanism.client.chemicalparticle.ParticleDataChemical;
import com.direwolf20.laserio.integration.mekanism.client.chemicalparticle.ParticleRenderDataChemical;
import com.direwolf20.laserio.util.CardRender;
import com.direwolf20.laserio.util.ExtractorCardCache;
import com.direwolf20.laserio.util.InserterCardCache;
import com.direwolf20.laserio.util.MiscTools;
import com.direwolf20.laserio.util.NodeSideCache;
import com.direwolf20.laserio.util.SensorCardCache;
import com.direwolf20.laserio.util.StockerCardCache;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class MekanismCache {
    public final Map<LaserNodeBE.SideConnection, BlockCapabilityCache<IChemicalHandler, Direction>> facingHandlerChemical = new HashMap<LaserNodeBE.SideConnection, BlockCapabilityCache<IChemicalHandler, Direction>>();
    public final Map<ExtractorCardCache, Map<Chemical, List<InserterCardCache>>> inserterCacheChemical = new HashMap<ExtractorCardCache, Map<Chemical, List<InserterCardCache>>>();
    private final LaserNodeBE laserNodeBE;
    private final Random random = new Random();

    public MekanismCache(LaserNodeBE laserNodeBE) {
        this.laserNodeBE = laserNodeBE;
    }

    public boolean senseChemicals(SensorCardCache sensorCardCache) {
        Level level = this.laserNodeBE.getLevel();
        BlockPos adjacentPos = this.laserNodeBE.getBlockPos().relative(sensorCardCache.direction);
        assert (level != null);
        if (!level.isLoaded(adjacentPos)) {
            return false;
        }
        NodeSideCache nodeSideCache = this.laserNodeBE.nodeSideCaches[sensorCardCache.direction.ordinal()];
        IChemicalHandler chemicalHandler = this.getAttachedChemicalTanks(sensorCardCache.direction, sensorCardCache.sneaky);
        if (chemicalHandler == null) {
            if (this.laserNodeBE.updateRedstoneFromSensor(false, sensorCardCache.redstoneChannel, nodeSideCache)) {
                this.laserNodeBE.rendersChecked = false;
                this.laserNodeBE.clearCachedInventories();
                this.laserNodeBE.redstoneChecked = false;
            }
            return false;
        }
        ItemStack filter = sensorCardCache.filterCard;
        boolean andMode = BaseCard.getAnd(sensorCardCache.cardItem);
        boolean filterMatched = false;
        if (filter.isEmpty()) {
            if (this.laserNodeBE.updateRedstoneFromSensor(false, sensorCardCache.redstoneChannel, nodeSideCache)) {
                this.laserNodeBE.rendersChecked = false;
                this.laserNodeBE.clearCachedInventories();
                this.laserNodeBE.redstoneChecked = false;
            }
            return false;
        }
        if (filter.getItem() instanceof FilterBasic) {
            List<ChemicalStack> filteredChemicals = sensorCardCache.mekanismCardCache.getFilteredChemicals();
            Iterator<ChemicalStack> iter = filteredChemicals.iterator();
            block0: while (iter.hasNext()) {
                ChemicalStack chemicalStack = iter.next();
                for (int tank = 0; tank < chemicalHandler.getChemicalTanks(); ++tank) {
                    ChemicalStack stackInTank = chemicalHandler.getChemicalInTank(tank);
                    if (chemicalStack.getChemical() != stackInTank.getChemical()) continue;
                    iter.remove();
                    if (andMode) continue;
                    filterMatched = true;
                    break block0;
                }
            }
            if (andMode) {
                filterMatched = filteredChemicals.isEmpty();
            }
        } else if (filter.getItem() instanceof FilterCount) {
            List<ChemicalStack> filteredChemicals = sensorCardCache.mekanismCardCache.getFilteredChemicals();
            Iterator<ChemicalStack> iter = filteredChemicals.iterator();
            block2: while (iter.hasNext()) {
                ChemicalStack chemicalStack = iter.next();
                int desiredAmt = sensorCardCache.mekanismCardCache.getFilterAmt(chemicalStack);
                for (int tank = 0; tank < chemicalHandler.getChemicalTanks(); ++tank) {
                    long amtHad;
                    ChemicalStack stackInTank = chemicalHandler.getChemicalInTank(tank);
                    if (chemicalStack.getChemical() != stackInTank.getChemical() || (amtHad = stackInTank.getAmount()) < (long)desiredAmt || sensorCardCache.exact && amtHad > (long)desiredAmt) continue;
                    iter.remove();
                    if (andMode) continue;
                    filterMatched = true;
                    break block2;
                }
            }
            if (andMode) {
                filterMatched = filteredChemicals.isEmpty();
            }
        } else if (filter.getItem() instanceof FilterTag) {
            List<String> tags = sensorCardCache.getFilterTags();
            block4: for (int tank = 0; tank < chemicalHandler.getChemicalTanks(); ++tank) {
                ChemicalStack stackInTank = chemicalHandler.getChemicalInTank(tank);
                for (TagKey tagKey : stackInTank.getChemical().getTags().toList()) {
                    String chemicalTag = tagKey.location().toString().toLowerCase(Locale.ROOT);
                    if (!tags.contains(chemicalTag)) continue;
                    tags.remove(chemicalTag);
                    if (andMode) continue;
                    filterMatched = true;
                    break block4;
                }
            }
            if (andMode) {
                filterMatched = tags.isEmpty();
            }
        }
        if (this.laserNodeBE.updateRedstoneFromSensor(filterMatched, sensorCardCache.redstoneChannel, nodeSideCache)) {
            this.laserNodeBE.rendersChecked = false;
            this.laserNodeBE.clearCachedInventories();
            this.laserNodeBE.redstoneChecked = false;
        }
        return true;
    }

    public boolean stockChemicals(StockerCardCache stockerCardCache) {
        ItemStack filter = stockerCardCache.filterCard;
        if (filter.isEmpty() || !stockerCardCache.isAllowList) {
            return false;
        }
        Level level = this.laserNodeBE.getLevel();
        BlockPos adjacentPos = this.laserNodeBE.getBlockPos().relative(stockerCardCache.direction);
        assert (level != null);
        if (!level.isLoaded(adjacentPos)) {
            return false;
        }
        IChemicalHandler chemicalHandler = this.getAttachedChemicalTanks(stockerCardCache.direction, stockerCardCache.sneaky);
        if (chemicalHandler == null) {
            return false;
        }
        if (filter.getItem() instanceof FilterBasic || filter.getItem() instanceof FilterCount) {
            if (stockerCardCache.regulate && filter.getItem() instanceof FilterCount && this.regulateChemicalStocker(stockerCardCache, chemicalHandler)) {
                return true;
            }
            if (!this.canAnyChemicalFiltersFit(chemicalHandler, stockerCardCache)) {
                return false;
            }
            boolean foundItems = this.findChemicalStackForStocker(stockerCardCache, chemicalHandler);
            if (foundItems) {
                return true;
            }
        } else if (filter.getItem() instanceof FilterTag) {
            // empty if block
        }
        return false;
    }

    private boolean canAnyChemicalFiltersFit(IChemicalHandler chemicalHandler, StockerCardCache stockerCardCache) {
        for (ChemicalStack chemicalStack : stockerCardCache.mekanismCardCache.getFilteredChemicals()) {
            long amtReturned = chemicalHandler.insertChemical(chemicalStack, Action.SIMULATE).getAmount();
            if (amtReturned >= chemicalStack.getAmount()) continue;
            return true;
        }
        return false;
    }

    private boolean canChemicalFitInTank(IChemicalHandler stockerTank, ChemicalStack chemicalStack) {
        return stockerTank.insertChemical(chemicalStack, Action.SIMULATE).getAmount() < chemicalStack.getAmount();
    }

    private boolean findChemicalStackForStocker(StockerCardCache stockerCardCache, IChemicalHandler stockerTank) {
        boolean isCount = stockerCardCache.filterCard.getItem() instanceof FilterCount;
        int extractAmt = stockerCardCache.extractAmt;
        CopyOnWriteArrayList<ChemicalStack> filteredChemicalsList = new CopyOnWriteArrayList<ChemicalStack>(stockerCardCache.mekanismCardCache.getFilteredChemicals());
        filteredChemicalsList.removeIf(chemicalStack -> !this.canChemicalFitInTank(stockerTank, (ChemicalStack)chemicalStack));
        if (filteredChemicalsList.isEmpty()) {
            return false;
        }
        if (isCount) {
            for (ChemicalStack chemicalStack2 : filteredChemicalsList) {
                for (int tank = 0; tank < stockerTank.getChemicalTanks(); ++tank) {
                    long amtHad;
                    ChemicalStack tankStack = stockerTank.getChemicalInTank(tank);
                    if (!tankStack.isEmpty() && !chemicalStack2.is(tankStack.getChemical())) continue;
                    int filterAmt = stockerCardCache.mekanismCardCache.getFilterAmt(chemicalStack2);
                    long amtNeeded = (long)filterAmt - (amtHad = tankStack.getAmount());
                    if (amtNeeded <= 0L) {
                        filteredChemicalsList.remove(chemicalStack2);
                        continue;
                    }
                    chemicalStack2.setAmount(Math.min(amtNeeded, (long)extractAmt));
                }
            }
        }
        if (filteredChemicalsList.isEmpty()) {
            return false;
        }
        for (ChemicalStack chemicalStack2 : filteredChemicalsList) {
            HashMap<InserterCardCache, ChemicalStack> insertHandlers = new HashMap<InserterCardCache, ChemicalStack>();
            if (!isCount) {
                chemicalStack2.setAmount((long)extractAmt);
            }
            long amtNeeded = chemicalStack2.getAmount();
            for (InserterCardCache inserterCardCache : this.laserNodeBE.getChannelMatchInserters(stockerCardCache)) {
                IChemicalHandler handler;
                if (!inserterCardCache.mekanismCardCache.isStackValidForCard(chemicalStack2) || (handler = this.getLaserNodeHandlerChemical(inserterCardCache)) == null) continue;
                chemicalStack2.setAmount(amtNeeded);
                ChemicalStack extractStack = handler.extractChemical(chemicalStack2, Action.SIMULATE);
                if (extractStack.isEmpty()) continue;
                insertHandlers.put(inserterCardCache, extractStack);
                if ((amtNeeded -= extractStack.getAmount()) != 0L) continue;
                break;
            }
            if (insertHandlers.isEmpty() || stockerCardCache.exact && amtNeeded != 0L) continue;
            for (Map.Entry entry : insertHandlers.entrySet()) {
                InserterCardCache inserterCardCache = (InserterCardCache)entry.getKey();
                ChemicalStack insertStack = (ChemicalStack)entry.getValue();
                long amtReturned = stockerTank.insertChemical(insertStack, Action.SIMULATE).getAmount();
                insertStack.setAmount(insertStack.getAmount() - amtReturned);
                IChemicalHandler handler = this.getLaserNodeHandlerChemical(inserterCardCache);
                if (handler == null) continue;
                ChemicalStack drainedStack = handler.extractChemical(insertStack, Action.EXECUTE);
                stockerTank.insertChemical(drainedStack, Action.EXECUTE);
                this.drawParticlesChemical(drainedStack, inserterCardCache.direction, inserterCardCache.be, stockerCardCache.be, stockerCardCache.direction, inserterCardCache.cardSlot, stockerCardCache.cardSlot);
            }
            return true;
        }
        return false;
    }

    private boolean regulateChemicalStocker(StockerCardCache stockerCardCache, IChemicalHandler stockerTank) {
        List<ChemicalStack> filteredChemicalsList = stockerCardCache.mekanismCardCache.getFilteredChemicals();
        for (ChemicalStack chemicalStack : filteredChemicalsList) {
            int desiredAmt = stockerCardCache.mekanismCardCache.getFilterAmt(chemicalStack);
            long amtHad = 0L;
            for (int tank = 0; tank < stockerTank.getChemicalTanks(); ++tank) {
                ChemicalStack stackInTank = stockerTank.getChemicalInTank(tank);
                if (!chemicalStack.is(stackInTank.getChemical())) continue;
                amtHad += stackInTank.getAmount();
            }
            if (amtHad <= (long)desiredAmt) continue;
            chemicalStack.setAmount(Math.min(amtHad - (long)desiredAmt, (long)stockerCardCache.extractAmt));
            if (!this.extractChemicalStack(stockerCardCache, stockerTank, chemicalStack)) continue;
            return true;
        }
        return false;
    }

    public boolean sendChemicals(ExtractorCardCache extractorCardCache) {
        BlockPos adjacentPos = this.laserNodeBE.getBlockPos().relative(extractorCardCache.direction);
        Level level = this.laserNodeBE.getLevel();
        assert (level != null);
        if (!level.isLoaded(adjacentPos)) {
            return false;
        }
        return this.extractChemicalStack(extractorCardCache, this.getAttachedChemicalTanks(extractorCardCache.direction, extractorCardCache.sneaky));
    }

    private boolean extractChemicalStack(ExtractorCardCache extractorCardCache, @Nullable IChemicalHandler chemicalHandler) {
        if (chemicalHandler == null) {
            return false;
        }
        for (int tank = 0; tank < chemicalHandler.getChemicalTanks(); ++tank) {
            ChemicalStack chemicalStack = chemicalHandler.getChemicalInTank(tank);
            if (chemicalStack.isEmpty() || !extractorCardCache.mekanismCardCache.isStackValidForCard(chemicalStack)) continue;
            ChemicalStack extractStack = chemicalStack.copy();
            extractStack.setAmount((long)extractorCardCache.extractAmt);
            if (extractorCardCache.filterCard.getItem() instanceof FilterCount) {
                long amtInInv;
                long amtAllowedToRemove;
                int filterCount = extractorCardCache.mekanismCardCache.getFilterAmt(extractStack);
                if (filterCount <= 0 || (amtAllowedToRemove = (amtInInv = chemicalStack.getAmount()) - (long)filterCount) <= 0L) continue;
                long amtRemaining = Math.min(extractStack.getAmount(), amtAllowedToRemove);
                extractStack.setAmount(amtRemaining);
            }
            if (!(extractorCardCache.exact ? this.extractChemicalStackExact(extractorCardCache, chemicalHandler, extractStack) : this.extractChemicalStack(extractorCardCache, chemicalHandler, extractStack))) continue;
            return true;
        }
        return false;
    }

    private boolean extractChemicalStack(ExtractorCardCache extractorCardCache, IChemicalHandler fromInventory, ChemicalStack extractStack) {
        long totalAmtNeeded = extractStack.getAmount();
        long amtToExtract = extractStack.getAmount();
        List<InserterCardCache> inserterCardCaches = this.getPossibleInserters(extractorCardCache, extractStack);
        int roundRobin = -1;
        boolean foundAnything = false;
        if (extractorCardCache.roundRobin != 0) {
            roundRobin = this.laserNodeBE.getRR(extractorCardCache);
            inserterCardCaches = this.laserNodeBE.applyRR(extractorCardCache, inserterCardCaches, roundRobin);
        }
        for (InserterCardCache inserterCardCache : inserterCardCaches) {
            IChemicalHandler handler = this.getLaserNodeHandlerChemical(inserterCardCache);
            if (handler == null) continue;
            if (inserterCardCache.filterCard.getItem() instanceof FilterCount) {
                int filterCount = inserterCardCache.mekanismCardCache.getFilterAmt(extractStack);
                for (int tank = 0; tank < handler.getChemicalTanks(); ++tank) {
                    long currentAmt;
                    long neededAmt;
                    ChemicalStack chemicalStack = handler.getChemicalInTank(tank);
                    if (!chemicalStack.isEmpty() && !chemicalStack.is(extractStack.getChemical()) || (neededAmt = (long)filterCount - (currentAmt = chemicalStack.getAmount())) >= extractStack.getAmount()) continue;
                    amtToExtract = neededAmt;
                    break;
                }
            }
            if (amtToExtract == 0L) {
                amtToExtract = totalAmtNeeded;
                continue;
            }
            extractStack.setAmount(amtToExtract);
            long amtReturned = handler.insertChemical(extractStack, Action.SIMULATE).getAmount();
            if (amtReturned == amtToExtract) {
                if (extractorCardCache.roundRobin == 2) {
                    return false;
                }
                if (extractorCardCache.roundRobin == 0) continue;
                this.laserNodeBE.getNextRR(extractorCardCache, inserterCardCaches);
                continue;
            }
            extractStack.setAmount(amtToExtract - amtReturned);
            ChemicalStack drainedStack = fromInventory.extractChemical(extractStack, Action.EXECUTE);
            if (drainedStack.isEmpty()) continue;
            foundAnything = true;
            handler.insertChemical(drainedStack, Action.EXECUTE);
            this.drawParticlesChemical(drainedStack, extractorCardCache.direction, extractorCardCache.be, inserterCardCache.be, inserterCardCache.direction, extractorCardCache.cardSlot, inserterCardCache.cardSlot);
            amtToExtract = totalAmtNeeded -= drainedStack.getAmount();
            if (extractorCardCache.roundRobin != 0) {
                this.laserNodeBE.getNextRR(extractorCardCache, inserterCardCaches);
            }
            if (totalAmtNeeded != 0L) continue;
            return true;
        }
        return foundAnything;
    }

    private boolean extractChemicalStackExact(ExtractorCardCache extractorCardCache, IChemicalHandler fromInventory, ChemicalStack extractStack) {
        long totalAmtNeeded = extractStack.getAmount();
        long amtToExtract = extractStack.getAmount();
        ChemicalStack testDrain = fromInventory.extractChemical(extractStack, Action.SIMULATE);
        if (testDrain.getAmount() < totalAmtNeeded) {
            return false;
        }
        List<InserterCardCache> inserterCardCaches = this.getPossibleInserters(extractorCardCache, extractStack);
        if (extractorCardCache.roundRobin != 0) {
            int roundRobin = this.laserNodeBE.getRR(extractorCardCache);
            inserterCardCaches = this.laserNodeBE.applyRR(extractorCardCache, inserterCardCaches, roundRobin);
        }
        Object2LongOpenHashMap insertHandlers = new Object2LongOpenHashMap();
        for (InserterCardCache inserterCardCache : inserterCardCaches) {
            IChemicalHandler handler = this.getLaserNodeHandlerChemical(inserterCardCache);
            if (handler == null) continue;
            if (inserterCardCache.filterCard.getItem() instanceof FilterCount) {
                int filterCount = inserterCardCache.mekanismCardCache.getFilterAmt(extractStack);
                for (int tank = 0; tank < handler.getChemicalTanks(); ++tank) {
                    long currentAmt;
                    long neededAmt;
                    ChemicalStack chemicalStack = handler.getChemicalInTank(tank);
                    if (!chemicalStack.isEmpty() && !chemicalStack.is(extractStack.getChemical()) || (neededAmt = (long)filterCount - (currentAmt = chemicalStack.getAmount())) >= totalAmtNeeded) continue;
                    amtToExtract = neededAmt;
                    break;
                }
            }
            if (amtToExtract == 0L) {
                amtToExtract = totalAmtNeeded;
                continue;
            }
            extractStack.setAmount(amtToExtract);
            long amtReturned = handler.insertChemical(extractStack, Action.SIMULATE).getAmount();
            if (amtReturned == amtToExtract) {
                if (extractorCardCache.roundRobin == 2) {
                    return false;
                }
                if (extractorCardCache.roundRobin == 0) continue;
                this.laserNodeBE.getNextRR(extractorCardCache, inserterCardCaches);
                continue;
            }
            extractStack.setAmount(amtToExtract - amtReturned);
            ChemicalStack drainedStack = fromInventory.extractChemical(extractStack, Action.SIMULATE);
            if (drainedStack.isEmpty()) continue;
            insertHandlers.put(inserterCardCache, drainedStack.getAmount());
            amtToExtract = totalAmtNeeded -= drainedStack.getAmount();
            if (extractorCardCache.roundRobin != 0) {
                this.laserNodeBE.getNextRR(extractorCardCache, inserterCardCaches);
            }
            if (totalAmtNeeded != 0L) continue;
            break;
        }
        if (totalAmtNeeded > 0L) {
            return false;
        }
        for (Map.Entry entry : insertHandlers.entrySet()) {
            InserterCardCache inserterCardCache = (InserterCardCache)entry.getKey();
            extractStack.setAmount(((Long)entry.getValue()).longValue());
            IChemicalHandler handler = this.getLaserNodeHandlerChemical(inserterCardCache);
            if (handler == null) continue;
            ChemicalStack drainedStack = fromInventory.extractChemical(extractStack, Action.EXECUTE);
            handler.insertChemical(drainedStack, Action.EXECUTE);
            this.drawParticlesChemical(drainedStack, extractorCardCache.direction, extractorCardCache.be, inserterCardCache.be, inserterCardCache.direction, extractorCardCache.cardSlot, inserterCardCache.cardSlot);
        }
        return true;
    }

    private List<InserterCardCache> getPossibleInserters(ExtractorCardCache extractorCardCache, ChemicalStack stack) {
        return this.inserterCacheChemical.computeIfAbsent(extractorCardCache, cache -> new Reference2ObjectOpenHashMap()).computeIfAbsent(stack.getChemical(), k -> this.laserNodeBE.getInserterNodes().stream().filter(p -> p.channel == extractorCardCache.channel && p.cardType == extractorCardCache.cardType && p.enabled && p.mekanismCardCache.isStackValidForCard(stack) && (!p.relativePos.pos().equals((Object)BlockPos.ZERO) || p.direction != extractorCardCache.direction)).toList());
    }

    @Nullable
    private IChemicalHandler getLaserNodeHandlerChemical(InserterCardCache inserterCardCache) {
        LaserNodeBE be = this.laserNodeBE.getLaserNodeBE(inserterCardCache, BaseCard.CardType.CHEMICAL);
        if (be == null) {
            return null;
        }
        IChemicalHandler chemicalHandler = be.mekanismCache.getAttachedChemicalTanks(inserterCardCache.direction, inserterCardCache.sneaky);
        if (chemicalHandler == null || chemicalHandler.getChemicalTanks() == 0) {
            return null;
        }
        return chemicalHandler;
    }

    private IChemicalHandler getAttachedChemicalTanks(Direction direction, Byte sneakySide) {
        Direction inventorySide = sneakySide != -1 ? Direction.values()[sneakySide] : direction.getOpposite();
        LaserNodeBE.SideConnection sideConnection = new LaserNodeBE.SideConnection(direction, inventorySide);
        Level level = this.laserNodeBE.getLevel();
        assert (level != null);
        BlockPos targetPos = this.laserNodeBE.getBlockPos().relative(direction);
        if (this.facingHandlerChemical.get(sideConnection) == null) {
            this.facingHandlerChemical.put(sideConnection, (BlockCapabilityCache<IChemicalHandler, Direction>)BlockCapabilityCache.create(MekanismStatics.getCapabilityForChemical(), (ServerLevel)((ServerLevel)level), (BlockPos)targetPos, (Object)inventorySide));
        }
        return (IChemicalHandler)this.facingHandlerChemical.get(sideConnection).getCapability();
    }

    public IChemicalHandler getAttachedChemicalTanksNoCache(Direction direction, Byte sneakySide) {
        Direction inventorySide = direction.getOpposite();
        if (sneakySide != -1) {
            inventorySide = Direction.values()[sneakySide];
        }
        Level level = this.laserNodeBE.getLevel();
        assert (level != null);
        BlockEntity be = level.getBlockEntity(this.laserNodeBE.getBlockPos().relative(direction));
        if (be != null) {
            BlockPos relativePos = this.laserNodeBE.getBlockPos().relative(direction);
            IChemicalHandler handler = (IChemicalHandler)level.getCapability(MekanismStatics.getCapabilityForChemical(), relativePos, (Object)inventorySide);
            if (handler != null) {
                return handler;
            }
        }
        return null;
    }

    public void drawParticlesChemical(ChemicalStack chemicalStack, Direction fromDirection, LaserNodeBE sourceBE, LaserNodeBE destinationBE, Direction destinationDirection, int extractPosition, int insertPosition) {
        if (!sourceBE.getShowParticles() || !destinationBE.getShowParticles()) {
            return;
        }
        ServerTickHandler.addToListFluid(new ParticleDataChemical(chemicalStack, GlobalPos.of((ResourceKey)sourceBE.getLevel().dimension(), (BlockPos)sourceBE.getBlockPos()), (byte)fromDirection.ordinal(), GlobalPos.of((ResourceKey)destinationBE.getLevel().dimension(), (BlockPos)destinationBE.getBlockPos()), (byte)destinationDirection.ordinal(), (byte)extractPosition, (byte)insertPosition));
    }

    public void drawParticlesClient(ParticleRenderDataChemical partData) {
        Level level = this.laserNodeBE.getLevel();
        ClientLevel clientLevel = (ClientLevel)level;
        ChemicalStack chemicalStack = partData.chemicalStack;
        if (chemicalStack.isEmpty()) {
            return;
        }
        BlockPos toPos = partData.toPos;
        BlockPos fromPos = partData.fromPos;
        Direction direction = Direction.values()[partData.direction];
        BlockState targetState = level.getBlockState(toPos);
        float randomSpread = 0.01f;
        int min = 100;
        int max = 8000;
        int minPart = 8;
        int maxPart = 64;
        long count = (long)(maxPart - minPart) * (chemicalStack.getAmount() - (long)min) / (long)(max - min) + (long)minPart;
        if (targetState.getBlock() instanceof LaserNode) {
            targetState = level.getBlockState(fromPos);
            VoxelShape voxelShape = targetState.getShape((BlockGetter)level, fromPos);
            Vector3f extractOffset = MiscTools.findOffset(direction, partData.position, LaserNodeBERender.offsets);
            Vector3f insertOffset = CardRender.shapeOffset(extractOffset, voxelShape, fromPos, toPos, direction, level, targetState);
            ChemicalFlowParticleData data = new ChemicalFlowParticleData(chemicalStack, (float)toPos.getX() + extractOffset.x(), (float)toPos.getY() + extractOffset.y(), (float)toPos.getZ() + extractOffset.z(), 10);
            int i = 0;
            while ((long)i < count) {
                double d1 = this.random.nextGaussian() * (double)randomSpread;
                double d3 = this.random.nextGaussian() * (double)randomSpread;
                double d5 = this.random.nextGaussian() * (double)randomSpread;
                clientLevel.addParticle((ParticleOptions)data, (double)((float)toPos.getX() + insertOffset.x()) + d1, (double)((float)toPos.getY() + insertOffset.y()) + d3, (double)((float)toPos.getZ() + insertOffset.z()) + d5, 0.0, 0.0, 0.0);
                ++i;
            }
        } else {
            VoxelShape voxelShape = targetState.getShape((BlockGetter)level, toPos);
            Vector3f extractOffset = MiscTools.findOffset(direction, partData.position, LaserNodeBERender.offsets);
            Vec3 insertOffset = new Vec3(CardRender.shapeOffset(extractOffset, voxelShape, fromPos, toPos, direction, level, targetState));
            ChemicalFlowParticleData data = new ChemicalFlowParticleData(chemicalStack, insertOffset.add(Vec3.atLowerCornerOf((Vec3i)fromPos)), 10);
            int i = 0;
            while ((long)i < count) {
                double d1 = this.random.nextGaussian() * (double)randomSpread;
                double d3 = this.random.nextGaussian() * (double)randomSpread;
                double d5 = this.random.nextGaussian() * (double)randomSpread;
                clientLevel.addParticle((ParticleOptions)data, (double)((float)fromPos.getX() + extractOffset.x()) + d1, (double)((float)fromPos.getY() + extractOffset.y()) + d3, (double)((float)fromPos.getZ() + extractOffset.z()) + d5, 0.0, 0.0, 0.0);
                ++i;
            }
        }
    }
}

