/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.blockentities;

import com.direwolf20.laserio.client.particles.fluidparticle.FluidFlowParticleData;
import com.direwolf20.laserio.client.particles.itemparticle.ItemFlowParticleData;
import com.direwolf20.laserio.common.blockentities.basebe.BaseLaserBE;
import com.direwolf20.laserio.common.blocks.LaserNode;
import com.direwolf20.laserio.common.containers.LaserNodeContainer;
import com.direwolf20.laserio.common.events.ServerTickHandler;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardEnergy;
import com.direwolf20.laserio.common.items.cards.CardFluid;
import com.direwolf20.laserio.common.items.cards.CardItem;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.items.filters.FilterMod;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.direwolf20.laserio.common.items.upgrades.OverclockerNode;
import com.direwolf20.laserio.integration.mekanism.CardChemical;
import com.direwolf20.laserio.integration.mekanism.MekanismCache;
import com.direwolf20.laserio.integration.mekanism.MekanismIntegration;
import com.direwolf20.laserio.integration.mekanism.client.chemicalparticle.ParticleRenderDataChemical;
import com.direwolf20.laserio.setup.Registration;
import com.direwolf20.laserio.util.CardRender;
import com.direwolf20.laserio.util.ExtractorCardCache;
import com.direwolf20.laserio.util.FluidStackKey;
import com.direwolf20.laserio.util.InserterCardCache;
import com.direwolf20.laserio.util.ItemHandlerUtil;
import com.direwolf20.laserio.util.ItemStackKey;
import com.direwolf20.laserio.util.MiscTools;
import com.direwolf20.laserio.util.NodeSideCache;
import com.direwolf20.laserio.util.ParticleData;
import com.direwolf20.laserio.util.ParticleDataFluid;
import com.direwolf20.laserio.util.ParticleRenderData;
import com.direwolf20.laserio.util.ParticleRenderDataFluid;
import com.direwolf20.laserio.util.SensorCardCache;
import com.direwolf20.laserio.util.StockerCardCache;
import com.direwolf20.laserio.util.TransferResult;
import it.unimi.dsi.fastutil.bytes.Byte2BooleanMap;
import it.unimi.dsi.fastutil.bytes.Byte2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.bytes.Byte2ByteMap;
import it.unimi.dsi.fastutil.bytes.Byte2ByteOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class LaserNodeBE
extends BaseLaserBE {
    private static final Vector3f[] offsets = new Vector3f[]{new Vector3f(0.65f, 0.65f, 0.5f), new Vector3f(0.5f, 0.65f, 0.5f), new Vector3f(0.35f, 0.65f, 0.5f), new Vector3f(0.65f, 0.5f, 0.5f), new Vector3f(0.5f, 0.5f, 0.5f), new Vector3f(0.35f, 0.5f, 0.5f), new Vector3f(0.65f, 0.35f, 0.5f), new Vector3f(0.5f, 0.35f, 0.5f), new Vector3f(0.35f, 0.35f, 0.5f)};
    public final NodeSideCache[] nodeSideCaches = new NodeSideCache[6];
    private final IItemHandler EMPTY = new ItemStackHandler(0);
    public Map<ExtractorCardCache, Integer> roundRobinMap = new Object2IntOpenHashMap();
    private final Map<SideConnection, BlockCapabilityCache<IItemHandler, Direction>> facingHandlerItem = new HashMap<SideConnection, BlockCapabilityCache<IItemHandler, Direction>>();
    private final Map<SideConnection, BlockCapabilityCache<IFluidHandler, Direction>> facingHandlerFluid = new HashMap<SideConnection, BlockCapabilityCache<IFluidHandler, Direction>>();
    private final Map<SideConnection, BlockCapabilityCache<IEnergyStorage, Direction>> facingHandlerEnergy = new HashMap<SideConnection, BlockCapabilityCache<IEnergyStorage, Direction>>();
    private final Set<GlobalPos> otherNodesInNetwork = new HashSet<GlobalPos>();
    private final List<InserterCardCache> inserterNodes = new CopyOnWriteArrayList<InserterCardCache>();
    private final HashMap<ExtractorCardCache, HashMap<ItemStackKey, List<InserterCardCache>>> inserterCache = new HashMap();
    private final HashMap<ExtractorCardCache, HashMap<FluidStackKey, List<InserterCardCache>>> inserterCacheFluid = new HashMap();
    private final HashMap<ExtractorCardCache, List<InserterCardCache>> channelOnlyCache = new HashMap();
    private final List<ParticleRenderData> particleRenderData = new ArrayList<ParticleRenderData>();
    private final List<ParticleRenderDataFluid> particleRenderDataFluids = new ArrayList<ParticleRenderDataFluid>();
    private final List<ParticleRenderDataChemical> particleRenderDataChemical = new ArrayList<ParticleRenderDataChemical>();
    private final Random random = new Random();
    private final Map<StockerRequest, StockerSource> stockerDestinationCache = new HashMap<StockerRequest, StockerSource>();
    public boolean rendersChecked = false;
    public List<CardRender> cardRenders = new ArrayList<CardRender>();
    public Byte2ByteMap redstoneNetwork = new Byte2ByteOpenHashMap();
    public Byte2ByteMap myRedstoneIn = new Byte2ByteOpenHashMap();
    public Byte2ByteMap myRedstoneOut = new Byte2ByteOpenHashMap();
    public Byte2BooleanMap redstoneCardSides = new Byte2BooleanOpenHashMap();
    public boolean redstoneChecked = false;
    public boolean redstoneRefreshed = false;
    public boolean firstTimeNodeLoaded = true;
    private boolean discoveredNodes = false;
    private boolean showParticles = true;
    public MekanismCache mekanismCache;

    public LaserNodeBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.LaserNode_BE.get(), pos, state);
        if (MekanismIntegration.isLoaded()) {
            this.mekanismCache = new MekanismCache(this);
        }
        for (Direction direction : Direction.values()) {
            int j = direction.ordinal();
            com.direwolf20.laserio.common.containers.customhandler.LaserNodeItemHandler tempHandler = new com.direwolf20.laserio.common.containers.customhandler.LaserNodeItemHandler(LaserNodeContainer.SLOTS, this);
            this.nodeSideCaches[j] = new NodeSideCache(tempHandler, 0, new LaserEnergyStorage(direction));
        }
    }

    public List<InserterCardCache> getInserterNodes() {
        return this.inserterNodes;
    }

    public void setOtherNodesInNetwork(Set<GlobalPos> otherNodesInNetwork) {
        this.otherNodesInNetwork.clear();
        if (this.level == null) {
            return;
        }
        for (GlobalPos pos : otherNodesInNetwork) {
            Level targetLevel = MiscTools.getLevel(this.level.getServer(), pos);
            if (targetLevel == null) continue;
            this.otherNodesInNetwork.add(new GlobalPos(targetLevel.dimension(), this.getRelativePos(pos.pos())));
        }
        this.refreshAllInvNodes();
    }

    public void updateOverclockers() {
        for (Direction direction : Direction.values()) {
            int slot = 9;
            NodeSideCache nodeSideCache = this.nodeSideCaches[direction.ordinal()];
            ItemStack overclockerStack = nodeSideCache.itemHandler.getStackInSlot(slot);
            if (overclockerStack.isEmpty()) {
                nodeSideCache.overClocker = 0;
            }
            if (!(overclockerStack.getItem() instanceof OverclockerNode)) continue;
            nodeSideCache.overClocker = overclockerStack.getCount();
        }
    }

    public void findMyExtractors() {
        for (Direction direction : Direction.values()) {
            NodeSideCache nodeSideCache = this.nodeSideCaches[direction.ordinal()];
            nodeSideCache.extractorCardCaches.clear();
            for (int slot = 0; slot < 9; ++slot) {
                ItemStack card = nodeSideCache.itemHandler.getStackInSlot(slot);
                if (!(card.getItem() instanceof BaseCard) || card.getItem() instanceof CardRedstone) continue;
                if (BaseCard.getNamedTransferMode(card).equals((Object)BaseCard.TransferMode.EXTRACT)) {
                    nodeSideCache.extractorCardCaches.add(new ExtractorCardCache(direction, card, slot, this));
                }
                if (BaseCard.getNamedTransferMode(card).equals((Object)BaseCard.TransferMode.STOCK)) {
                    nodeSideCache.extractorCardCaches.add(new StockerCardCache(direction, card, slot, this));
                }
                if (!BaseCard.getNamedTransferMode(card).equals((Object)BaseCard.TransferMode.SENSOR)) continue;
                nodeSideCache.extractorCardCaches.add(new SensorCardCache(direction, card, slot, this));
            }
        }
    }

    public void extract() {
        for (Direction direction : Direction.values()) {
            NodeSideCache nodeSideCache = this.nodeSideCaches[direction.ordinal()];
            int countCardsHandled = 0;
            for (ExtractorCardCache extractorCardCache : nodeSideCache.extractorCardCaches) {
                if (extractorCardCache instanceof SensorCardCache || extractorCardCache.decrementSleep() != 0 || !extractorCardCache.enabled || countCardsHandled > nodeSideCache.overClocker) continue;
                if (extractorCardCache instanceof StockerCardCache) {
                    StockerCardCache stockerCardCache = (StockerCardCache)extractorCardCache;
                    if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.ITEM)) {
                        if (this.stockItems(stockerCardCache)) {
                            ++countCardsHandled;
                        }
                    } else if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.FLUID)) {
                        if (this.stockFluids(stockerCardCache)) {
                            ++countCardsHandled;
                        }
                    } else if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.ENERGY)) {
                        if (this.stockEnergy(stockerCardCache)) {
                            ++countCardsHandled;
                        }
                    } else if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.CHEMICAL) && this.mekanismCache.stockChemicals(stockerCardCache)) {
                        ++countCardsHandled;
                    }
                } else if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.ITEM)) {
                    if (this.sendItems(extractorCardCache)) {
                        ++countCardsHandled;
                    }
                } else if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.FLUID)) {
                    if (this.sendFluids(extractorCardCache)) {
                        ++countCardsHandled;
                    }
                } else if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.ENERGY)) {
                    if (this.sendEnergy(extractorCardCache)) {
                        ++countCardsHandled;
                    }
                } else if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.CHEMICAL) && this.mekanismCache.sendChemicals(extractorCardCache)) {
                    ++countCardsHandled;
                }
                if (extractorCardCache.remainingSleep > 0) continue;
                extractorCardCache.remainingSleep = extractorCardCache.tickSpeed;
            }
        }
    }

    public void sense() {
        for (Direction direction : Direction.values()) {
            NodeSideCache nodeSideCache = this.nodeSideCaches[direction.ordinal()];
            int countCardsHandled = 0;
            for (ExtractorCardCache extractorCardCache : nodeSideCache.extractorCardCaches) {
                if (!(extractorCardCache instanceof SensorCardCache) || extractorCardCache.decrementSleep() != 0 || !extractorCardCache.enabled || countCardsHandled > nodeSideCache.overClocker) continue;
                if (extractorCardCache instanceof SensorCardCache) {
                    SensorCardCache sensorCardCache = (SensorCardCache)extractorCardCache;
                    if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.ITEM)) {
                        if (this.senseItems(sensorCardCache)) {
                            ++countCardsHandled;
                        }
                    } else if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.FLUID)) {
                        if (this.senseFluids(sensorCardCache)) {
                            ++countCardsHandled;
                        }
                    } else if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.ENERGY)) {
                        if (this.senseEnergy(sensorCardCache)) {
                            ++countCardsHandled;
                        }
                    } else if (extractorCardCache.cardType.equals((Object)BaseCard.CardType.CHEMICAL) && this.mekanismCache.senseChemicals(sensorCardCache)) {
                        ++countCardsHandled;
                    }
                }
                if (extractorCardCache.remainingSleep > 0) continue;
                extractorCardCache.remainingSleep = extractorCardCache.tickSpeed;
            }
        }
    }

    public void tickClient() {
        this.drawParticlesClient();
        this.particleRenderData.clear();
        this.particleRenderDataFluids.clear();
        this.particleRenderDataChemical.clear();
    }

    public void tickServer() {
        if (!this.discoveredNodes) {
            this.discoverAllNodes();
            this.findMyExtractors();
            this.updateOverclockers();
            this.discoveredNodes = true;
        }
        this.sense();
        if (!this.redstoneChecked) {
            this.populateThisRedstoneNetwork(true);
            this.redstoneChecked = true;
        }
        if (!this.redstoneRefreshed) {
            this.refreshRedstoneNetwork();
            this.redstoneRefreshed = true;
        }
        this.extract();
    }

    public void populateThisRedstoneNetwork(boolean notifyOthers) {
        Byte2ByteOpenHashMap myRedstoneInTemp = new Byte2ByteOpenHashMap();
        boolean updated = false;
        for (Direction direction : Direction.values()) {
            NodeSideCache nodeSideCache = this.nodeSideCaches[direction.ordinal()];
            for (int slot = 0; slot < 9; ++slot) {
                int redstoneStrength;
                ItemStack card = nodeSideCache.itemHandler.getStackInSlot(slot);
                if (!(card.getItem() instanceof CardRedstone) || BaseCard.getTransferMode(card) != 0 || (redstoneStrength = this.level.getSignal(this.getBlockPos().relative(direction), direction)) <= 0) continue;
                byte redstoneChannel = BaseCard.getRedstoneChannel(card);
                if (myRedstoneInTemp.containsKey(redstoneChannel)) {
                    byte existingRedstoneStrength = myRedstoneInTemp.get(redstoneChannel);
                    if (redstoneStrength <= existingRedstoneStrength) continue;
                    myRedstoneInTemp.put(redstoneChannel, (byte)redstoneStrength);
                    continue;
                }
                myRedstoneInTemp.put(redstoneChannel, (byte)redstoneStrength);
            }
            for (Map.Entry entry : nodeSideCache.myRedstoneFromSensors.byte2ByteEntrySet()) {
                myRedstoneInTemp.put((Byte)entry.getKey(), (Byte)entry.getValue());
            }
        }
        if (!myRedstoneInTemp.equals((Object)this.myRedstoneIn)) {
            updated = true;
            this.myRedstoneIn = new Byte2ByteOpenHashMap((Byte2ByteMap)myRedstoneInTemp);
        }
        if (updated && notifyOthers) {
            this.notifyOtherNodesOfChange();
        }
    }

    public void refreshRedstoneNetwork() {
        this.redstoneNetwork.clear();
        if (this.level == null) {
            return;
        }
        for (GlobalPos pos : this.otherNodesInNetwork) {
            LaserNodeBE laserNodeBE;
            Level targetLevel = MiscTools.getLevel(this.level.getServer(), pos);
            if (targetLevel == null || (laserNodeBE = this.getNodeAt(new GlobalPos(targetLevel.dimension(), this.getWorldPos(pos.pos())))) == null) continue;
            for (Map.Entry entry : laserNodeBE.myRedstoneIn.byte2ByteEntrySet()) {
                this.updateRedstoneNetwork((Byte)entry.getKey(), (Byte)entry.getValue());
            }
        }
        this.updateRedstoneOutputs();
        this.refreshCardsRedstone();
    }

    public void refreshCardsRedstone() {
        boolean inserterUpdated = false;
        boolean extractorUpdated = false;
        for (InserterCardCache inserterCardCache : this.inserterNodes) {
            if (!inserterCardCache.be.getBlockPos().equals((Object)this.getBlockPos())) continue;
            int tempEnabled = inserterCardCache.enabled ? 1 : 0;
            inserterCardCache.setEnabled();
            if (tempEnabled == inserterCardCache.enabled) continue;
            inserterUpdated = true;
        }
        for (Direction direction : Direction.values()) {
            NodeSideCache nodeSideCache = this.nodeSideCaches[direction.ordinal()];
            nodeSideCache.invalidateEnergy();
            for (ExtractorCardCache extractorCardCache : nodeSideCache.extractorCardCaches) {
                boolean tempEnabled = extractorCardCache.enabled;
                extractorCardCache.setEnabled();
                if (tempEnabled == extractorCardCache.enabled) continue;
                extractorUpdated = true;
            }
        }
        this.markDirtyClient();
        if (inserterUpdated) {
            if (this.level == null) {
                return;
            }
            for (GlobalPos pos : this.otherNodesInNetwork) {
                LaserNodeBE node;
                Level targetLevel = MiscTools.getLevel(this.level.getServer(), pos);
                if (targetLevel == null || (node = this.getNodeAt(new GlobalPos(targetLevel.dimension(), this.getWorldPos(pos.pos())))) == null) continue;
                node.checkInvNode(new GlobalPos(this.level.dimension(), this.getBlockPos()), true);
            }
        }
    }

    public byte getRedstoneChannelStrength(byte channel) {
        if (this.redstoneNetwork.containsKey(channel)) {
            return this.redstoneNetwork.get(channel);
        }
        return 0;
    }

    public void updateRedstoneNetwork(byte redstoneChannel, byte redstoneStrength) {
        if (this.redstoneNetwork.containsKey(redstoneChannel)) {
            byte existingRedstoneStrength = this.redstoneNetwork.get(redstoneChannel);
            if (redstoneStrength > existingRedstoneStrength) {
                this.redstoneNetwork.put(redstoneChannel, redstoneStrength);
            }
        } else {
            this.redstoneNetwork.put(redstoneChannel, redstoneStrength);
        }
    }

    public boolean getRedstoneSideStrong(Direction direction) {
        byte side = (byte)direction.ordinal();
        if (!this.myRedstoneOut.containsKey(side)) {
            return false;
        }
        byte redstoneOut = this.myRedstoneOut.get(side);
        return redstoneOut > 15;
    }

    public int getRedstoneSide(Direction direction) {
        byte side = (byte)direction.ordinal();
        if (!this.myRedstoneOut.containsKey(side)) {
            return 0;
        }
        int redstoneOut = this.myRedstoneOut.get(side);
        return redstoneOut > 15 ? redstoneOut - 15 : redstoneOut;
    }

    public void updateRedstoneOutputs() {
        Byte2ByteOpenHashMap myRedstoneOutTemp = new Byte2ByteOpenHashMap();
        this.redstoneCardSides.clear();
        for (Direction direction : Direction.values()) {
            byte side = (byte)direction.ordinal();
            NodeSideCache nodeSideCache = this.nodeSideCaches[direction.ordinal()];
            for (int slot = 0; slot < 9; ++slot) {
                ItemStack card = nodeSideCache.itemHandler.getStackInSlot(slot);
                if (card.getItem() instanceof CardRedstone && BaseCard.getTransferMode(card) == 1) {
                    byte redstoneStrength;
                    this.redstoneCardSides.put((byte)direction.ordinal(), true);
                    byte cardChannel = BaseCard.getRedstoneChannel(card);
                    if (!this.redstoneNetwork.containsKey(cardChannel) || (redstoneStrength = this.redstoneNetwork.get(cardChannel)) <= 0) continue;
                    if (CardRedstone.getStrong(card)) {
                        redstoneStrength = (byte)(redstoneStrength + 15);
                    }
                    if (myRedstoneOutTemp.containsKey(side)) {
                        byte existingRedstoneStrength = myRedstoneOutTemp.get(side);
                        if (redstoneStrength <= existingRedstoneStrength) continue;
                        myRedstoneOutTemp.put(side, redstoneStrength);
                        continue;
                    }
                    myRedstoneOutTemp.put(side, redstoneStrength);
                    continue;
                }
                if (!(card.getItem() instanceof CardRedstone) || BaseCard.getTransferMode(card) != 0) continue;
                this.redstoneCardSides.put((byte)direction.ordinal(), true);
            }
            if (!this.firstTimeNodeLoaded && Objects.equals(myRedstoneOutTemp.get(side), this.myRedstoneOut.get(side))) continue;
            if (myRedstoneOutTemp.containsKey(side)) {
                this.myRedstoneOut.put(side, myRedstoneOutTemp.get(side));
            } else {
                this.myRedstoneOut.remove(side);
            }
            this.level.neighborChanged(this.getBlockPos().relative(direction), this.getBlockState().getBlock(), this.getBlockPos());
            this.level.updateNeighborsAtExceptFromFacing(this.getBlockPos().relative(direction), this.getBlockState().getBlock(), direction.getOpposite());
        }
        BlockState state = this.getBlockState();
        state.updateNeighbourShapes((LevelAccessor)this.level, this.getBlockPos(), 3);
        if (this.firstTimeNodeLoaded) {
            this.firstTimeNodeLoaded = false;
        }
    }

    public void sortInserters() {
        this.inserterNodes.sort(Comparator.comparingDouble(InserterCardCache::getDistance));
        this.inserterNodes.sort(Comparator.comparingInt(InserterCardCache::getPriority).reversed());
    }

    public List<InserterCardCache> getPossibleInserters(ExtractorCardCache extractorCardCache, ItemStack stack) {
        ItemStackKey key = new ItemStackKey(stack, true);
        if (this.inserterCache.containsKey(extractorCardCache)) {
            if (this.inserterCache.get(extractorCardCache).containsKey(key)) {
                return this.inserterCache.get(extractorCardCache).get(key);
            }
            List<InserterCardCache> nodes = this.inserterNodes.stream().filter(p -> p.channel == extractorCardCache.channel && p.enabled && p.isStackValidForCard(stack) && p.cardType.equals((Object)extractorCardCache.cardType) && (!p.relativePos.pos().equals((Object)BlockPos.ZERO) || !p.direction.equals((Object)extractorCardCache.direction) || p.sneaky != extractorCardCache.sneaky)).toList();
            this.inserterCache.get(extractorCardCache).put(key, nodes);
            return nodes;
        }
        List<InserterCardCache> nodes = this.inserterNodes.stream().filter(p -> p.channel == extractorCardCache.channel && p.enabled && p.isStackValidForCard(stack) && p.cardType.equals((Object)extractorCardCache.cardType) && (!p.relativePos.pos().equals((Object)BlockPos.ZERO) || !p.direction.equals((Object)extractorCardCache.direction) || p.sneaky != extractorCardCache.sneaky)).toList();
        HashMap<ItemStackKey, List<InserterCardCache>> tempMap = new HashMap<ItemStackKey, List<InserterCardCache>>();
        tempMap.put(key, nodes);
        this.inserterCache.put(extractorCardCache, tempMap);
        return nodes;
    }

    public List<InserterCardCache> getPossibleInserters(ExtractorCardCache extractorCardCache, FluidStack stack) {
        FluidStackKey key = new FluidStackKey(stack, true);
        if (this.inserterCacheFluid.containsKey(extractorCardCache)) {
            if (this.inserterCacheFluid.get(extractorCardCache).containsKey(key)) {
                return this.inserterCacheFluid.get(extractorCardCache).get(key);
            }
            List<InserterCardCache> nodes = this.inserterNodes.stream().filter(p -> p.channel == extractorCardCache.channel && p.enabled && p.isStackValidForCard(stack) && p.cardType.equals((Object)extractorCardCache.cardType) && (!p.relativePos.pos().equals((Object)BlockPos.ZERO) || !p.direction.equals((Object)extractorCardCache.direction))).toList();
            this.inserterCacheFluid.get(extractorCardCache).put(key, nodes);
            return nodes;
        }
        List<InserterCardCache> nodes = this.inserterNodes.stream().filter(p -> p.channel == extractorCardCache.channel && p.enabled && p.isStackValidForCard(stack) && p.cardType.equals((Object)extractorCardCache.cardType) && (!p.relativePos.pos().equals((Object)BlockPos.ZERO) || !p.direction.equals((Object)extractorCardCache.direction))).toList();
        HashMap<FluidStackKey, List<InserterCardCache>> tempMap = new HashMap<FluidStackKey, List<InserterCardCache>>();
        tempMap.put(key, nodes);
        this.inserterCacheFluid.put(extractorCardCache, tempMap);
        return nodes;
    }

    public List<InserterCardCache> getChannelMatchInserters(ExtractorCardCache extractorCardCache) {
        if (this.channelOnlyCache.containsKey(extractorCardCache)) {
            return this.channelOnlyCache.get(extractorCardCache);
        }
        List<InserterCardCache> nodes = this.inserterNodes.stream().filter(p -> p.channel == extractorCardCache.channel && p.enabled && p.cardType == extractorCardCache.cardType && (!p.relativePos.pos().equals((Object)BlockPos.ZERO) || !p.direction.equals((Object)extractorCardCache.direction))).toList();
        this.channelOnlyCache.put(extractorCardCache, nodes);
        return nodes;
    }

    public boolean chunksLoaded(GlobalPos nodePos, BlockPos destinationPos) {
        assert (MiscTools.getLevel(this.level.getServer(), nodePos) != null);
        if (!MiscTools.getLevel(this.level.getServer(), nodePos).isLoaded(nodePos.pos())) {
            return false;
        }
        return MiscTools.getLevel(this.level.getServer(), nodePos).isLoaded(destinationPos);
    }

    public int getNextRR(ExtractorCardCache extractorCardCache, List<InserterCardCache> inserterCardCaches) {
        int currentRR;
        int nextRR = this.roundRobinMap.containsKey(extractorCardCache) ? ((currentRR = this.roundRobinMap.get(extractorCardCache).intValue()) + 1 >= inserterCardCaches.size() ? 0 : currentRR + 1) : 0;
        this.roundRobinMap.put(extractorCardCache, nextRR);
        return nextRR;
    }

    public int getRR(ExtractorCardCache extractorCardCache) {
        if (this.roundRobinMap.containsKey(extractorCardCache)) {
            return this.roundRobinMap.get(extractorCardCache);
        }
        this.roundRobinMap.put(extractorCardCache, 0);
        return 0;
    }

    public List<InserterCardCache> applyRR(ExtractorCardCache extractorCardCache, List<InserterCardCache> inserterCardCaches, int nextRR) {
        ArrayList<List<InserterCardCache>> lists = new ArrayList<List<InserterCardCache>>(inserterCardCaches.stream().collect(Collectors.partitioningBy(s -> inserterCardCaches.indexOf(s) >= nextRR)).values());
        ((List)lists.get(1)).addAll((Collection)lists.get(0));
        return (List)lists.get(1);
    }

    public boolean extractItem(ExtractorCardCache extractorCardCache, IItemHandler fromInventory, ItemStack extractStack) {
        TransferResult extractResults = ItemHandlerUtil.extractItemWithSlots(this, fromInventory, extractStack, extractStack.getCount(), true, true, extractorCardCache);
        int amtNeeded = extractResults.getTotalItemCounts();
        boolean exactMode = extractorCardCache.exact;
        if (amtNeeded != extractorCardCache.extractAmt && exactMode) {
            return false;
        }
        extractStack.setCount(amtNeeded);
        TransferResult insertResults = new TransferResult();
        List<InserterCardCache> inserterCardCaches = this.getPossibleInserters(extractorCardCache, extractStack);
        int roundRobin = -1;
        if (extractorCardCache.roundRobin != 0) {
            roundRobin = this.getRR(extractorCardCache);
            inserterCardCaches = this.applyRR(extractorCardCache, inserterCardCaches, roundRobin);
        }
        int amtStillNeeded = amtNeeded;
        for (InserterCardCache inserterCardCache : inserterCardCaches) {
            LaserNodeItemHandler laserNodeItemHandler = this.getLaserNodeHandlerItem(inserterCardCache);
            if (laserNodeItemHandler == null) continue;
            TransferResult thisResult = ItemHandlerUtil.insertItemWithSlots(laserNodeItemHandler.be, laserNodeItemHandler.handler, extractStack, 0, true, extractorCardCache.isCompareNBT, true, inserterCardCache);
            if (extractorCardCache.roundRobin == 2 && thisResult.getTotalItemCounts() < amtStillNeeded) {
                return false;
            }
            if (thisResult.results.isEmpty()) {
                this.getNextRR(extractorCardCache, inserterCardCaches);
                continue;
            }
            insertResults.addResult(thisResult);
            insertResults.remainingStack = ItemStack.EMPTY;
            int amtFit = thisResult.getTotalItemCounts();
            if ((amtStillNeeded -= amtFit) == 0) break;
            extractStack.setCount(amtStillNeeded);
        }
        if (amtStillNeeded == amtNeeded || amtStillNeeded != 0 && exactMode) {
            return false;
        }
        extractStack.setCount(amtNeeded - amtStillNeeded);
        for (TransferResult.Result result : insertResults.results) {
            ItemStack tempStack = extractStack.split(result.itemStack.getCount());
            ItemStack returnedStack = result.insertHandler.insertItem(result.insertSlot, tempStack, true);
            if (!returnedStack.isEmpty()) break;
            int amtToExtract = tempStack.getCount();
            for (TransferResult.Result extractResult : extractResults.results) {
                int amtToExtractThis = Math.min(amtToExtract, extractResult.itemStack.getCount());
                ItemStack extractedStack = extractResult.extractHandler.extractItem(extractResult.extractSlot, amtToExtractThis, false);
                if (extractResult.itemStack.getCount() == extractedStack.getCount()) {
                    extractResults.results.remove(extractResult);
                } else {
                    extractResult.itemStack.split(extractedStack.getCount());
                }
                if ((amtToExtract -= extractedStack.getCount()) != 0) continue;
                break;
            }
            result.insertHandler.insertItem(result.insertSlot, tempStack, false);
            if (result.inserterCardCache == null) continue;
            this.drawParticles(tempStack, extractorCardCache.direction, this, result.toBE, result.inserterCardCache.direction, extractorCardCache.cardSlot, result.inserterCardCache.cardSlot);
        }
        if (extractorCardCache.roundRobin != 0) {
            this.getNextRR(extractorCardCache, inserterCardCaches);
        }
        return true;
    }

    public boolean updateRedstoneFromSensor(boolean filterMatched, byte redstoneChannel, NodeSideCache nodeSideCache) {
        byte newRedstoneStrength;
        byte currentRedstoneFromNetwork = nodeSideCache.myRedstoneFromSensors.get(redstoneChannel);
        byte by = newRedstoneStrength = filterMatched ? (byte)15 : 0;
        if (newRedstoneStrength == 0) {
            nodeSideCache.myRedstoneFromSensors.remove(redstoneChannel);
        } else {
            nodeSideCache.myRedstoneFromSensors.put(redstoneChannel, newRedstoneStrength);
        }
        return currentRedstoneFromNetwork != newRedstoneStrength;
    }

    public boolean senseItems(SensorCardCache sensorCardCache) {
        BlockPos adjacentPos = this.getBlockPos().relative(sensorCardCache.direction);
        assert (this.level != null);
        if (!this.level.isLoaded(adjacentPos)) {
            return false;
        }
        ItemStack filter = sensorCardCache.filterCard;
        boolean andMode = BaseCard.getAnd(sensorCardCache.cardItem);
        boolean filterMatched = false;
        NodeSideCache nodeSideCache = this.nodeSideCaches[sensorCardCache.direction.ordinal()];
        if (filter.isEmpty()) {
            if (this.updateRedstoneFromSensor(false, sensorCardCache.redstoneChannel, nodeSideCache)) {
                this.rendersChecked = false;
                this.clearCachedInventories();
                this.redstoneChecked = false;
            }
            return false;
        }
        IItemHandler adjacentInventory = this.getAttachedInventory(sensorCardCache.direction, sensorCardCache.sneaky);
        if (adjacentInventory == null) {
            adjacentInventory = this.EMPTY;
        }
        ItemHandlerUtil.InventoryCounts inventoryCounts = new ItemHandlerUtil.InventoryCounts(adjacentInventory, sensorCardCache.isCompareNBT);
        if (filter.getItem() instanceof FilterMod) {
            List filteredItemsListOriginal = sensorCardCache.filteredItems;
            ArrayList filteredItemsList = new ArrayList(filteredItemsListOriginal);
            List itemStacksInChest = inventoryCounts.getItemCounts().values().stream().toList();
            block0: for (ItemStack stack : itemStacksInChest) {
                for (ItemStack testStack : filteredItemsListOriginal) {
                    if (!stack.getItem().getCreatorModId(stack).equals(testStack.getItem().getCreatorModId(testStack))) continue;
                    filteredItemsList.remove(testStack);
                    if (andMode) continue;
                    break block0;
                }
            }
            filterMatched = andMode ? filteredItemsList.size() == 0 : filteredItemsList.size() < filteredItemsListOriginal.size();
        } else if (filter.getItem() instanceof FilterBasic) {
            List filteredItemsList = sensorCardCache.filteredItems;
            boolean allMatched = true;
            for (ItemStack itemStack : filteredItemsList) {
                int amtHad = inventoryCounts.getCount(itemStack);
                if (amtHad > 0) {
                    if (andMode) continue;
                    filterMatched = true;
                    break;
                }
                if (!andMode) continue;
                allMatched = false;
                break;
            }
            if (andMode && !filteredItemsList.isEmpty()) {
                filterMatched = allMatched;
            }
        } else if (filter.getItem() instanceof FilterCount) {
            List filteredItemsList = sensorCardCache.filteredItems;
            boolean allMatched = true;
            for (ItemStack itemStack : filteredItemsList) {
                int amtHad = inventoryCounts.getCount(itemStack);
                if (amtHad < itemStack.getCount() || sensorCardCache.exact && amtHad > itemStack.getCount()) {
                    if (!andMode) continue;
                    allMatched = false;
                    break;
                }
                if (andMode) continue;
                filterMatched = true;
                break;
            }
            if (andMode && !filteredItemsList.isEmpty()) {
                filterMatched = allMatched;
            }
        } else if (filter.getItem() instanceof FilterTag) {
            ArrayList tags = new ArrayList(sensorCardCache.filterTags);
            int tagsToMatch = tags.size();
            List itemStacksInChest = inventoryCounts.getItemCounts().values().stream().toList();
            block4: for (ItemStack itemStack : itemStacksInChest) {
                for (TagKey tagKey : itemStack.getItem().builtInRegistryHolder().tags().toList()) {
                    String itemTag = tagKey.location().toString().toLowerCase(Locale.ROOT);
                    if (!tags.contains(itemTag)) continue;
                    tags.remove(itemTag);
                    if (andMode) continue;
                    break block4;
                }
            }
            if (andMode) {
                filterMatched = tags.size() == 0;
            } else {
                boolean bl = filterMatched = tags.size() < tagsToMatch;
            }
        }
        if (this.updateRedstoneFromSensor(filterMatched, sensorCardCache.redstoneChannel, nodeSideCache)) {
            this.rendersChecked = false;
            this.clearCachedInventories();
            this.redstoneChecked = false;
        }
        return true;
    }

    public boolean senseFluids(SensorCardCache sensorCardCache) {
        BlockPos adjacentPos = this.getBlockPos().relative(sensorCardCache.direction);
        assert (this.level != null);
        if (!this.level.isLoaded(adjacentPos)) {
            return false;
        }
        NodeSideCache nodeSideCache = this.nodeSideCaches[sensorCardCache.direction.ordinal()];
        IFluidHandler adacentTank = this.getAttachedFluidTank(sensorCardCache.direction, sensorCardCache.sneaky);
        if (adacentTank == null) {
            if (this.updateRedstoneFromSensor(false, sensorCardCache.redstoneChannel, nodeSideCache)) {
                this.rendersChecked = false;
                this.clearCachedInventories();
                this.redstoneChecked = false;
            }
            return false;
        }
        ItemStack filter = sensorCardCache.filterCard;
        boolean andMode = BaseCard.getAnd(sensorCardCache.cardItem);
        boolean filterMatched = false;
        if (filter.isEmpty()) {
            if (this.updateRedstoneFromSensor(false, sensorCardCache.redstoneChannel, nodeSideCache)) {
                this.rendersChecked = false;
                this.clearCachedInventories();
                this.redstoneChecked = false;
            }
            return false;
        }
        if (filter.getItem() instanceof FilterBasic) {
            List<FluidStack> filteredFluids = sensorCardCache.getFilteredFluids();
            ArrayList<FluidStack> filteredFluidsOriginal = new ArrayList<FluidStack>(filteredFluids);
            block0: for (FluidStack fluidStack : filteredFluidsOriginal) {
                for (int tank = 0; tank < adacentTank.getTanks(); ++tank) {
                    FluidStack stackInTank = adacentTank.getFluidInTank(tank);
                    if (!FluidStack.isSameFluidSameComponents((FluidStack)stackInTank, (FluidStack)fluidStack)) continue;
                    filteredFluids.remove(fluidStack);
                    if (!andMode) break block0;
                }
            }
            filterMatched = andMode ? filteredFluids.size() == 0 : filteredFluids.size() < filteredFluidsOriginal.size();
        } else if (filter.getItem() instanceof FilterCount) {
            List<FluidStack> filteredFluids = sensorCardCache.getFilteredFluids();
            ArrayList<FluidStack> filteredFluidsOriginal = new ArrayList<FluidStack>(filteredFluids);
            block2: for (FluidStack fluidStack : filteredFluidsOriginal) {
                int desiredAmt = sensorCardCache.getFilterAmt(fluidStack);
                for (int tank = 0; tank < adacentTank.getTanks(); ++tank) {
                    int amtHad;
                    FluidStack stackInTank = adacentTank.getFluidInTank(tank);
                    if (!FluidStack.isSameFluidSameComponents((FluidStack)stackInTank, (FluidStack)fluidStack) || (amtHad = stackInTank.getAmount()) < desiredAmt || sensorCardCache.exact && amtHad > desiredAmt) continue;
                    filteredFluids.remove(fluidStack);
                    if (!andMode) break block2;
                }
            }
            filterMatched = andMode ? filteredFluids.size() == 0 : filteredFluids.size() < filteredFluidsOriginal.size();
        } else if (filter.getItem() instanceof FilterTag) {
            List<String> tags = sensorCardCache.getFilterTags();
            int tagsToMatch = tags.size();
            block4: for (int tank = 0; tank < adacentTank.getTanks(); ++tank) {
                FluidStack stackInTank = adacentTank.getFluidInTank(tank);
                for (TagKey tagKey : stackInTank.getFluid().builtInRegistryHolder().tags().toList()) {
                    String fluidTag = tagKey.location().toString().toLowerCase(Locale.ROOT);
                    if (!tags.contains(fluidTag)) continue;
                    tags.remove(fluidTag);
                    if (andMode) continue;
                    break block4;
                }
            }
            if (andMode) {
                filterMatched = tags.size() == 0;
            } else {
                boolean bl = filterMatched = tags.size() < tagsToMatch;
            }
        }
        if (this.updateRedstoneFromSensor(filterMatched, sensorCardCache.redstoneChannel, nodeSideCache)) {
            this.rendersChecked = false;
            this.clearCachedInventories();
            this.redstoneChecked = false;
        }
        return true;
    }

    public boolean senseEnergy(SensorCardCache sensorCardCache) {
        BlockPos adjacentPos = this.getBlockPos().relative(sensorCardCache.direction);
        assert (this.level != null);
        if (!this.level.isLoaded(adjacentPos)) {
            return false;
        }
        IEnergyStorage adjacentEnergy = this.getAttachedEnergyTank(sensorCardCache.direction, sensorCardCache.sneaky);
        NodeSideCache nodeSideCache = this.nodeSideCaches[sensorCardCache.direction.ordinal()];
        if (adjacentEnergy == null) {
            if (this.updateRedstoneFromSensor(false, sensorCardCache.redstoneChannel, nodeSideCache)) {
                this.rendersChecked = false;
                this.clearCachedInventories();
                this.redstoneChecked = false;
            }
            return false;
        }
        boolean filterMatched = false;
        int desired = (int)((float)adjacentEnergy.getMaxEnergyStored() * ((float)sensorCardCache.insertLimit / 100.0f));
        int amtHad = adjacentEnergy.getEnergyStored();
        filterMatched = amtHad >= desired && (!sensorCardCache.exact || amtHad <= desired);
        if (this.updateRedstoneFromSensor(filterMatched, sensorCardCache.redstoneChannel, nodeSideCache)) {
            this.rendersChecked = false;
            this.clearCachedInventories();
            this.redstoneChecked = false;
        }
        return true;
    }

    public boolean sendItems(ExtractorCardCache extractorCardCache) {
        BlockPos adjacentPos = this.getBlockPos().relative(extractorCardCache.direction);
        assert (this.level != null);
        if (!this.level.isLoaded(adjacentPos)) {
            return false;
        }
        IItemHandler adjacentInventory = this.getAttachedInventory(extractorCardCache.direction, extractorCardCache.sneaky);
        if (adjacentInventory == null) {
            adjacentInventory = this.EMPTY;
        }
        ItemHandlerUtil.InventoryCounts inventoryCounts = new ItemHandlerUtil.InventoryCounts();
        if (extractorCardCache.filterCard.getItem() instanceof FilterCount) {
            inventoryCounts = new ItemHandlerUtil.InventoryCounts(adjacentInventory, extractorCardCache.isCompareNBT);
        }
        for (int slot = 0; slot < adjacentInventory.getSlots(); ++slot) {
            ItemStack stackInSlot = adjacentInventory.getStackInSlot(slot);
            if (stackInSlot.isEmpty() || !extractorCardCache.isStackValidForCard(stackInSlot)) continue;
            ItemStack extractStack = stackInSlot.copy();
            extractStack.setCount(extractorCardCache.extractAmt);
            if (extractorCardCache.filterCard.getItem() instanceof FilterCount) {
                int amtInInv;
                int amtAllowedToRemove;
                int filterCount = extractorCardCache.getFilterAmt(extractStack);
                if (filterCount <= 0 || (amtAllowedToRemove = (amtInInv = inventoryCounts.getCount(extractStack)) - filterCount) <= 0) continue;
                int amtRemaining = Math.min(extractStack.getCount(), amtAllowedToRemove);
                extractStack.setCount(amtRemaining);
            }
            if (!this.extractItem(extractorCardCache, adjacentInventory, extractStack)) continue;
            return true;
        }
        return false;
    }

    public boolean extractFluidStack(ExtractorCardCache extractorCardCache, IFluidHandler fromInventory, FluidStack extractStack) {
        int totalAmtNeeded = extractStack.getAmount();
        int amtToExtract = extractStack.getAmount();
        List<InserterCardCache> inserterCardCaches = this.getPossibleInserters(extractorCardCache, extractStack);
        int roundRobin = -1;
        boolean foundAnything = false;
        if (extractorCardCache.roundRobin != 0) {
            roundRobin = this.getRR(extractorCardCache);
            inserterCardCaches = this.applyRR(extractorCardCache, inserterCardCaches, roundRobin);
        }
        for (InserterCardCache inserterCardCache : inserterCardCaches) {
            LaserNodeFluidHandler laserNodeFluidHandler = this.getLaserNodeHandlerFluid(inserterCardCache);
            if (laserNodeFluidHandler == null) continue;
            IFluidHandler handler = laserNodeFluidHandler.handler;
            if (inserterCardCache.filterCard.getItem() instanceof FilterCount) {
                int filterCount = inserterCardCache.getFilterAmt(extractStack);
                for (int tank = 0; tank < handler.getTanks(); ++tank) {
                    int currentAmt;
                    int neededAmt;
                    FluidStack fluidStack = handler.getFluidInTank(tank);
                    if (!fluidStack.isEmpty() && !FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)extractStack) || (neededAmt = filterCount - (currentAmt = fluidStack.getAmount())) >= extractStack.getAmount()) continue;
                    amtToExtract = neededAmt;
                    break;
                }
            }
            if (amtToExtract == 0) {
                amtToExtract = totalAmtNeeded;
                continue;
            }
            extractStack.setAmount(amtToExtract);
            int amtFit = handler.fill(extractStack, IFluidHandler.FluidAction.SIMULATE);
            if (amtFit == 0) {
                if (extractorCardCache.roundRobin == 2) {
                    return false;
                }
                if (extractorCardCache.roundRobin == 0) continue;
                this.getNextRR(extractorCardCache, inserterCardCaches);
                continue;
            }
            extractStack.setAmount(amtFit);
            FluidStack drainedStack = fromInventory.drain(extractStack, IFluidHandler.FluidAction.EXECUTE);
            if (drainedStack.isEmpty()) continue;
            foundAnything = true;
            handler.fill(drainedStack, IFluidHandler.FluidAction.EXECUTE);
            this.drawParticlesFluid(drainedStack, extractorCardCache.direction, extractorCardCache.be, inserterCardCache.be, inserterCardCache.direction, extractorCardCache.cardSlot, inserterCardCache.cardSlot);
            amtToExtract = totalAmtNeeded -= drainedStack.getAmount();
            if (extractorCardCache.roundRobin != 0) {
                this.getNextRR(extractorCardCache, inserterCardCaches);
            }
            if (totalAmtNeeded != 0) continue;
            return true;
        }
        return foundAnything;
    }

    public boolean extractFluidStackExact(ExtractorCardCache extractorCardCache, IFluidHandler fromInventory, FluidStack extractStack) {
        int totalAmtNeeded = extractStack.getAmount();
        int amtToExtract = extractStack.getAmount();
        FluidStack testDrain = fromInventory.drain(extractStack, IFluidHandler.FluidAction.SIMULATE);
        if (testDrain.getAmount() < totalAmtNeeded) {
            return false;
        }
        List<InserterCardCache> inserterCardCaches = this.getPossibleInserters(extractorCardCache, extractStack);
        int roundRobin = -1;
        if (extractorCardCache.roundRobin != 0) {
            roundRobin = this.getRR(extractorCardCache);
            inserterCardCaches = this.applyRR(extractorCardCache, inserterCardCaches, roundRobin);
        }
        Object2IntOpenHashMap insertHandlers = new Object2IntOpenHashMap();
        for (InserterCardCache inserterCardCache : inserterCardCaches) {
            LaserNodeFluidHandler laserNodeFluidHandler = this.getLaserNodeHandlerFluid(inserterCardCache);
            if (laserNodeFluidHandler == null) continue;
            IFluidHandler handler = laserNodeFluidHandler.handler;
            if (inserterCardCache.filterCard.getItem() instanceof FilterCount) {
                int filterCount = inserterCardCache.getFilterAmt(extractStack);
                for (int tank = 0; tank < handler.getTanks(); ++tank) {
                    int currentAmt;
                    int neededAmt;
                    FluidStack fluidStack = handler.getFluidInTank(tank);
                    if (!fluidStack.isEmpty() && !FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)extractStack) || (neededAmt = filterCount - (currentAmt = fluidStack.getAmount())) >= totalAmtNeeded) continue;
                    amtToExtract = neededAmt;
                    break;
                }
            }
            if (amtToExtract == 0) {
                amtToExtract = totalAmtNeeded;
                continue;
            }
            extractStack.setAmount(amtToExtract);
            int amtFit = handler.fill(extractStack, IFluidHandler.FluidAction.SIMULATE);
            if (amtFit == 0) {
                if (extractorCardCache.roundRobin == 2) {
                    return false;
                }
                if (extractorCardCache.roundRobin == 0) continue;
                this.getNextRR(extractorCardCache, inserterCardCaches);
                continue;
            }
            extractStack.setAmount(amtFit);
            FluidStack drainedStack = fromInventory.drain(extractStack, IFluidHandler.FluidAction.SIMULATE);
            if (drainedStack.isEmpty()) continue;
            insertHandlers.put(inserterCardCache, drainedStack.getAmount());
            amtToExtract = totalAmtNeeded -= drainedStack.getAmount();
            if (extractorCardCache.roundRobin != 0) {
                this.getNextRR(extractorCardCache, inserterCardCaches);
            }
            if (totalAmtNeeded != 0) continue;
            break;
        }
        if (totalAmtNeeded > 0) {
            return false;
        }
        for (Map.Entry entry : insertHandlers.entrySet()) {
            InserterCardCache inserterCardCache = (InserterCardCache)entry.getKey();
            LaserNodeFluidHandler laserNodeFluidHandler = this.getLaserNodeHandlerFluid(inserterCardCache);
            IFluidHandler handler = laserNodeFluidHandler.handler;
            extractStack.setAmount(((Integer)entry.getValue()).intValue());
            FluidStack drainedStack = fromInventory.drain(extractStack, IFluidHandler.FluidAction.EXECUTE);
            handler.fill(drainedStack, IFluidHandler.FluidAction.EXECUTE);
            this.drawParticlesFluid(drainedStack, extractorCardCache.direction, extractorCardCache.be, inserterCardCache.be, inserterCardCache.direction, extractorCardCache.cardSlot, inserterCardCache.cardSlot);
        }
        return true;
    }

    public boolean sendFluids(ExtractorCardCache extractorCardCache) {
        BlockPos adjacentPos = this.getBlockPos().relative(extractorCardCache.direction);
        assert (this.level != null);
        if (!this.level.isLoaded(adjacentPos)) {
            return false;
        }
        IFluidHandler adjacentTank = this.getAttachedFluidTank(extractorCardCache.direction, extractorCardCache.sneaky);
        if (adjacentTank == null) {
            return false;
        }
        for (int tank = 0; tank < adjacentTank.getTanks(); ++tank) {
            FluidStack fluidStack = adjacentTank.getFluidInTank(tank);
            if (fluidStack.isEmpty() || !extractorCardCache.isStackValidForCard(fluidStack)) continue;
            FluidStack extractStack = fluidStack.copy();
            extractStack.setAmount(extractorCardCache.extractAmt);
            if (extractorCardCache.filterCard.getItem() instanceof FilterCount) {
                int amtInInv;
                int amtAllowedToRemove;
                int filterCount = extractorCardCache.getFilterAmt(extractStack);
                if (filterCount <= 0 || (amtAllowedToRemove = (amtInInv = fluidStack.getAmount()) - filterCount) <= 0) continue;
                int amtRemaining = Math.min(extractStack.getAmount(), amtAllowedToRemove);
                extractStack.setAmount(amtRemaining);
            }
            if (!(extractorCardCache.exact ? this.extractFluidStackExact(extractorCardCache, adjacentTank, extractStack) : this.extractFluidStack(extractorCardCache, adjacentTank, extractStack))) continue;
            return true;
        }
        return false;
    }

    public int receiveEnergy(Direction direction, int receiveAmt, boolean simulate) {
        int totalAmtNeeded = receiveAmt;
        int totalAmtSent = 0;
        NodeSideCache nodeSideCache = this.nodeSideCaches[direction.ordinal()];
        int countCardsHandled = 0;
        for (ExtractorCardCache extractorCardCache : nodeSideCache.extractorCardCaches) {
            if (!extractorCardCache.enabled) continue;
            if (countCardsHandled > nodeSideCache.overClocker) {
                return totalAmtSent;
            }
            if (extractorCardCache instanceof StockerCardCache || !extractorCardCache.cardType.equals((Object)BaseCard.CardType.ENERGY)) continue;
            int amtSent = this.sendReceivedEnergy(extractorCardCache, totalAmtNeeded, simulate);
            if (amtSent > 0) {
                ++countCardsHandled;
            }
            totalAmtSent += amtSent;
            if ((totalAmtNeeded -= amtSent) > 0) continue;
            break;
        }
        return totalAmtSent;
    }

    public int sendReceivedEnergy(ExtractorCardCache extractorCardCache, int receiveAmt, boolean simulate) {
        int totalAmtNeeded = Math.min(extractorCardCache.extractAmt, receiveAmt);
        int totalFit = 0;
        List<InserterCardCache> inserterCardCaches = this.getChannelMatchInserters(extractorCardCache);
        int roundRobin = -1;
        if (extractorCardCache.roundRobin != 0) {
            roundRobin = this.getRR(extractorCardCache);
            inserterCardCaches = this.applyRR(extractorCardCache, inserterCardCaches, roundRobin);
        }
        for (InserterCardCache inserterCardCache : inserterCardCaches) {
            BlockEntity targetBE;
            LaserNodeEnergyHandler laserNodeEnergyHandler = this.getLaserNodeHandlerEnergy(inserterCardCache);
            if (laserNodeEnergyHandler == null || (targetBE = this.level.getBlockEntity(laserNodeEnergyHandler.be.getBlockPos().relative(inserterCardCache.direction))) instanceof LaserNodeBE) continue;
            IEnergyStorage energyStorage = laserNodeEnergyHandler.handler;
            int desired = inserterCardCache.insertLimit != 100 ? (int)((float)energyStorage.getMaxEnergyStored() * ((float)inserterCardCache.insertLimit / 100.0f)) - energyStorage.getEnergyStored() : receiveAmt;
            if (desired <= 0) continue;
            int amtToTry = Math.min(desired, totalAmtNeeded);
            int amtFit = energyStorage.receiveEnergy(amtToTry, true);
            if (amtFit == 0) {
                if (extractorCardCache.roundRobin == 2) {
                    return totalFit;
                }
                if (extractorCardCache.roundRobin == 0) continue;
                this.getNextRR(extractorCardCache, inserterCardCaches);
                continue;
            }
            totalAmtNeeded -= amtFit;
            totalFit += amtFit;
            if (!simulate) {
                energyStorage.receiveEnergy(amtFit, false);
            }
            if (extractorCardCache.roundRobin != 0) {
                this.getNextRR(extractorCardCache, inserterCardCaches);
            }
            if (totalAmtNeeded != 0) continue;
            return totalFit;
        }
        return totalFit;
    }

    public boolean extractEnergy(ExtractorCardCache extractorCardCache, IEnergyStorage fromEnergyTank, int extractAmt) {
        int totalAmtNeeded = extractAmt;
        List<InserterCardCache> inserterCardCaches = this.getChannelMatchInserters(extractorCardCache);
        int roundRobin = -1;
        boolean foundAnything = false;
        if (extractorCardCache.roundRobin != 0) {
            roundRobin = this.getRR(extractorCardCache);
            inserterCardCaches = this.applyRR(extractorCardCache, inserterCardCaches, roundRobin);
        }
        for (InserterCardCache inserterCardCache : inserterCardCaches) {
            LaserNodeEnergyHandler laserNodeEnergyHandler = this.getLaserNodeHandlerEnergy(inserterCardCache);
            if (laserNodeEnergyHandler == null) continue;
            IEnergyStorage energyStorage = laserNodeEnergyHandler.handler;
            int desired = inserterCardCache.insertLimit != 100 ? (int)((float)energyStorage.getMaxEnergyStored() * ((float)inserterCardCache.insertLimit / 100.0f)) - energyStorage.getEnergyStored() : extractAmt;
            if (desired <= 0) continue;
            int amtToTry = Math.min(desired, totalAmtNeeded);
            int amtFit = energyStorage.receiveEnergy(amtToTry, true);
            if (amtFit == 0) {
                if (extractorCardCache.roundRobin == 2) {
                    return false;
                }
                if (extractorCardCache.roundRobin == 0) continue;
                this.getNextRR(extractorCardCache, inserterCardCaches);
                continue;
            }
            int amtDrained = fromEnergyTank.extractEnergy(amtFit, false);
            if (amtDrained == 0) continue;
            foundAnything = true;
            energyStorage.receiveEnergy(amtDrained, false);
            totalAmtNeeded -= amtDrained;
            if (extractorCardCache.roundRobin != 0) {
                this.getNextRR(extractorCardCache, inserterCardCaches);
            }
            if (totalAmtNeeded != 0) continue;
            return true;
        }
        return foundAnything;
    }

    public boolean extractEnergyExact(ExtractorCardCache extractorCardCache, IEnergyStorage fromEnergyTank, int extractAmt) {
        int totalAmtNeeded = extractAmt;
        List<InserterCardCache> inserterCardCaches = this.getChannelMatchInserters(extractorCardCache);
        int roundRobin = -1;
        if (extractorCardCache.roundRobin != 0) {
            roundRobin = this.getRR(extractorCardCache);
            inserterCardCaches = this.applyRR(extractorCardCache, inserterCardCaches, roundRobin);
        }
        Object2IntOpenHashMap insertHandlers = new Object2IntOpenHashMap();
        for (InserterCardCache inserterCardCache : inserterCardCaches) {
            LaserNodeEnergyHandler laserNodeEnergyHandler = this.getLaserNodeHandlerEnergy(inserterCardCache);
            if (laserNodeEnergyHandler == null) continue;
            IEnergyStorage energyStorage = laserNodeEnergyHandler.handler;
            int desired = inserterCardCache.insertLimit != 100 ? (int)((float)energyStorage.getMaxEnergyStored() * ((float)inserterCardCache.insertLimit / 100.0f)) - energyStorage.getEnergyStored() : extractAmt;
            if (desired <= 0) continue;
            int amtToTry = Math.min(desired, totalAmtNeeded);
            int amtFit = energyStorage.receiveEnergy(amtToTry, true);
            if (amtFit == 0) {
                if (extractorCardCache.roundRobin == 2) {
                    return false;
                }
                if (extractorCardCache.roundRobin == 0) continue;
                this.getNextRR(extractorCardCache, inserterCardCaches);
                continue;
            }
            int amtDrained = fromEnergyTank.extractEnergy(amtFit, true);
            if (amtDrained == 0) continue;
            insertHandlers.put(inserterCardCache, amtDrained);
            totalAmtNeeded -= amtDrained;
            if (extractorCardCache.roundRobin != 0) {
                this.getNextRR(extractorCardCache, inserterCardCaches);
            }
            if (totalAmtNeeded != 0) continue;
            break;
        }
        if (totalAmtNeeded > 0) {
            return false;
        }
        for (Map.Entry entry : insertHandlers.entrySet()) {
            InserterCardCache inserterCardCache = (InserterCardCache)entry.getKey();
            LaserNodeEnergyHandler laserNodeEnergyHandler = this.getLaserNodeHandlerEnergy(inserterCardCache);
            IEnergyStorage energyStorage = laserNodeEnergyHandler.handler;
            int actualRemoved = fromEnergyTank.extractEnergy(((Integer)entry.getValue()).intValue(), false);
            energyStorage.receiveEnergy(actualRemoved, false);
        }
        return true;
    }

    public boolean sendEnergy(ExtractorCardCache extractorCardCache) {
        BlockPos adjacentPos = this.getBlockPos().relative(extractorCardCache.direction);
        assert (this.level != null);
        if (!this.level.isLoaded(adjacentPos)) {
            return false;
        }
        IEnergyStorage adjacentEnergy = this.getAttachedEnergyTank(extractorCardCache.direction, extractorCardCache.sneaky);
        if (adjacentEnergy == null) {
            return false;
        }
        int desired = (int)((float)adjacentEnergy.getMaxEnergyStored() * ((float)extractorCardCache.extractLimit / 100.0f));
        int extractAmt = Math.min(extractorCardCache.extractAmt, adjacentEnergy.getEnergyStored() - desired);
        if (extractAmt <= 0) {
            return false;
        }
        if (extractorCardCache.exact) {
            return this.extractEnergyExact(extractorCardCache, adjacentEnergy, extractAmt);
        }
        return this.extractEnergy(extractorCardCache, adjacentEnergy, extractAmt);
    }

    public boolean canAnyItemFiltersFit(IItemHandler adjacentInventory, StockerCardCache stockerCardCache) {
        for (ItemStack stack : stockerCardCache.getFilteredItems()) {
            int amountFit = this.testInsertToInventory(adjacentInventory, stack.split(1));
            if (amountFit <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean canAnyFluidFiltersFit(IFluidHandler adjacentTank, StockerCardCache stockerCardCache) {
        for (FluidStack fluidStack : stockerCardCache.getFilteredFluids()) {
            int amtFit = adjacentTank.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
            if (amtFit <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean canFluidFitInTank(IFluidHandler handler, FluidStack fluidStack) {
        return handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    public boolean regulateItemStocker(StockerCardCache stockerCardCache, IItemHandler stockerInventory) {
        ItemHandlerUtil.InventoryCounts stockerInventoryCount = new ItemHandlerUtil.InventoryCounts(stockerInventory, stockerCardCache.isCompareNBT);
        List<ItemStack> filteredItemsList = stockerCardCache.getFilteredItems();
        for (ItemStack itemStack : filteredItemsList) {
            int amtHad = stockerInventoryCount.getCount(itemStack);
            if (amtHad <= itemStack.getCount()) continue;
            ItemStack extractStack = itemStack.copy();
            extractStack.setCount(Math.min(amtHad - itemStack.getCount(), stockerCardCache.extractAmt));
            if (!this.extractItem(stockerCardCache, stockerInventory, extractStack)) continue;
            return true;
        }
        return false;
    }

    public boolean regulateFluidStocker(StockerCardCache stockerCardCache, IFluidHandler stockerTank) {
        List<FluidStack> filteredFluidsList = stockerCardCache.getFilteredFluids();
        for (FluidStack fluidStack : filteredFluidsList) {
            int desiredAmt = stockerCardCache.getFilterAmt(fluidStack);
            int amtHad = 0;
            for (int tank = 0; tank < stockerTank.getTanks(); ++tank) {
                FluidStack stackInTank = stockerTank.getFluidInTank(tank);
                if (!FluidStack.isSameFluidSameComponents((FluidStack)stackInTank, (FluidStack)fluidStack)) continue;
                amtHad += stackInTank.getAmount();
            }
            if (amtHad <= desiredAmt) continue;
            fluidStack.setAmount(Math.min(amtHad - desiredAmt, stockerCardCache.extractAmt));
            if (!this.extractFluidStack(stockerCardCache, stockerTank, fluidStack)) continue;
            return true;
        }
        return false;
    }

    public boolean regulateEnergyStocker(StockerCardCache stockerCardCache, IEnergyStorage stockerTank) {
        int desired = (int)((float)stockerTank.getMaxEnergyStored() * ((float)stockerCardCache.insertLimit / 100.0f));
        if (desired >= stockerTank.getEnergyStored()) {
            return false;
        }
        int overFlow = Math.min(stockerCardCache.extractAmt, stockerTank.getEnergyStored() - desired);
        return this.extractEnergy(stockerCardCache, stockerTank, overFlow);
    }

    public boolean stockEnergy(StockerCardCache stockerCardCache) {
        BlockPos adjacentPos = this.getBlockPos().relative(stockerCardCache.direction);
        assert (this.level != null);
        if (!this.level.isLoaded(adjacentPos)) {
            return false;
        }
        IEnergyStorage adjacentEnergy = this.getAttachedEnergyTank(stockerCardCache.direction, stockerCardCache.sneaky);
        if (adjacentEnergy == null) {
            return false;
        }
        if (stockerCardCache.regulate && this.regulateEnergyStocker(stockerCardCache, adjacentEnergy)) {
            return true;
        }
        int desired = (int)((float)adjacentEnergy.getMaxEnergyStored() * ((float)stockerCardCache.insertLimit / 100.0f));
        if (adjacentEnergy.getEnergyStored() >= desired) {
            return false;
        }
        return this.findEnergyForStocker(stockerCardCache, adjacentEnergy);
    }

    public boolean stockFluids(StockerCardCache stockerCardCache) {
        BlockPos adjacentPos = this.getBlockPos().relative(stockerCardCache.direction);
        assert (this.level != null);
        if (!this.level.isLoaded(adjacentPos)) {
            return false;
        }
        IFluidHandler adjacentTank = this.getAttachedFluidTank(stockerCardCache.direction, stockerCardCache.sneaky);
        if (adjacentTank == null) {
            return false;
        }
        ItemStack filter = stockerCardCache.filterCard;
        if (filter.isEmpty() || !stockerCardCache.isAllowList) {
            return false;
        }
        if (filter.getItem() instanceof FilterBasic || filter.getItem() instanceof FilterCount) {
            if (stockerCardCache.regulate && filter.getItem() instanceof FilterCount && this.regulateFluidStocker(stockerCardCache, adjacentTank)) {
                return true;
            }
            if (!this.canAnyFluidFiltersFit(adjacentTank, stockerCardCache)) {
                return false;
            }
            boolean foundItems = this.findFluidStackForStocker(stockerCardCache, adjacentTank);
            if (foundItems) {
                return true;
            }
        } else if (filter.getItem() instanceof FilterTag) {
            // empty if block
        }
        return false;
    }

    public boolean stockItems(StockerCardCache stockerCardCache) {
        ItemStack filter;
        BlockPos adjacentPos = this.getBlockPos().relative(stockerCardCache.direction);
        assert (this.level != null);
        if (!this.level.isLoaded(adjacentPos)) {
            return false;
        }
        IItemHandler adjacentInventory = this.getAttachedInventory(stockerCardCache.direction, stockerCardCache.sneaky);
        if (adjacentInventory == null) {
            adjacentInventory = this.EMPTY;
        }
        if ((filter = stockerCardCache.filterCard).isEmpty() || !stockerCardCache.isAllowList) {
            return false;
        }
        if (filter.getItem() instanceof FilterBasic || filter.getItem() instanceof FilterCount) {
            if (stockerCardCache.regulate && filter.getItem() instanceof FilterCount && this.regulateItemStocker(stockerCardCache, adjacentInventory)) {
                return true;
            }
            if (!this.canAnyItemFiltersFit(adjacentInventory, stockerCardCache)) {
                return false;
            }
            boolean foundItems = this.findItemStackForStocker(stockerCardCache, adjacentInventory);
            if (foundItems) {
                return true;
            }
        } else if (filter.getItem() instanceof FilterTag) {
            // empty if block
        }
        return false;
    }

    public ItemStack getStackAtStockerCachePosition(StockerSource checkSource) {
        LaserNodeItemHandler laserNodeItemHandler = this.getLaserNodeHandlerItem(checkSource.inserterCardCache);
        if (laserNodeItemHandler == null) {
            return ItemStack.EMPTY;
        }
        return laserNodeItemHandler.handler.getStackInSlot(checkSource.slot);
    }

    public TransferResult tryStockerCacheCount(StockerCardCache stockerCardCache, ItemStack itemStack, IItemHandler stockerInventory) {
        int lastSlot;
        int origItemsWanted;
        TransferResult extractResult = new TransferResult();
        ItemStackKey itemStackKey = new ItemStackKey(itemStack, stockerCardCache.isCompareNBT);
        StockerRequest stockerRequest = new StockerRequest(stockerCardCache, itemStackKey);
        if (!this.stockerDestinationCache.containsKey(stockerRequest)) {
            return extractResult;
        }
        int itemsStillNeeded = origItemsWanted = itemStack.getCount();
        StockerSource checkSource = this.stockerDestinationCache.get(stockerRequest);
        ItemStack stackInSlot = this.getStackAtStockerCachePosition(checkSource);
        if (stackInSlot == null) {
            return extractResult;
        }
        LaserNodeItemHandler laserNodeItemHandler = this.getLaserNodeHandlerItem(checkSource.inserterCardCache);
        if (laserNodeItemHandler == null) {
            return extractResult;
        }
        ItemStackKey stackInSlotKey = new ItemStackKey(stackInSlot, stockerCardCache.isCompareNBT);
        if (stackInSlot.isEmpty()) {
            this.stockerDestinationCache.remove(stockerRequest);
        }
        if (stackInSlotKey.equals(itemStackKey)) {
            int extractAmt = Math.min(itemsStillNeeded, stackInSlot.getCount());
            ItemStack extractedItemStack = laserNodeItemHandler.handler.extractItem(checkSource.slot, extractAmt, true);
            itemsStillNeeded -= extractedItemStack.getCount();
            if (stackInSlot.getCount() - extractedItemStack.getCount() == 0) {
                this.stockerDestinationCache.remove(stockerRequest);
            }
            if (itemsStillNeeded == 0) {
                extractResult.addResult(new TransferResult.Result(laserNodeItemHandler.handler, checkSource.slot, checkSource.inserterCardCache, extractedItemStack, laserNodeItemHandler.be, true));
                extractResult.addOtherCard(stockerInventory, -1, stockerCardCache, stockerCardCache.be);
                return extractResult;
            }
        }
        extractResult = ItemHandlerUtil.extractItemWithSlots(laserNodeItemHandler.be, laserNodeItemHandler.handler, itemStack, origItemsWanted, true, stockerCardCache.isCompareNBT, checkSource.inserterCardCache);
        extractResult.addOtherCard(stockerInventory, -1, stockerCardCache, stockerCardCache.be);
        if (!extractResult.results.isEmpty() && laserNodeItemHandler.handler.getStackInSlot(lastSlot = extractResult.results.get((int)(extractResult.results.size() - 1)).extractSlot).getCount() - extractResult.results.get((int)(extractResult.results.size() - 1)).itemStack.getCount() != 0) {
            this.stockerDestinationCache.put(new StockerRequest(stockerCardCache, itemStackKey), new StockerSource(checkSource.inserterCardCache, lastSlot));
        }
        return extractResult;
    }

    public boolean findEnergyForStocker(StockerCardCache stockerCardCache, IEnergyStorage toEnergyTank) {
        int desired = (int)((float)toEnergyTank.getMaxEnergyStored() * ((float)stockerCardCache.insertLimit / 100.0f));
        int extractAmt = Math.min(stockerCardCache.extractAmt, desired - toEnergyTank.getEnergyStored());
        List<InserterCardCache> inserterCardCaches = this.getChannelMatchInserters(stockerCardCache);
        Object2IntOpenHashMap insertHandlers = new Object2IntOpenHashMap();
        for (InserterCardCache inserterCardCache : inserterCardCaches) {
            IEnergyStorage energyStorage;
            int amtRemoved;
            LaserNodeEnergyHandler laserNodeEnergyHandler = this.getLaserNodeHandlerEnergy(inserterCardCache);
            if (laserNodeEnergyHandler == null || (amtRemoved = (energyStorage = laserNodeEnergyHandler.handler).extractEnergy(extractAmt, true)) == 0) continue;
            int amtInserted = toEnergyTank.receiveEnergy(amtRemoved, true);
            if (amtInserted == 0) {
                return false;
            }
            insertHandlers.put(inserterCardCache, amtInserted);
            if ((extractAmt -= amtInserted) != 0) continue;
            break;
        }
        if (stockerCardCache.exact && extractAmt > 0 || insertHandlers.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : insertHandlers.entrySet()) {
            InserterCardCache inserterCardCache = (InserterCardCache)entry.getKey();
            LaserNodeEnergyHandler laserNodeEnergyHandler = this.getLaserNodeHandlerEnergy(inserterCardCache);
            IEnergyStorage energyStorage = laserNodeEnergyHandler.handler;
            int actualRemoved = energyStorage.extractEnergy(((Integer)entry.getValue()).intValue(), false);
            toEnergyTank.receiveEnergy(actualRemoved, false);
        }
        return false;
    }

    public boolean findFluidStackForStocker(StockerCardCache stockerCardCache, IFluidHandler stockerTank) {
        boolean isCount = stockerCardCache.filterCard.getItem() instanceof FilterCount;
        int extractAmt = stockerCardCache.extractAmt;
        CopyOnWriteArrayList<FluidStack> filteredFluidsList = new CopyOnWriteArrayList<FluidStack>(stockerCardCache.getFilteredFluids());
        filteredFluidsList.removeIf(fluidStack -> !this.canFluidFitInTank(stockerTank, (FluidStack)fluidStack));
        if (filteredFluidsList.isEmpty()) {
            return false;
        }
        if (isCount) {
            for (FluidStack fluidStack2 : filteredFluidsList) {
                for (int tank = 0; tank < stockerTank.getTanks(); ++tank) {
                    int n;
                    FluidStack tankStack = stockerTank.getFluidInTank(tank);
                    if (!tankStack.isEmpty() && !FluidStack.isSameFluidSameComponents((FluidStack)tankStack, (FluidStack)fluidStack2)) continue;
                    int filterAmt = stockerCardCache.getFilterAmt(fluidStack2);
                    int amtNeeded = filterAmt - (n = tankStack.getAmount());
                    if (amtNeeded <= 0) {
                        filteredFluidsList.remove(fluidStack2);
                        continue;
                    }
                    fluidStack2.setAmount(Math.min(amtNeeded, extractAmt));
                }
            }
        }
        if (filteredFluidsList.isEmpty()) {
            return false;
        }
        for (FluidStack fluidStack2 : filteredFluidsList) {
            HashMap<InserterCardCache, FluidStack> insertHandlers = new HashMap<InserterCardCache, FluidStack>();
            if (!isCount) {
                fluidStack2.setAmount(extractAmt);
            }
            int amtNeeded = fluidStack2.getAmount();
            for (InserterCardCache inserterCardCache : this.getChannelMatchInserters(stockerCardCache)) {
                LaserNodeFluidHandler laserNodeFluidHandler;
                if (!inserterCardCache.isStackValidForCard(fluidStack2) || (laserNodeFluidHandler = this.getLaserNodeHandlerFluid(inserterCardCache)) == null) continue;
                fluidStack2.setAmount(amtNeeded);
                IFluidHandler handler = laserNodeFluidHandler.handler();
                FluidStack extractStack = handler.drain(fluidStack2, IFluidHandler.FluidAction.SIMULATE);
                if (extractStack.isEmpty()) continue;
                insertHandlers.put(inserterCardCache, extractStack);
                if ((amtNeeded -= extractStack.getAmount()) != 0) continue;
                break;
            }
            if (insertHandlers.isEmpty() || stockerCardCache.exact && amtNeeded != 0) continue;
            for (Map.Entry entry : insertHandlers.entrySet()) {
                InserterCardCache inserterCardCache = (InserterCardCache)entry.getKey();
                FluidStack insertStack = (FluidStack)entry.getValue();
                LaserNodeFluidHandler laserNodeFluidHandler = this.getLaserNodeHandlerFluid(inserterCardCache);
                IFluidHandler handler = laserNodeFluidHandler.handler;
                int amtFit = stockerTank.fill(insertStack, IFluidHandler.FluidAction.SIMULATE);
                insertStack.setAmount(amtFit);
                FluidStack drainedStack = handler.drain(insertStack, IFluidHandler.FluidAction.EXECUTE);
                stockerTank.fill(drainedStack, IFluidHandler.FluidAction.EXECUTE);
                this.drawParticlesFluid(drainedStack, inserterCardCache.direction, inserterCardCache.be, stockerCardCache.be, stockerCardCache.direction, inserterCardCache.cardSlot, stockerCardCache.cardSlot);
            }
            return true;
        }
        return false;
    }

    public boolean findItemStackForStocker(StockerCardCache stockerCardCache, IItemHandler stockerInventory) {
        boolean isCount = stockerCardCache.filterCard.getItem() instanceof FilterCount;
        int extractAmt = stockerCardCache.extractAmt;
        List<ItemStack> filteredItemsList = stockerCardCache.getFilteredItems();
        if (isCount) {
            ItemHandlerUtil.InventoryCounts stockerInventoryCount = new ItemHandlerUtil.InventoryCounts(stockerInventory, stockerCardCache.isCompareNBT);
            ArrayList<ItemStack> tempList = new ArrayList<ItemStack>(filteredItemsList);
            for (ItemStack itemStack : filteredItemsList) {
                int amtHad = stockerInventoryCount.getCount(itemStack);
                if (amtHad >= itemStack.getCount()) {
                    tempList.remove(itemStack);
                    continue;
                }
                itemStack.setCount(Math.min(itemStack.getCount() - amtHad, extractAmt));
            }
            filteredItemsList = tempList;
        }
        if (filteredItemsList.isEmpty()) {
            return false;
        }
        HashMap<InserterCardCache, ItemHandlerUtil.InventoryCounts> stockerInvCaches = new HashMap<InserterCardCache, ItemHandlerUtil.InventoryCounts>();
        for (ItemStack itemStack : filteredItemsList) {
            Object insertedStack;
            if (!isCount) {
                itemStack.setCount(extractAmt);
            }
            int origCountNeeded = itemStack.getCount();
            TransferResult transferResult = this.tryStockerCacheCount(stockerCardCache, itemStack, stockerInventory);
            if (transferResult.getTotalItemCounts() == origCountNeeded) {
                itemStack.setCount(transferResult.getTotalItemCounts());
                insertedStack = ItemHandlerHelper.insertItem((IItemHandler)stockerInventory, (ItemStack)itemStack, (boolean)true);
                int totalInserted = transferResult.getTotalItemCounts() - insertedStack.getCount();
                if (totalInserted < transferResult.getTotalItemCounts()) {
                    if (totalInserted == 0 || stockerCardCache.exact) break;
                    for (TransferResult.Result result : transferResult.results) {
                        if (result.itemStack.getCount() > totalInserted) {
                            if (totalInserted <= 0) {
                                transferResult.results.remove(result);
                            } else {
                                result.itemStack.setCount(totalInserted);
                            }
                        }
                        totalInserted -= result.itemStack.getCount();
                    }
                }
                transferResult.doIt();
                return true;
            }
            itemStack.setCount(origCountNeeded - transferResult.getTotalItemCounts());
            for (InserterCardCache inserterCardCache : this.getChannelMatchInserters(stockerCardCache)) {
                ItemHandlerUtil.InventoryCounts inventoryCounts;
                LaserNodeItemHandler laserNodeItemHandler;
                if (!inserterCardCache.isStackValidForCard(itemStack) || transferResult.getTotalItemCounts() != 0 && inserterCardCache.equals(transferResult.results.get((int)0).extractorCardCache) || (laserNodeItemHandler = this.getLaserNodeHandlerItem(inserterCardCache)) == null) continue;
                if (stockerInvCaches.containsKey(inserterCardCache)) {
                    inventoryCounts = (ItemHandlerUtil.InventoryCounts)stockerInvCaches.get(inserterCardCache);
                } else {
                    inventoryCounts = new ItemHandlerUtil.InventoryCounts(laserNodeItemHandler.handler, stockerCardCache.isCompareNBT);
                    stockerInvCaches.put(inserterCardCache, inventoryCounts);
                }
                if (inventoryCounts.getCount(itemStack) == 0) continue;
                transferResult.addResult(ItemHandlerUtil.extractItemWithSlots(laserNodeItemHandler.be, laserNodeItemHandler.handler, itemStack, itemStack.getCount(), true, stockerCardCache.isCompareNBT, inserterCardCache));
                transferResult.addOtherCard(stockerInventory, -1, stockerCardCache, stockerCardCache.be);
                if (transferResult.getTotalItemCounts() == origCountNeeded) {
                    itemStack.setCount(transferResult.getTotalItemCounts());
                    ItemStack insertedStack2 = ItemHandlerHelper.insertItem((IItemHandler)stockerInventory, (ItemStack)itemStack, (boolean)true);
                    int totalInserted = transferResult.getTotalItemCounts() - insertedStack2.getCount();
                    if (totalInserted < transferResult.getTotalItemCounts()) {
                        if (totalInserted == 0 || stockerCardCache.exact) break;
                        for (TransferResult.Result result : transferResult.results) {
                            if (result.itemStack.getCount() > totalInserted) {
                                if (totalInserted <= 0) {
                                    transferResult.results.remove(result);
                                } else {
                                    result.itemStack.setCount(totalInserted);
                                }
                            }
                            totalInserted -= result.itemStack.getCount();
                        }
                    }
                    transferResult.doIt();
                    int lastSlot = transferResult.results.get((int)(transferResult.results.size() - 1)).extractSlot;
                    if (lastSlot < laserNodeItemHandler.handler.getSlots() && !laserNodeItemHandler.handler.getStackInSlot(lastSlot).isEmpty()) {
                        this.stockerDestinationCache.put(new StockerRequest(stockerCardCache, new ItemStackKey(itemStack, stockerCardCache.isCompareNBT)), new StockerSource(inserterCardCache, lastSlot));
                    }
                    return true;
                }
                itemStack.setCount(origCountNeeded - transferResult.getTotalItemCounts());
            }
            if (stockerCardCache.exact || transferResult.getTotalItemCounts() <= 0) continue;
            itemStack.setCount(transferResult.getTotalItemCounts());
            insertedStack = ItemHandlerHelper.insertItem((IItemHandler)stockerInventory, (ItemStack)itemStack, (boolean)true);
            int totalInserted = transferResult.getTotalItemCounts() - insertedStack.getCount();
            if (totalInserted < transferResult.getTotalItemCounts()) {
                if (totalInserted == 0) break;
                for (TransferResult.Result result : transferResult.results) {
                    if (result.itemStack.getCount() > totalInserted) {
                        if (totalInserted <= 0) {
                            transferResult.results.remove(result);
                        } else {
                            result.itemStack.setCount(totalInserted);
                        }
                    }
                    totalInserted -= result.itemStack.getCount();
                }
            }
            transferResult.doIt();
            return true;
        }
        return false;
    }

    public int testInsertToInventory(IItemHandler destitemHandler, ItemStack stack) {
        ItemStack tempStack = ItemHandlerHelper.insertItem((IItemHandler)destitemHandler, (ItemStack)stack, (boolean)true);
        int remainder = tempStack.getCount();
        return stack.getCount() - remainder;
    }

    public void drawParticlesClient() {
        double d5;
        double d3;
        double d1;
        int i;
        Object data;
        Vector3f insertOffset;
        Vector3f extractOffset;
        VoxelShape voxelShape;
        int count;
        int maxPart;
        int minPart;
        int max;
        int min;
        float randomSpread;
        BlockState targetState;
        Direction direction;
        BlockPos fromPos;
        BlockPos toPos;
        if (this.particleRenderData.isEmpty() && this.particleRenderDataFluids.isEmpty() && this.particleRenderDataChemical.isEmpty()) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)this.level;
        for (ParticleRenderData particleRenderData : this.particleRenderData) {
            ItemStack itemStack = new ItemStack((ItemLike)Item.byId((int)particleRenderData.item), (int)particleRenderData.itemCount);
            toPos = particleRenderData.toPos;
            fromPos = particleRenderData.fromPos;
            direction = Direction.values()[particleRenderData.direction];
            targetState = this.level.getBlockState(toPos);
            randomSpread = 0.01f;
            min = 1;
            max = 64;
            minPart = 32;
            maxPart = 64;
            count = (maxPart - minPart) * (itemStack.getCount() - min) / (max - min) + minPart;
            if (targetState.getBlock() instanceof LaserNode) {
                targetState = this.level.getBlockState(fromPos);
                voxelShape = targetState.getShape((BlockGetter)this.level, fromPos);
                extractOffset = MiscTools.findOffset(direction, particleRenderData.position, offsets);
                insertOffset = CardRender.shapeOffset(extractOffset, voxelShape, fromPos, toPos, direction, this.level, targetState);
                data = new ItemFlowParticleData(itemStack, (float)toPos.getX() + extractOffset.x(), (float)toPos.getY() + extractOffset.y(), (float)toPos.getZ() + extractOffset.z(), 10);
                for (i = 0; i < count; ++i) {
                    d1 = this.random.nextGaussian() * (double)randomSpread;
                    d3 = this.random.nextGaussian() * (double)randomSpread;
                    d5 = this.random.nextGaussian() * (double)randomSpread;
                    clientLevel.addParticle((ParticleOptions)data, (double)((float)toPos.getX() + insertOffset.x()) + d1, (double)((float)toPos.getY() + insertOffset.y()) + d3, (double)((float)toPos.getZ() + insertOffset.z()) + d5, 0.0, 0.0, 0.0);
                }
                continue;
            }
            voxelShape = targetState.getShape((BlockGetter)this.level, toPos);
            extractOffset = MiscTools.findOffset(direction, particleRenderData.position, offsets);
            insertOffset = CardRender.shapeOffset(extractOffset, voxelShape, fromPos, toPos, direction, this.level, targetState);
            data = new ItemFlowParticleData(itemStack, (float)fromPos.getX() + insertOffset.x(), (float)fromPos.getY() + insertOffset.y(), (float)fromPos.getZ() + insertOffset.z(), 10);
            for (i = 0; i < count; ++i) {
                d1 = this.random.nextGaussian() * (double)randomSpread;
                d3 = this.random.nextGaussian() * (double)randomSpread;
                d5 = this.random.nextGaussian() * (double)randomSpread;
                clientLevel.addParticle((ParticleOptions)data, (double)((float)fromPos.getX() + extractOffset.x()) + d1, (double)((float)fromPos.getY() + extractOffset.y()) + d3, (double)((float)fromPos.getZ() + extractOffset.z()) + d5, 0.0, 0.0, 0.0);
            }
        }
        for (ParticleRenderDataFluid particleRenderDataFluid : this.particleRenderDataFluids) {
            FluidStack fluidStack = particleRenderDataFluid.fluidStack;
            if (fluidStack.isEmpty()) continue;
            toPos = particleRenderDataFluid.toPos;
            fromPos = particleRenderDataFluid.fromPos;
            direction = Direction.values()[particleRenderDataFluid.direction];
            targetState = this.level.getBlockState(toPos);
            randomSpread = 0.01f;
            min = 100;
            max = 8000;
            minPart = 8;
            maxPart = 64;
            count = (maxPart - minPart) * (fluidStack.getAmount() - min) / (max - min) + minPart;
            if (targetState.getBlock() instanceof LaserNode) {
                targetState = this.level.getBlockState(fromPos);
                voxelShape = targetState.getShape((BlockGetter)this.level, fromPos);
                extractOffset = MiscTools.findOffset(direction, particleRenderDataFluid.position, offsets);
                insertOffset = CardRender.shapeOffset(extractOffset, voxelShape, fromPos, toPos, direction, this.level, targetState);
                data = new FluidFlowParticleData(fluidStack, (float)toPos.getX() + extractOffset.x(), (float)toPos.getY() + extractOffset.y(), (float)toPos.getZ() + extractOffset.z(), 10);
                for (i = 0; i < count; ++i) {
                    d1 = this.random.nextGaussian() * (double)randomSpread;
                    d3 = this.random.nextGaussian() * (double)randomSpread;
                    d5 = this.random.nextGaussian() * (double)randomSpread;
                    clientLevel.addParticle((ParticleOptions)data, (double)((float)toPos.getX() + insertOffset.x()) + d1, (double)((float)toPos.getY() + insertOffset.y()) + d3, (double)((float)toPos.getZ() + insertOffset.z()) + d5, 0.0, 0.0, 0.0);
                }
                continue;
            }
            voxelShape = targetState.getShape((BlockGetter)this.level, toPos);
            extractOffset = MiscTools.findOffset(direction, particleRenderDataFluid.position, offsets);
            insertOffset = CardRender.shapeOffset(extractOffset, voxelShape, fromPos, toPos, direction, this.level, targetState);
            data = new FluidFlowParticleData(fluidStack, (float)fromPos.getX() + insertOffset.x(), (float)fromPos.getY() + insertOffset.y(), (float)fromPos.getZ() + insertOffset.z(), 10);
            for (i = 0; i < count; ++i) {
                d1 = this.random.nextGaussian() * (double)randomSpread;
                d3 = this.random.nextGaussian() * (double)randomSpread;
                d5 = this.random.nextGaussian() * (double)randomSpread;
                clientLevel.addParticle((ParticleOptions)data, (double)((float)fromPos.getX() + extractOffset.x()) + d1, (double)((float)fromPos.getY() + extractOffset.y()) + d3, (double)((float)fromPos.getZ() + extractOffset.z()) + d5, 0.0, 0.0, 0.0);
            }
        }
        for (ParticleRenderDataChemical particleRenderDataChemical : this.particleRenderDataChemical) {
            this.mekanismCache.drawParticlesClient(particleRenderDataChemical);
        }
    }

    public void addParticleData(ParticleRenderData particleRenderData) {
        this.particleRenderData.add(particleRenderData);
    }

    public void addParticleDataFluid(ParticleRenderDataFluid particleRenderData) {
        this.particleRenderDataFluids.add(particleRenderData);
    }

    public void addParticleDataChemical(ParticleRenderDataChemical particleRenderData) {
        this.particleRenderDataChemical.add(particleRenderData);
    }

    public void drawParticles(ItemStack itemStack, Direction fromDirection, LaserNodeBE sourceBE, LaserNodeBE destinationBE, Direction destinationDirection, int extractPosition, int insertPosition) {
        this.drawParticles(itemStack, itemStack.getCount(), fromDirection, sourceBE, destinationBE, destinationDirection, extractPosition, insertPosition);
    }

    public void drawParticlesFluid(FluidStack fluidStack, Direction fromDirection, LaserNodeBE sourceBE, LaserNodeBE destinationBE, Direction destinationDirection, int extractPosition, int insertPosition) {
        if (!sourceBE.getShowParticles() || !destinationBE.getShowParticles()) {
            return;
        }
        ServerTickHandler.addToListFluid(new ParticleDataFluid(fluidStack, new GlobalPos(sourceBE.level.dimension(), sourceBE.getBlockPos()), (byte)fromDirection.ordinal(), new GlobalPos(destinationBE.level.dimension(), destinationBE.getBlockPos()), (byte)destinationDirection.ordinal(), (byte)extractPosition, (byte)insertPosition));
    }

    public void drawParticles(ItemStack itemStack, int amount, Direction fromDirection, LaserNodeBE sourceBE, LaserNodeBE destinationBE, Direction destinationDirection, int extractPosition, int insertPosition) {
        if (!sourceBE.getShowParticles() || !destinationBE.getShowParticles()) {
            return;
        }
        ServerTickHandler.addToList(new ParticleData(Item.getId((Item)itemStack.getItem()), (byte)amount, new GlobalPos(sourceBE.level.dimension(), sourceBE.getBlockPos()), (byte)fromDirection.ordinal(), new GlobalPos(destinationBE.level.dimension(), destinationBE.getBlockPos()), (byte)destinationDirection.ordinal(), (byte)extractPosition, (byte)insertPosition));
    }

    public void updateThisNode() {
        this.setChanged();
        for (Direction direction : Direction.values()) {
            NodeSideCache nodeSideCache = this.nodeSideCaches[direction.ordinal()];
            nodeSideCache.myRedstoneFromSensors.clear();
        }
        this.redstoneChecked = false;
        this.notifyOtherNodesOfChange();
        this.markDirtyClient();
        this.findMyExtractors();
        this.updateOverclockers();
        Arrays.stream(this.nodeSideCaches).forEach(NodeSideCache::invalidateEnergy);
    }

    public void notifyOtherNodesOfChange() {
        if (this.level == null) {
            return;
        }
        for (GlobalPos pos : this.otherNodesInNetwork) {
            LaserNodeBE node;
            Level targetLevel = MiscTools.getLevel(this.level.getServer(), pos);
            if (targetLevel == null || (node = this.getNodeAt(new GlobalPos(targetLevel.dimension(), this.getWorldPos(pos.pos())))) == null) continue;
            node.checkInvNode(new GlobalPos(this.level.dimension(), this.getBlockPos()), true);
            node.redstoneRefreshed = false;
        }
    }

    public void refreshAllInvNodes() {
        this.inserterNodes.clear();
        this.inserterCache.clear();
        this.inserterCacheFluid.clear();
        if (this.mekanismCache != null) {
            this.mekanismCache.inserterCacheChemical.clear();
        }
        this.channelOnlyCache.clear();
        this.stockerDestinationCache.clear();
        this.redstoneNetwork.clear();
        if (this.level == null) {
            return;
        }
        for (GlobalPos pos : this.otherNodesInNetwork) {
            Level targetLevel = MiscTools.getLevel(this.level.getServer(), pos);
            if (targetLevel == null) continue;
            this.checkInvNode(new GlobalPos(targetLevel.dimension(), this.getWorldPos(pos.pos())), false);
        }
        this.redstoneRefreshed = false;
        this.sortInserters();
    }

    public void checkInvNode(GlobalPos pos, boolean sortInserters) {
        LaserNodeBE be = this.getNodeAt(pos);
        GlobalPos relativePos = new GlobalPos(be.level.dimension(), this.getRelativePos(pos.pos()));
        this.inserterNodes.removeIf(p -> p.relativePos.equals((Object)relativePos));
        this.inserterCache.clear();
        this.inserterCacheFluid.clear();
        if (this.mekanismCache != null) {
            this.mekanismCache.inserterCacheChemical.clear();
        }
        this.channelOnlyCache.clear();
        this.stockerDestinationCache.clear();
        if (be == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            NodeSideCache nodeSideCache = be.nodeSideCaches[direction.ordinal()];
            for (int slot = 0; slot < 9; ++slot) {
                ItemStack card = nodeSideCache.itemHandler.getStackInSlot(slot);
                if (!(card.getItem() instanceof BaseCard) || card.getItem() instanceof CardRedstone || !BaseCard.getNamedTransferMode(card).equals((Object)BaseCard.TransferMode.INSERT)) continue;
                this.inserterNodes.add(new InserterCardCache(relativePos, direction, card, be, slot));
            }
        }
        if (sortInserters) {
            this.sortInserters();
        }
    }

    @Nullable
    public LaserNodeBE getLaserNodeBE(InserterCardCache inserterCardCache, BaseCard.CardType cardType) {
        if (inserterCardCache.cardType != cardType) {
            return null;
        }
        if (this.level == null) {
            return null;
        }
        Level targetLevel = MiscTools.getLevel(this.level.getServer(), inserterCardCache.relativePos);
        if (targetLevel == null) {
            return null;
        }
        GlobalPos nodeWorldPos = new GlobalPos(targetLevel.dimension(), this.getWorldPos(inserterCardCache.relativePos.pos()));
        if (!this.chunksLoaded(nodeWorldPos, nodeWorldPos.pos().relative(inserterCardCache.direction))) {
            return null;
        }
        return this.getNodeAt(new GlobalPos(targetLevel.dimension(), this.getWorldPos(inserterCardCache.relativePos.pos())));
    }

    public LaserNodeItemHandler getLaserNodeHandlerItem(InserterCardCache inserterCardCache) {
        LaserNodeBE be = this.getLaserNodeBE(inserterCardCache, BaseCard.CardType.ITEM);
        if (be == null) {
            return null;
        }
        IItemHandler handler = be.getAttachedInventory(inserterCardCache.direction, inserterCardCache.sneaky);
        if (handler == null || handler.getSlots() == 0) {
            return null;
        }
        return new LaserNodeItemHandler(be, handler);
    }

    public IItemHandler getAttachedInventory(Direction direction, Byte sneakySide) {
        Direction inventorySide = direction.getOpposite();
        if (sneakySide != -1) {
            inventorySide = Direction.values()[sneakySide];
        }
        SideConnection sideConnection = new SideConnection(direction, inventorySide);
        assert (this.level != null);
        BlockPos targetPos = this.getBlockPos().relative(direction);
        if (this.facingHandlerItem.get(sideConnection) == null) {
            this.facingHandlerItem.put(sideConnection, (BlockCapabilityCache<IItemHandler, Direction>)BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)targetPos, (Object)inventorySide));
        }
        IItemHandler testHandler = (IItemHandler)this.facingHandlerItem.get(sideConnection).getCapability();
        return testHandler;
    }

    public IItemHandler getAttachedInventoryNoCache(Direction direction, Byte sneakySide) {
        Direction inventorySide = direction.getOpposite();
        if (sneakySide != -1) {
            inventorySide = Direction.values()[sneakySide];
        }
        assert (this.level != null);
        BlockEntity be = this.level.getBlockEntity(this.getBlockPos().relative(direction));
        if (be != null) {
            IItemHandler handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.getBlockPos().relative(direction), (Object)inventorySide);
            return handler;
        }
        return null;
    }

    public LaserNodeFluidHandler getLaserNodeHandlerFluid(InserterCardCache inserterCardCache) {
        LaserNodeBE be = this.getLaserNodeBE(inserterCardCache, BaseCard.CardType.FLUID);
        if (be == null) {
            return null;
        }
        IFluidHandler fluidhandler = be.getAttachedFluidTank(inserterCardCache.direction, inserterCardCache.sneaky);
        if (fluidhandler == null || fluidhandler.getTanks() == 0) {
            return null;
        }
        return new LaserNodeFluidHandler(be, fluidhandler);
    }

    public IFluidHandler getAttachedFluidTank(Direction direction, Byte sneakySide) {
        Direction inventorySide = direction.getOpposite();
        if (sneakySide != -1) {
            inventorySide = Direction.values()[sneakySide];
        }
        SideConnection sideConnection = new SideConnection(direction, inventorySide);
        assert (this.level != null);
        BlockPos targetPos = this.getBlockPos().relative(direction);
        if (this.facingHandlerFluid.get(sideConnection) == null) {
            this.facingHandlerFluid.put(sideConnection, (BlockCapabilityCache<IFluidHandler, Direction>)BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)targetPos, (Object)inventorySide));
        }
        IFluidHandler testHandler = (IFluidHandler)this.facingHandlerFluid.get(sideConnection).getCapability();
        return testHandler;
    }

    public IFluidHandler getAttachedFluidTankNoCache(Direction direction, Byte sneakySide) {
        Direction inventorySide = direction.getOpposite();
        if (sneakySide != -1) {
            inventorySide = Direction.values()[sneakySide];
        }
        assert (this.level != null);
        BlockEntity be = this.level.getBlockEntity(this.getBlockPos().relative(direction));
        if (be != null) {
            IFluidHandler handler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.getBlockPos().relative(direction), (Object)inventorySide);
            return handler;
        }
        return null;
    }

    public LaserNodeEnergyHandler getLaserNodeHandlerEnergy(InserterCardCache inserterCardCache) {
        if (!inserterCardCache.cardType.equals((Object)BaseCard.CardType.ENERGY)) {
            return null;
        }
        if (this.level == null) {
            return null;
        }
        Level targetLevel = MiscTools.getLevel(this.level.getServer(), inserterCardCache.relativePos);
        if (targetLevel == null) {
            return null;
        }
        GlobalPos nodeWorldPos = new GlobalPos(targetLevel.dimension(), this.getWorldPos(inserterCardCache.relativePos.pos()));
        if (!this.chunksLoaded(nodeWorldPos, nodeWorldPos.pos().relative(inserterCardCache.direction))) {
            return null;
        }
        LaserNodeBE be = this.getNodeAt(new GlobalPos(targetLevel.dimension(), this.getWorldPos(inserterCardCache.relativePos.pos())));
        if (be == null) {
            return null;
        }
        IEnergyStorage energyhandler = be.getAttachedEnergyTank(inserterCardCache.direction, inserterCardCache.sneaky);
        if (energyhandler == null) {
            return null;
        }
        return new LaserNodeEnergyHandler(be, energyhandler);
    }

    public IEnergyStorage getAttachedEnergyTank(Direction direction, Byte sneakySide) {
        Direction inventorySide = direction.getOpposite();
        if (sneakySide != -1) {
            inventorySide = Direction.values()[sneakySide];
        }
        SideConnection sideConnection = new SideConnection(direction, inventorySide);
        assert (this.level != null);
        BlockPos targetPos = this.getBlockPos().relative(direction);
        if (this.facingHandlerEnergy.get(sideConnection) == null) {
            this.facingHandlerEnergy.put(sideConnection, (BlockCapabilityCache<IEnergyStorage, Direction>)BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)targetPos, (Object)inventorySide));
        }
        IEnergyStorage testHandler = (IEnergyStorage)this.facingHandlerEnergy.get(sideConnection).getCapability();
        return testHandler;
    }

    public IEnergyStorage getAttachedEnergyTankNoCache(Direction direction, Byte sneakySide) {
        Direction inventorySide = direction.getOpposite();
        if (sneakySide != -1) {
            inventorySide = Direction.values()[sneakySide];
        }
        assert (this.level != null);
        BlockEntity be = this.level.getBlockEntity(this.getBlockPos().relative(direction));
        if (be != null) {
            IEnergyStorage handler = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, this.getBlockPos().relative(direction), (Object)inventorySide);
            return handler;
        }
        return null;
    }

    public void clearCachedInventories(SideConnection sideConnection) {
        this.stockerDestinationCache.clear();
        this.facingHandlerItem.remove(sideConnection);
        this.facingHandlerFluid.remove(sideConnection);
        this.facingHandlerEnergy.remove(sideConnection);
        if (this.mekanismCache != null) {
            this.mekanismCache.facingHandlerChemical.clear();
        }
    }

    public void clearCachedInventories() {
        this.stockerDestinationCache.clear();
        this.facingHandlerItem.clear();
        this.facingHandlerFluid.clear();
        this.facingHandlerEnergy.clear();
        if (this.mekanismCache != null) {
            this.mekanismCache.facingHandlerChemical.clear();
        }
        this.markDirtyClient();
    }

    public void populateRenderList() {
        if (this.level == null || !this.level.isClientSide) {
            return;
        }
        this.cardRenders.clear();
        this.redstoneCardSides.clear();
        for (Direction direction : Direction.values()) {
            IItemHandler h = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.getBlockPos(), (Object)direction);
            if (h == null) {
                h = new ItemStackHandler(0);
            }
            for (int slot = 0; slot < h.getSlots(); ++slot) {
                IChemicalHandler chemicalHandler;
                byte strength;
                ItemStack card = h.getStackInSlot(slot);
                if (!(card.getItem() instanceof BaseCard)) continue;
                int redstoneMode = BaseCard.getRedstoneMode(card);
                if (card.getItem() instanceof CardRedstone) {
                    redstoneMode = 2;
                }
                byte redstoneChannel = BaseCard.getRedstoneChannel(card);
                boolean enabled = redstoneMode == 0 || BaseCard.getNamedTransferMode(card).equals((Object)BaseCard.TransferMode.SENSOR) ? true : ((strength = this.getRedstoneChannelStrength(redstoneChannel)) > 0 && redstoneMode == 1 ? false : strength != 0 || redstoneMode != 2);
                if (card.getItem() instanceof CardItem) {
                    if (this.getAttachedInventoryNoCache(direction, BaseCard.getSneaky(card)) == null) continue;
                    this.cardRenders.add(new CardRender(direction, slot, card, this.getBlockPos(), this.level, enabled));
                    continue;
                }
                if (card.getItem() instanceof CardFluid) {
                    if (this.getAttachedFluidTankNoCache(direction, BaseCard.getSneaky(card)) == null) continue;
                    this.cardRenders.add(new CardRender(direction, slot, card, this.getBlockPos(), this.level, enabled));
                    continue;
                }
                if (card.getItem() instanceof CardEnergy) {
                    IEnergyStorage lazyEnergyStorage = this.getAttachedEnergyTankNoCache(direction, BaseCard.getSneaky(card));
                    if (lazyEnergyStorage == null) continue;
                    this.cardRenders.add(new CardRender(direction, slot, card, this.getBlockPos(), this.level, enabled));
                    continue;
                }
                if (card.getItem() instanceof CardRedstone) {
                    this.redstoneCardSides.put((byte)direction.ordinal(), true);
                    this.cardRenders.add(new CardRender(direction, slot, card, this.getBlockPos(), this.level, enabled));
                    continue;
                }
                if (!(card.getItem() instanceof CardChemical) || (chemicalHandler = this.mekanismCache.getAttachedChemicalTanksNoCache(direction, BaseCard.getSneaky(card))) == null) continue;
                this.cardRenders.add(new CardRender(direction, slot, card, this.getBlockPos(), this.level, enabled));
            }
        }
        BlockState state = this.getBlockState();
        this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        state.updateNeighbourShapes((LevelAccessor)this.level, this.getBlockPos(), 3);
        this.rendersChecked = true;
    }

    public void setShowParticles(boolean show) {
        this.showParticles = show;
        this.markDirtyClient();
    }

    public boolean getShowParticles() {
        return this.showParticles;
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        ListTag redstoneNetworkTag = new ListTag();
        for (Map.Entry entry : this.redstoneNetwork.byte2ByteEntrySet()) {
            CompoundTag comp = new CompoundTag();
            comp.putByte("channel", ((Byte)entry.getKey()).byteValue());
            comp.putByte("strength", ((Byte)entry.getValue()).byteValue());
            redstoneNetworkTag.add((Object)comp);
        }
        tag.put("redstoneNetworkTag", (Tag)redstoneNetworkTag);
        return tag;
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        CompoundTag tag = pkt.getTag();
        this.loadAdditional(tag, lookupProvider);
        this.redstoneNetwork.clear();
        ListTag redstoneNetworkTag = tag.getList("redstoneNetworkTag", 10);
        for (int i = 0; i < redstoneNetworkTag.size(); ++i) {
            byte channel = redstoneNetworkTag.getCompound(i).getByte("channel");
            byte strength = redstoneNetworkTag.getCompound(i).getByte("strength");
            this.redstoneNetwork.put(channel, strength);
        }
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        for (int i = 0; i < Direction.values().length; ++i) {
            NodeSideCache nodeSideCache = this.nodeSideCaches[i];
            if (!tag.contains("Inventory" + i)) continue;
            nodeSideCache.itemHandler.deserializeNBT(provider, tag.getCompound("Inventory" + i));
            if (nodeSideCache.itemHandler.getSlots() >= LaserNodeContainer.SLOTS) continue;
            nodeSideCache.itemHandler.reSize(LaserNodeContainer.SLOTS);
        }
        if (tag.contains("showParticles")) {
            this.showParticles = tag.getBoolean("showParticles");
        }
        super.loadAdditional(tag, provider);
        this.rendersChecked = false;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        for (int i = 0; i < Direction.values().length; ++i) {
            NodeSideCache nodeSideCache = this.nodeSideCaches[i];
            tag.put("Inventory" + i, (Tag)nodeSideCache.itemHandler.serializeNBT(provider));
        }
        tag.putBoolean("showParticles", this.showParticles);
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
    }

    public class LaserEnergyStorage
    implements IEnergyStorage {
        private final Direction facing;

        public LaserEnergyStorage(Direction facing) {
            this.facing = facing;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return LaserNodeBE.this.receiveEnergy(this.facing, maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return 0;
        }

        public int getMaxEnergyStored() {
            return 0;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }

    private record LaserNodeItemHandler(LaserNodeBE be, IItemHandler handler) {
    }

    private record LaserNodeFluidHandler(LaserNodeBE be, IFluidHandler handler) {
    }

    private record LaserNodeEnergyHandler(LaserNodeBE be, IEnergyStorage handler) {
    }

    private record StockerSource(InserterCardCache inserterCardCache, int slot) {
    }

    private record StockerRequest(StockerCardCache stockerCardCache, ItemStackKey itemStackKey) {
    }

    public record SideConnection(Direction nodeSide, Direction sneakySide) {
    }
}

