/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.renderer;

import com.direwolf20.laserio.client.events.ClientEvents;
import com.direwolf20.laserio.client.renderer.MyRenderType;
import com.direwolf20.laserio.common.blockentities.LaserConnectorAdvBE;
import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.blockentities.basebe.BaseLaserBE;
import com.direwolf20.laserio.common.items.LaserWrench;
import com.direwolf20.laserio.setup.Registration;
import com.direwolf20.laserio.util.CardRender;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Queue;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderUtils {
    public static void render(Matrix4f matrix, VertexConsumer builder, BlockPos pos, Color color, float scale) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = 0.5f;
        float startX = 0.0f + (1.0f - scale) / 2.0f;
        float startY = 0.0f + (1.0f - scale) / 2.0f;
        float startZ = -1.0f + (1.0f - scale) / 2.0f;
        float endX = 1.0f - (1.0f - scale) / 2.0f;
        float endY = 1.0f - (1.0f - scale) / 2.0f;
        float endZ = 0.0f - (1.0f - scale) / 2.0f;
        builder.addVertex(matrix, startX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, endY, startZ).setColor(red, green, blue, alpha);
    }

    public static void drawLasersLast2(Queue<BaseLaserBE> beRenders, PoseStack matrixStackIn) {
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        VertexConsumer builder = buffer.getBuffer(MyRenderType.CONNECTING_LASER);
        while (beRenders.size() > 0) {
            LaserConnectorAdvBE laserConnectorAdvBE;
            int alpha;
            ItemStack myItem;
            LocalPlayer myplayer;
            Color color;
            BlockPos endBlock;
            BaseLaserBE be = beRenders.remove();
            Level level = be.getLevel();
            long gameTime = level.getGameTime();
            double v = (double)gameTime * 0.04;
            BlockPos startBlock = be.getBlockPos();
            matrixStackIn.pushPose();
            Matrix4f positionMatrix = matrixStackIn.last().pose();
            matrixStackIn.translate((double)startBlock.getX() - projectedView.x, (double)startBlock.getY() - projectedView.y, (double)startBlock.getZ() - projectedView.z);
            Vector3f startLaser = new Vector3f(0.5f, 0.5f, 0.5f);
            for (BlockPos target : be.getRenderedConnections()) {
                endBlock = be.getWorldPos(target);
                color = be.getColor();
                myplayer = Minecraft.getInstance().player;
                myItem = ClientEvents.getWrench((Player)myplayer);
                alpha = myItem.getItem() instanceof LaserWrench ? Math.min(color.getAlpha() + be.getWrenchAlpha(), 255) : color.getAlpha();
                float diffX = (float)endBlock.getX() + 0.5f - (float)startBlock.getX();
                float diffY = (float)endBlock.getY() + 0.5f - (float)startBlock.getY();
                float diffZ = (float)endBlock.getZ() + 0.5f - (float)startBlock.getZ();
                Vector3f endLaser = new Vector3f(diffX, diffY, diffZ);
                RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)alpha / 255.0f, 0.025f, v, v + (double)diffY * 1.5, be);
            }
            if (be instanceof LaserConnectorAdvBE && (laserConnectorAdvBE = (LaserConnectorAdvBE)be).getPartnerGlobalPos() != null && level.getBlockState(be.getBlockPos()).getBlock().equals(Registration.LaserConnectorAdv.get())) {
                Direction facing = ((Direction)level.getBlockState(be.getBlockPos()).getValue((Property)BlockStateProperties.FACING)).getOpposite();
                endBlock = laserConnectorAdvBE.getBlockPos().relative(facing);
                color = be.getColor();
                myplayer = Minecraft.getInstance().player;
                myItem = ClientEvents.getWrench((Player)myplayer);
                alpha = myItem.getItem() instanceof LaserWrench ? Math.min(color.getAlpha() + be.getWrenchAlpha(), 255) : color.getAlpha();
                Vector3f endLaser = RenderUtils.calculateEndAdvConnector(startBlock, endBlock, facing);
                RenderUtils.drawLaser(builder, positionMatrix, endLaser, startLaser, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)alpha / 255.0f, 0.025f, v, v + (double)endLaser.y() * 1.5, be);
            }
            matrixStackIn.popPose();
        }
        buffer.endBatch(MyRenderType.CONNECTING_LASER);
    }

    public static Vector3f calculateEndAdvConnector(BlockPos startBlock, BlockPos endBlock, Direction facing) {
        float diffX = endBlock.getX() - startBlock.getX();
        float diffY = endBlock.getY() - startBlock.getY();
        float diffZ = endBlock.getZ() - startBlock.getZ();
        switch (facing) {
            case UP: {
                diffX += 0.5f;
                diffY -= 0.25f;
                diffZ += 0.5f;
                break;
            }
            case DOWN: {
                diffX += 0.5f;
                diffY += 1.25f;
                diffZ += 0.5f;
                break;
            }
            case NORTH: {
                diffX += 0.5f;
                diffY += 0.5f;
                diffZ += 1.25f;
                break;
            }
            case SOUTH: {
                diffX += 0.5f;
                diffY += 0.5f;
                diffZ -= 0.25f;
                break;
            }
            case EAST: {
                diffX -= 0.25f;
                diffY += 0.5f;
                diffZ += 0.5f;
                break;
            }
            case WEST: {
                diffX += 1.25f;
                diffY += 0.5f;
                diffZ += 0.5f;
                break;
            }
        }
        return new Vector3f(diffX, diffY, diffZ);
    }

    public static void drawConnectingLasersLast4(Set<LaserNodeBE> beConnectingRenders, PoseStack matrixStackIn) {
        Matrix4f positionMatrix;
        BlockPos startBlock;
        double v;
        long gameTime;
        Level level;
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        float alpha = 1.0f;
        float thickness = 0.0175f;
        VertexConsumer builder = buffer.getBuffer(MyRenderType.LASER_MAIN_BEAM);
        for (LaserNodeBE be : beConnectingRenders) {
            level = be.getLevel();
            gameTime = level.getGameTime();
            v = (double)gameTime * 0.04;
            startBlock = be.getBlockPos();
            matrixStackIn.pushPose();
            positionMatrix = matrixStackIn.last().pose();
            matrixStackIn.translate((double)startBlock.getX() - projectedView.x, (double)startBlock.getY() - projectedView.y, (double)startBlock.getZ() - projectedView.z);
            for (CardRender cardRender : be.cardRenders) {
                RenderUtils.drawLaser(builder, positionMatrix, cardRender.endLaser, cardRender.startLaser, cardRender.r, cardRender.g, cardRender.b, alpha, thickness, v, v + (double)cardRender.diffY * 4.5, be);
            }
            matrixStackIn.popPose();
        }
        buffer.endBatch(MyRenderType.LASER_MAIN_BEAM);
        builder = buffer.getBuffer(MyRenderType.LASER_MAIN_CORE);
        for (LaserNodeBE be : beConnectingRenders) {
            level = be.getLevel();
            gameTime = level.getGameTime();
            v = (double)gameTime * 0.04;
            startBlock = be.getBlockPos();
            matrixStackIn.pushPose();
            positionMatrix = matrixStackIn.last().pose();
            matrixStackIn.translate((double)startBlock.getX() - projectedView.x, (double)startBlock.getY() - projectedView.y, (double)startBlock.getZ() - projectedView.z);
            for (CardRender cardRender : be.cardRenders) {
                RenderUtils.drawLaser(builder, positionMatrix, cardRender.endLaser, cardRender.startLaser, cardRender.floatcolors[0], cardRender.floatcolors[1], cardRender.floatcolors[2], 1.0f, 0.0125f, v, v + (double)cardRender.diffY * 1.5, be);
            }
            matrixStackIn.popPose();
        }
        buffer.endBatch(MyRenderType.LASER_MAIN_CORE);
    }

    public static Vector3f adjustBeamToEyes(Vector3f from, Vector3f to, BlockEntity be) {
        LocalPlayer player = Minecraft.getInstance().player;
        Vector3f P = new Vector3f((float)player.getX() - (float)be.getBlockPos().getX(), (float)player.getEyeY() - (float)be.getBlockPos().getY(), (float)player.getZ() - (float)be.getBlockPos().getZ());
        Vector3f PS = new Vector3f((Vector3fc)from);
        PS.sub((Vector3fc)P);
        Vector3f SE = new Vector3f((Vector3fc)to);
        SE.sub((Vector3fc)from);
        Vector3f adjustedVec = new Vector3f((Vector3fc)PS);
        adjustedVec.cross((Vector3fc)SE);
        adjustedVec.normalize();
        return adjustedVec;
    }

    public static void drawLaser(VertexConsumer builder, Matrix4f positionMatrix, Vector3f from, Vector3f to, float r, float g, float b, float alpha, float thickness, double v1, double v2, BlockEntity be) {
        Vector3f adjustedVec = RenderUtils.adjustBeamToEyes(from, to, be);
        adjustedVec.mul(thickness);
        Vector3f p1 = new Vector3f((Vector3fc)from);
        p1.add((Vector3fc)adjustedVec);
        Vector3f p2 = new Vector3f((Vector3fc)from);
        p2.sub((Vector3fc)adjustedVec);
        Vector3f p3 = new Vector3f((Vector3fc)to);
        p3.add((Vector3fc)adjustedVec);
        Vector3f p4 = new Vector3f((Vector3fc)to);
        p4.sub((Vector3fc)adjustedVec);
        builder.addVertex(positionMatrix, p1.x(), p1.y(), p1.z()).setColor(r, g, b, alpha).setUv(1.0f, (float)v1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        builder.addVertex(positionMatrix, p3.x(), p3.y(), p3.z()).setColor(r, g, b, alpha).setUv(1.0f, (float)v2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        builder.addVertex(positionMatrix, p4.x(), p4.y(), p4.z()).setColor(r, g, b, alpha).setUv(0.0f, (float)v2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        builder.addVertex(positionMatrix, p2.x(), p2.y(), p2.z()).setColor(r, g, b, alpha).setUv(0.0f, (float)v1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
    }
}

