/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.util.ToggleButtons;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class ToggleStateButtonClick
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(SkyGUIs.getInstance().resource("toggle_state_button_click"));

    public ToggleStateButtonClick() {
        super(TYPE, PacketFlow.SERVERBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        SkyblockSavedData data = SkyblockSavedData.get((Level)player.getCommandSenderWorld());
        Team team = data.getTeam(msg.team);
        if (team != null) {
            switch (msg.toggleButtonsType) {
                case VISITS: {
                    team.setAllowVisit(!team.allowsVisits());
                    break;
                }
                case JOIN_REQUEST: {
                    team.setAllowJoinRequest(!team.allowsJoinRequests());
                }
            }
        }
    }

    public record Message(UUID team, ToggleButtons.Type toggleButtonsType) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.of((buffer, msg) -> {
            buffer.writeUUID(msg.team);
            buffer.writeEnum((Enum)msg.toggleButtonsType);
        }, buffer -> new Message(buffer.readUUID(), (ToggleButtons.Type)buffer.readEnum(ToggleButtons.Type.class)));

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

