/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.base.list;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import de.melanx.skyblockbuilder.client.GameProfileCache;
import de.melanx.skyguis.client.screen.base.list.ListScreen;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class PlayerListScreen
extends ListScreen<GameProfile> {
    public PlayerListScreen(Component title, Set<UUID> players, int xSize, int ySize, ListScreen.ScrollbarInfo scrollbarInfo, ListScreen.RenderAreaInfo renderAreaInfo) {
        this(title, players.stream().toList(), xSize, ySize, scrollbarInfo, renderAreaInfo);
    }

    public PlayerListScreen(Component title, List<UUID> values, int xSize, int ySize, ListScreen.ScrollbarInfo scrollbarInfo, ListScreen.RenderAreaInfo renderAreaInfo) {
        super(title, PlayerListScreen.collectProfiles(values), xSize, ySize, scrollbarInfo, renderAreaInfo);
    }

    @Override
    protected void fillWidgets() {
        for (int i = 0; i < this.values.size(); ++i) {
            this.addCheckboxWidget(this.renderArea.addRenderableWidget2(new PlayerWidget(this, (GameProfile)this.values.get(i), this, 0, 14 * i, 100, 12)));
        }
    }

    @Override
    protected int entriesPerPage() {
        return 10;
    }

    private static List<GameProfile> collectProfiles(List<UUID> ids) {
        ArrayList tempProfiles = Lists.newArrayList();
        for (UUID id : ids) {
            GameProfile profile2 = GameProfileCache.get((UUID)id);
            if (profile2 == null) continue;
            tempProfiles.add(profile2);
        }
        return tempProfiles.stream().sorted(Comparator.comparing(profile -> profile.getName().toLowerCase(Locale.ROOT))).collect(Collectors.toList());
    }

    protected class PlayerWidget
    extends ListScreen.CheckboxTextWidget {
        public PlayerWidget(PlayerListScreen this$0, GameProfile profile, Screen screen, int x, int y, int width, int height) {
            super(this$0, profile, screen, x, y, width, height, PlayerWidget.buildTooltip(profile), (Component)Component.literal((String)profile.getName()));
        }

        public UUID getId() {
            return ((GameProfile)this.value).getId();
        }

        private static List<Component> buildTooltip(GameProfile profile) {
            ArrayList tooltip = Lists.newArrayList((Object[])new Component[]{Component.literal((String)profile.getName())});
            if (Minecraft.getInstance().options.advancedItemTooltips) {
                tooltip.add(Component.literal((String)profile.getId().toString()).withStyle(ChatFormatting.GRAY));
            }
            return tooltip;
        }
    }
}

