/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.melanx.skyguis.ClientEventHandler;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.network.handler.OpenGui;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.mod.ModXRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="skyguis")
public final class SkyGUIs
extends ModXRegistration {
    private static SkyGUIs instance;
    private final EasyNetwork network;
    public final Logger logger;
    public static final String MODID = "skyguis";

    public SkyGUIs(IEventBus modBus, Dist dist) {
        instance = this;
        this.network = new EasyNetwork((ModX)this);
        this.logger = LoggerFactory.getLogger((String)this.modid);
        if (dist.isClient()) {
            NeoForge.EVENT_BUS.register((Object)new ClientEventHandler(modBus));
        }
        NeoForge.EVENT_BUS.addListener(SkyGUIs::registerClientCommands);
    }

    public static SkyGUIs getInstance() {
        return instance;
    }

    public static EasyNetwork getNetwork() {
        return SkyGUIs.instance.network;
    }

    protected void setup(FMLCommonSetupEvent event) {
    }

    protected void clientSetup(FMLClientSetupEvent event) {
    }

    public static void registerClientCommands(RegisterCommandsEvent event) {
        LiteralArgumentBuilder guiCommand = (LiteralArgumentBuilder)Commands.literal((String)"gui").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new OpenGui.Message(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return 1;
        });
        CommandDispatcher commandDispatcher = event.getDispatcher();
        commandDispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"skyblock").then((ArgumentBuilder)guiCommand));
        commandDispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"sky").then((ArgumentBuilder)guiCommand));
    }
}

