/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.serialization.Codec;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.gen.feature.SolitaryNestFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration;

public class StructureSolitaryNestFeature
extends SolitaryNestFeature {
    private final int offsetSpan;

    public StructureSolitaryNestFeature(String probability, Codec<ReplaceBlockConfiguration> configFactory, int offsetSpan) {
        super(probability, configFactory);
        this.offsetSpan = offsetSpan;
    }

    @Override
    public boolean place(FeaturePlaceContext<ReplaceBlockConfiguration> context) {
        WorldGenLevel world = context.level();
        RandomSource rand = context.random();
        BlockPos blockPos = context.origin();
        ReplaceBlockConfiguration featureConfig = (ReplaceBlockConfiguration)context.config();
        for (OreConfiguration.TargetBlockState targetBlockState : featureConfig.targetStates) {
            BlockState state;
            block6: {
                if (ProductiveBeesConfig.WORLD_GEN.nestConfigs.containsKey(this.configKey) && rand.nextFloat() > ((Double)ProductiveBeesConfig.WORLD_GEN.nestConfigs.get(this.configKey).get()).floatValue()) {
                    return false;
                }
                if (!targetBlockState.target.test(world.getBlockState(blockPos = blockPos.south(rand.nextInt(14)).east(rand.nextInt(14)).above(50)), rand)) {
                    for (Direction dir : BlockStateProperties.HORIZONTAL_FACING.getPossibleValues()) {
                        if (!targetBlockState.target.test(world.getBlockState(blockPos.relative(dir, 2)), rand)) continue;
                        blockPos = blockPos.relative(dir, 3);
                        break block6;
                    }
                    return false;
                }
            }
            blockPos = blockPos.relative(Direction.UP, rand.nextInt(this.offsetSpan));
            block2: for (Direction dir : BlockStateProperties.HORIZONTAL_FACING.getPossibleValues()) {
                int i = 0;
                while (++i <= 5) {
                    if (!world.isEmptyBlock(blockPos.relative(dir, i))) continue;
                    blockPos = blockPos.relative(dir, i - 1);
                    break block2;
                }
            }
            if (!targetBlockState.target.test(state = this.placeOntop ? world.getBlockState(blockPos.below()) : world.getBlockState(blockPos), rand)) continue;
            return this.placeNest(world, blockPos, targetBlockState.state, rand);
        }
        return false;
    }
}

