/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.recipe.TimedRecipeInterface;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivelib.common.recipe.TagOutputRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class CentrifugeRecipe
extends TagOutputRecipe
implements Recipe<RecipeInput>,
TimedRecipeInterface {
    public final Ingredient ingredient;
    public final SizedFluidIngredient fluidOutput;
    private final Integer processingTime;

    public CentrifugeRecipe(Ingredient ingredient, List<TagOutputRecipe.ChancedOutput> itemOutput, SizedFluidIngredient fluidOutput, int processingTime) {
        super(itemOutput);
        this.ingredient = ingredient;
        this.fluidOutput = fluidOutput;
        this.processingTime = processingTime;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime > 0 ? this.processingTime : (Integer)ProductiveBeesConfig.GENERAL.centrifugeProcessingTime.get();
    }

    public boolean matches(RecipeInput inv, Level worldIn) {
        if (this.ingredient.getItems().length > 0) {
            ItemStack invStack = inv.getItem(1);
            if (!this.ingredient.test(invStack)) {
                return false;
            }
            for (ItemStack stack : this.ingredient.getItems()) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)invStack, (ItemStack)stack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public FluidStack getFluidOutputs() {
        return CentrifugeRecipe.getPreferredFluidStackByMod((SizedFluidIngredient)this.fluidOutput);
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.CENTRIFUGE.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.CENTRIFUGE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<CentrifugeRecipe> {
        private static final MapCodec<CentrifugeRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)Codec.list((Codec)TagOutputRecipe.ChancedOutput.CODEC).fieldOf("outputs").forGetter(recipe -> recipe.itemOutput), (App)SizedFluidIngredient.FLAT_CODEC.fieldOf("fluid").orElse((Object)SizedFluidIngredient.of((FluidStack)new FluidStack(ModFluids.HONEY, 100))).forGetter(recipe -> recipe.fluidOutput), (App)Codec.INT.fieldOf("processingTime").orElse((Object)0).forGetter(recipe -> recipe.processingTime)).apply((Applicative)builder, CentrifugeRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CentrifugeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<CentrifugeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CentrifugeRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static CentrifugeRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
                ArrayList<TagOutputRecipe.ChancedOutput> itemOutput = new ArrayList<TagOutputRecipe.ChancedOutput>();
                IntStream.range(0, buffer.readInt()).forEach(i -> itemOutput.add(TagOutputRecipe.ChancedOutput.read((RegistryFriendlyByteBuf)buffer)));
                return new CentrifugeRecipe(ingredient, itemOutput, (SizedFluidIngredient)SizedFluidIngredient.STREAM_CODEC.decode((Object)buffer), buffer.readInt());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading centrifuge recipe from packet. ", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, @Nonnull CentrifugeRecipe recipe) {
            try {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
                buffer.writeInt(recipe.itemOutput.size());
                recipe.itemOutput.forEach(chancedRecipe -> TagOutputRecipe.ChancedOutput.write((RegistryFriendlyByteBuf)buffer, (TagOutputRecipe.ChancedOutput)chancedRecipe));
                SizedFluidIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluidOutput);
                buffer.writeInt(recipe.getProcessingTime());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing centrifuge recipe to packet.", (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends CentrifugeRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, Map<Ingredient, IntArrayTag> var3, Pair<String, Integer> var4, Integer var5);
        }
    }
}

