/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.hive;

import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.registry.LibItems;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HoarderBee
extends ProductiveBee {
    protected static final EntityDataAccessor<Byte> PEEK_TICK = SynchedEntityData.defineId(HoarderBee.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private float prevPeekAmount;
    private float peekAmount = 1.0f;
    public BlockPos targetItemPos = null;
    private final SimpleContainer inventory = new SimpleContainer(this.getBeeName().equals("hoarder") ? 3 : 1);
    private int outOfHiveCounter = 0;

    public HoarderBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public boolean canSelfBreed() {
        return false;
    }

    public int getInventorySize() {
        return this.inventory.getContainerSize();
    }

    @Override
    protected void registerGoals() {
        this.registerBaseGoals();
        this.goalSelector.removeGoal((Goal)this.breedGoal);
        this.goalSelector.addGoal(3, (Goal)new PickupItemGoal());
        this.goalSelector.addGoal(3, (Goal)new LocateItemGoal());
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(PEEK_TICK, (Object)100);
    }

    @Override
    public void tick() {
        super.tick();
        float f1 = (float)this.getPeekTick() * 0.01f;
        this.prevPeekAmount = this.peekAmount;
        if (this.peekAmount > f1) {
            this.peekAmount = Mth.clamp((float)(this.peekAmount - 0.05f), (float)f1, (float)1.0f);
        } else if (this.peekAmount < f1) {
            this.peekAmount = Mth.clamp((float)(this.peekAmount + 0.05f), (float)0.0f, (float)f1);
        }
    }

    public int getPeekTick() {
        return ((Byte)this.entityData.get(PEEK_TICK)).byteValue();
    }

    public float getClientPeekAmount(float p_184688_1_) {
        return Mth.lerp((float)p_184688_1_, (float)this.prevPeekAmount, (float)this.peekAmount);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(PEEK_TICK, (Object)tag.getByte("Peek"));
        if (tag.contains("targetItemPos")) {
            this.targetItemPos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"targetItemPos").orElse(null);
        }
        if (tag.contains("inventory")) {
            ListTag listnbt = tag.getList("inventory", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                ItemStack itemstack = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)listnbt.getCompound(i));
                if (itemstack.isEmpty()) continue;
                this.inventory.addItem(itemstack);
            }
            tag.remove("inventory");
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte("Peek", ((Byte)this.entityData.get(PEEK_TICK)).byteValue());
        if (this.targetItemPos != null) {
            tag.put("targetItemPos", NbtUtils.writeBlockPos((BlockPos)this.targetItemPos));
        }
        if (!this.inventory.isEmpty()) {
            ListTag listnbt = new ListTag();
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                ItemStack itemstack = this.inventory.getItem(i);
                if (itemstack.isEmpty()) continue;
                listnbt.add((Object)itemstack.save((HolderLookup.Provider)this.registryAccess()));
            }
            tag.put("inventory", (Tag)listnbt);
        }
    }

    public void resetTicksWithoutNectarSinceExitingHive() {
        super.resetTicksWithoutNectarSinceExitingHive();
        this.outOfHiveCounter = 0;
    }

    protected void dropEquipment() {
        super.dropEquipment();
        this.spawnAtLocation((ItemLike)Items.SHULKER_SHELL);
    }

    public void openAbdomen() {
        this.entityData.set(PEEK_TICK, (Object)0);
    }

    public void closeAbdomen() {
        this.entityData.set(PEEK_TICK, (Object)100);
    }

    public boolean holdsItem() {
        return !this.inventory.isEmpty();
    }

    public void emptyIntoInventory(InventoryHandlerHelper.BlockEntityItemStackHandler inv) {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            if (inv.addOutput(itemstack.copy()).getCount() != 0) continue;
            this.inventory.removeItemNoUpdate(i);
        }
        this.inventory.setChanged();
    }

    @Override
    public boolean wantsToEnterHive() {
        return this.outOfHiveCounter > 600 || !this.inventoryHasSpace() || super.wantsToEnterHive();
    }

    public void die(@Nonnull DamageSource damageSource) {
        super.die(damageSource);
        if (!this.isInventoryEmpty()) {
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)this.inventory);
        }
    }

    public List<ItemEntity> getItemsNearby(double distance) {
        return this.getItemsNearby(this.blockPosition(), distance);
    }

    public List<ItemEntity> getItemsNearby(BlockPos pos, double distance) {
        return this.level().getEntitiesOfClass(ItemEntity.class, new AABB(pos).inflate(distance, distance, distance));
    }

    public boolean isInventoryEmpty() {
        return this.inventory.isEmpty();
    }

    private boolean inventoryHasSpace() {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            if (!itemstack.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void pickupItem(ItemEntity item) {
        ItemStack itemstack = item.getItem().copy();
        ItemStack remaining = this.inventory.addItem(itemstack);
        if (remaining.isEmpty()) {
            item.discard();
        } else {
            item.setItem(remaining);
        }
    }

    public class PickupItemGoal
    extends Goal {
        private int ticks = 0;

        public boolean canUse() {
            if (HoarderBee.this.targetItemPos != null && !this.positionHasItemEntity(HoarderBee.this.targetItemPos)) {
                HoarderBee.this.targetItemPos = null;
            }
            return HoarderBee.this.targetItemPos != null && HoarderBee.this.inventoryHasSpace() && !HoarderBee.this.isAngry() && !HoarderBee.this.targetItemPos.closerToCenterThan((Position)HoarderBee.this.position(), 2.0);
        }

        public void start() {
            this.ticks = 0;
            super.start();
        }

        public void tick() {
            ++HoarderBee.this.outOfHiveCounter;
            if (HoarderBee.this.targetItemPos != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    HoarderBee.this.targetItemPos = null;
                } else if (!HoarderBee.this.navigation.isStuck()) {
                    BlockPos itemPos = HoarderBee.this.targetItemPos;
                    HoarderBee.this.navigation.moveTo((double)itemPos.getX(), (double)itemPos.getY(), (double)itemPos.getZ(), 1.0);
                }
            }
        }

        private boolean positionHasItemEntity(BlockPos pos) {
            return !HoarderBee.this.getItemsNearby(pos, 1.0).isEmpty();
        }
    }

    public class LocateItemGoal
    extends Goal {
        private int ticks = 0;

        public boolean canUse() {
            boolean canStart;
            boolean bl = canStart = HoarderBee.this.inventoryHasSpace() && !HoarderBee.this.isAngry();
            if (canStart && HoarderBee.this.getHivePos() != null) {
                List<Object> items = new ArrayList();
                BlockEntity hive = HoarderBee.this.level().getBlockEntity(HoarderBee.this.getHivePos());
                if (hive instanceof AdvancedBeehiveBlockEntity) {
                    AdvancedBeehiveBlockEntity beehiveBlockEntity = (AdvancedBeehiveBlockEntity)hive;
                    int radius = 5 + beehiveBlockEntity.getUpgradeCount((Item)LibItems.UPGRADE_RANGE.get());
                    items = HoarderBee.this.getItemsNearby(HoarderBee.this.getHivePos(), radius);
                }
                if (!items.isEmpty()) {
                    BlockPos nearestItemLocation = null;
                    double nearestItemDistance = -1.0;
                    BlockPos beeLocation = HoarderBee.this.blockPosition();
                    int i = 0;
                    for (ItemEntity item : items) {
                        BlockPos itemLocation = new BlockPos((int)item.getX(), (int)item.getY(), (int)item.getZ());
                        double distance = itemLocation.distSqr((Vec3i)beeLocation);
                        if (nearestItemDistance == -1.0 || distance < nearestItemDistance) {
                            nearestItemDistance = distance;
                            nearestItemLocation = itemLocation;
                        }
                        if (++i <= 10) continue;
                        break;
                    }
                    HoarderBee.this.targetItemPos = nearestItemLocation;
                    return true;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            return HoarderBee.this.targetItemPos != null && HoarderBee.this.inventoryHasSpace() && !HoarderBee.this.isAngry();
        }

        public void start() {
            this.ticks = 0;
        }

        public void stop() {
            this.ticks = 0;
            HoarderBee.this.closeAbdomen();
        }

        public void tick() {
            ++HoarderBee.this.outOfHiveCounter;
            ++this.ticks;
            if (HoarderBee.this.targetItemPos != null) {
                if (this.ticks > 600) {
                    HoarderBee.this.targetItemPos = null;
                } else {
                    Vec3 vec3d = Vec3.atCenterOf((Vec3i)HoarderBee.this.targetItemPos).add(0.0, (double)0.6f, 0.0);
                    double distanceToTarget = vec3d.distanceTo(HoarderBee.this.position());
                    if (distanceToTarget < 2.0 && distanceToTarget > 0.2) {
                        HoarderBee.this.openAbdomen();
                    }
                    if (distanceToTarget > 1.2) {
                        this.moveToNextTarget(vec3d);
                    } else if (distanceToTarget > 0.5 && this.ticks > 600) {
                        HoarderBee.this.targetItemPos = null;
                    } else {
                        List<ItemEntity> items = HoarderBee.this.getItemsNearby(1.0);
                        if (!items.isEmpty()) {
                            ItemEntity item = items.iterator().next();
                            HoarderBee.this.pickupItem(item);
                            HoarderBee.this.closeAbdomen();
                            HoarderBee.this.playSound(SoundEvents.BEE_POLLINATE, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        private void moveToNextTarget(Vec3 nextTarget) {
            HoarderBee.this.getMoveControl().setWantedPosition(nextTarget.x, nextTarget.y, nextTarget.z, 1.0);
        }
    }
}

