/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.common.recipe.CombineGeneRecipe;
import cy.jdkdigital.productivebees.container.GeneIndexerContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.util.GeneGroup;
import cy.jdkdigital.productivelib.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class GeneIndexerBlockEntity
extends CapabilityBlockEntity
implements MenuProvider {
    private boolean isProcessing = false;
    private final Queue<InsertionAction> queue = new LinkedList<InsertionAction>();
    private final Map<String, List<SlotEntry>> index = new HashMap<String, List<SlotEntry>>();
    public final IItemHandlerModifiable inventoryHandler = new InventoryHandlerHelper.BlockEntityItemStackHandler(this, 104, (BlockEntity)this){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack, boolean fromAutomation) {
            return stack.getItem() instanceof Gene;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BlockEntity blockEntity = this.blockEntity;
            if (!(blockEntity instanceof GeneIndexerBlockEntity)) {
                return;
            }
            GeneIndexerBlockEntity indexer = (GeneIndexerBlockEntity)blockEntity;
            ItemStack stack = indexer.inventoryHandler.getStackInSlot(slot);
            if (stack.isEmpty() || !(stack.getItem() instanceof Gene)) {
                GeneIndexerBlockEntity.updateSlot(indexer, stack, slot);
                return;
            }
            GeneGroup group = Gene.getGenes(stack);
            if (group == null || group.purity() == 100) {
                GeneIndexerBlockEntity.updateSlot(indexer, stack, slot);
                return;
            }
            String key = group.attribute().getSerializedName() + "-" + group.value();
            if (!indexer.index.containsKey(key)) {
                GeneIndexerBlockEntity.updateSlot(indexer, stack, slot);
                return;
            }
            List<SlotEntry> entries = indexer.index.get(key);
            if (entries == null || entries.isEmpty()) {
                GeneIndexerBlockEntity.updateSlot(indexer, stack, slot);
                return;
            }
            Optional<SlotEntry> optional = entries.stream().filter(e -> e.slot() != slot).findFirst();
            if (optional.isEmpty()) {
                GeneIndexerBlockEntity.updateSlot(indexer, stack, slot);
                return;
            }
            if (indexer.isProcessing) {
                GeneIndexerBlockEntity.updateSlot(indexer, stack, slot);
                return;
            }
            indexer.isProcessing = true;
            try {
                indexer.queue.add(new InsertionAction(key, optional.get(), stack, slot));
            }
            finally {
                indexer.isProcessing = false;
            }
        }

        public int[] getOutputSlots() {
            return IntStream.range(0, this.getSlots()).toArray();
        }

        public boolean isInsertableSlot(int slot) {
            return true;
        }

        public boolean isInputSlot(int slot) {
            return false;
        }

        public boolean isInputSlotItem(int slot, ItemStack item) {
            return this.isItemValid(slot, item);
        }
    };

    public GeneIndexerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.GENE_INDEXER.get(), pos, state);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, GeneIndexerBlockEntity indexer) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        while (!indexer.queue.isEmpty()) {
            InsertionAction stack = indexer.queue.poll();
            indexer.process(indexer, stack.key(), stack.entry(), stack.stack(), stack.slot());
        }
    }

    public void onLoad() {
        if (this.level != null && !this.level.isClientSide) {
            GeneIndexerBlockEntity.buildIndex(this);
        }
        super.onLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(GeneIndexerBlockEntity indexer, String key, SlotEntry entry, ItemStack stack, int slot) {
        List<SlotEntry> entries = indexer.index.get(key);
        if (entries == null || entries.isEmpty()) {
            GeneIndexerBlockEntity.updateSlot(indexer, stack, slot);
            return;
        }
        indexer.isProcessing = true;
        try {
            int i;
            InventoryHandlerHelper.BlockEntityItemStackHandler handler = (InventoryHandlerHelper.BlockEntityItemStackHandler)indexer.inventoryHandler;
            ItemStack entryStack = handler.getStackInSlot(entry.slot());
            int stackCount = stack.getCount();
            int entryCount = entryStack.getCount();
            ArrayList<ItemStack> genesToCombine = new ArrayList<ItemStack>();
            for (i = 0; i < stackCount; ++i) {
                genesToCombine.add(stack.copyWithCount(1));
            }
            for (i = 0; i < entryCount; ++i) {
                genesToCombine.add(entryStack.copyWithCount(1));
            }
            stack.shrink(stackCount);
            entryStack.shrink(entryCount);
            GeneIndexerBlockEntity.updateSlot(indexer, stack, slot);
            GeneIndexerBlockEntity.updateSlot(indexer, entryStack, entry.slot());
            while (!genesToCombine.isEmpty()) {
                Pair<ItemStack, ItemStack> combination = CombineGeneRecipe.mergeGenes(genesToCombine);
                if (!((ItemStack)combination.getFirst()).isEmpty()) {
                    handler.addOutput((ItemStack)combination.getFirst());
                    if (Gene.getPurity((ItemStack)combination.getFirst()) == 100) {
                        entries.remove(entry);
                    }
                }
                genesToCombine.clear();
                if (((ItemStack)combination.getSecond()).isEmpty()) break;
                genesToCombine.add((ItemStack)combination.getSecond());
            }
            indexer.index.entrySet().removeIf(mapEntry -> ((List)mapEntry.getValue()).isEmpty());
        }
        finally {
            indexer.isProcessing = false;
        }
    }

    private static void buildIndex(GeneIndexerBlockEntity blockEntity) {
        blockEntity.index.clear();
        for (int slot = 0; slot < blockEntity.inventoryHandler.getSlots(); ++slot) {
            GeneGroup group;
            ItemStack stack = blockEntity.inventoryHandler.getStackInSlot(slot);
            if (stack.isEmpty() || !(stack.getItem() instanceof Gene) || (group = Gene.getGenes(stack)) == null || group.purity() == 100) continue;
            String key = group.attribute().getSerializedName() + "-" + group.value();
            blockEntity.index.computeIfAbsent(key, k -> new ArrayList()).add(new SlotEntry(slot, group.purity()));
        }
    }

    private static void updateSlot(GeneIndexerBlockEntity blockEntity, ItemStack stack, int slot) {
        blockEntity.index.values().forEach(list -> list.removeIf(entry -> entry.slot() == slot));
        GeneGroup group = Gene.getGenes(stack);
        if (group == null || group.purity() == 100) {
            return;
        }
        String key = group.attribute().getSerializedName() + "-" + group.value();
        if (!stack.isEmpty()) {
            blockEntity.index.computeIfAbsent(key, k -> new ArrayList()).add(new SlotEntry(slot, group.purity()));
        }
    }

    @Nonnull
    public Component getName() {
        return Component.translatable((String)((Block)ModBlocks.GENE_INDEXER.get()).getDescriptionId());
    }

    @Nonnull
    public Component getDisplayName() {
        return Component.translatable((String)((Block)ModBlocks.GENE_INDEXER.get()).getDescriptionId());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new GeneIndexerContainer(pContainerId, pPlayerInventory, this);
    }

    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }

    private record InsertionAction(String key, SlotEntry entry, ItemStack stack, int slot) {
    }

    private record SlotEntry(int slot, int purity) {
    }
}

