/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.advancements.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class CatchBeeTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, ItemStack cage) {
        this.trigger(player, trigger -> trigger.test(cage));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, String beeName) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)Codec.STRING.fieldOf("bee").forGetter(TriggerInstance::beeName)).apply((Applicative)instance, TriggerInstance::new));

        public static TriggerInstance any() {
            return new TriggerInstance(Optional.empty(), "any");
        }

        public static TriggerInstance create(String beeName) {
            return new TriggerInstance(Optional.empty(), beeName);
        }

        public boolean test(ItemStack cage) {
            CompoundTag tag;
            if (BeeCage.isFilled(cage) && (tag = ((CustomData)cage.get(DataComponents.CUSTOM_DATA)).copyTag()).contains("type")) {
                String type = tag.getString("type");
                return this.beeName.equals("any") || type.equals(this.beeName);
            }
            return false;
        }
    }
}

