/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.math.Vector2;
import com.brandon3055.brandonscore.lib.TeleportUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;

public record TargetPos(Vector3 pos, ResourceKey<Level> dimension, Optional<Vector2> facing) {
    public static final Codec<TargetPos> CODEC = RecordCodecBuilder.create(b -> b.group((App)Vector3.CODEC.fieldOf("pos").forGetter(TargetPos::pos), (App)Level.RESOURCE_KEY_CODEC.fieldOf("dimension").forGetter(TargetPos::dimension), (App)Vector2.CODEC.optionalFieldOf("facing").forGetter(TargetPos::facing)).apply((Applicative)b, TargetPos::new));
    public static final StreamCodec<ByteBuf, TargetPos> STREAM_CODEC = StreamCodec.composite((StreamCodec)Vector3.STREAM_CODEC, TargetPos::pos, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), TargetPos::dimension, (StreamCodec)ByteBufCodecs.optional(Vector2.STREAM_CODEC), TargetPos::facing, TargetPos::new);

    public static TargetPos of(Entity entity) {
        return TargetPos.of(entity, true);
    }

    public static TargetPos of(Entity entity, boolean includeHeading) {
        return new TargetPos(Vector3.fromEntity((Entity)entity), (ResourceKey<Level>)entity.level().dimension(), includeHeading ? Optional.of(new Vector2(entity.getXRot(), entity.getYRot())) : Optional.empty());
    }

    public static TargetPos of(double x, double y, double z, ResourceKey<Level> dimension) {
        return new TargetPos(new Vector3(x, y, z), dimension, Optional.empty());
    }

    public static TargetPos of(double x, double y, double z, ResourceKey<Level> dimension, Vec2 facing) {
        return new TargetPos(new Vector3(x, y, z), dimension, Optional.of(new Vector2(facing)));
    }

    public static TargetPos of(Vector3 pos, ResourceKey<Level> dimension) {
        return new TargetPos(pos, dimension, Optional.empty());
    }

    public static TargetPos of(Vector3 pos, ResourceKey<Level> dimension, Vec2 facing) {
        return new TargetPos(pos, dimension, Optional.of(new Vector2(facing)));
    }

    public static TargetPos of(CompoundTag nbt) {
        return TargetPos.readFromNBT(nbt);
    }

    public double getX() {
        return this.pos.x;
    }

    public double getY() {
        return this.pos.y;
    }

    public double getZ() {
        return this.pos.z;
    }

    public Vector3 getPos() {
        return this.pos;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public String getReadableName(boolean fullDim) {
        return "X: " + (int)Math.floor(this.pos.x) + ", Y: " + (int)Math.floor(this.pos.y) + ", Z: " + (int)Math.floor(this.pos.z) + ", " + String.valueOf(fullDim ? this.dimension.location() : this.dimension.location().getPath());
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        this.pos.writeToNBT(nbt);
        nbt.putString("dim", this.dimension.location().toString());
        this.facing.ifPresent(e -> {
            nbt.putDouble("facing_x", e.x);
            nbt.putDouble("facing_y", e.y);
        });
        return nbt;
    }

    public CompoundTag writeToNBT() {
        return this.writeToNBT(new CompoundTag());
    }

    public static TargetPos readFromNBT(CompoundTag nbt) {
        Vector3 pos = Vector3.fromNBT((CompoundTag)nbt);
        ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)nbt.getString("dim")));
        if (nbt.contains("facing_x")) {
            return new TargetPos(pos, (ResourceKey<Level>)dimension, Optional.of(new Vector2(nbt.getDouble("facing_x"), nbt.getDouble("facing_y"))));
        }
        return new TargetPos(pos, (ResourceKey<Level>)dimension, Optional.empty());
    }

    public void write(MCDataOutput output) {
        output.writeVector(this.pos);
        output.writeResourceLocation(this.dimension.location());
        output.writeBoolean(this.facing.isPresent());
        this.facing.ifPresent(e -> {
            output.writeDouble(e.x);
            output.writeDouble(e.y);
        });
    }

    public static TargetPos read(MCDataInput input) {
        Vector3 pos = input.readVector();
        ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)input.readResourceLocation());
        if (input.readBoolean()) {
            return new TargetPos(pos, (ResourceKey<Level>)dimension, Optional.of(new Vector2(input.readDouble(), input.readDouble())));
        }
        return new TargetPos(pos, (ResourceKey<Level>)dimension, Optional.empty());
    }

    public Entity teleport(Entity entity) {
        if (this.facing.isPresent()) {
            return TeleportUtils.teleportEntity(entity, this.dimension, this.pos, (float)this.facing.get().y, (float)this.facing.get().x);
        }
        return TeleportUtils.teleportEntity(entity, this.dimension, this.pos);
    }
}

