/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManagedEnum<T extends Enum<T>>
extends AbstractManagedData<T> {
    private T value;
    private Class<T> enumClass;
    public Map<Integer, T> indexToValue = new HashMap<Integer, T>();
    public Map<T, Integer> valueToIndex = new HashMap<T, Integer>();
    protected Function<T, T> validator = null;

    public ManagedEnum(String name, @NotNull T defaultValue, DataFlags ... flags) {
        this(name, ((Enum)defaultValue).getDeclaringClass(), defaultValue, flags);
    }

    public ManagedEnum(String name, Class<T> enumClass, @Nullable T defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
        this.enumClass = enumClass;
        Enum[] v = (Enum[])enumClass.getEnumConstants();
        if (v.length > 255) {
            throw new RuntimeException("Max enum size supported by SyncableEnum is 255");
        }
        for (int i = 0; i < v.length; ++i) {
            this.indexToValue.put(i, v[i]);
            this.valueToIndex.put(v[i], i);
        }
    }

    public T set(T value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            T prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    public T get() {
        return this.value;
    }

    public ManagedEnum<T> setValidator(Function<T, T> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = (Enum)this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeBoolean(this.value == null);
        if (this.value != null) {
            output.writeEnum(this.value);
        }
    }

    @Override
    public void fromBytes(MCDataInput input) {
        if (!input.readBoolean()) {
            this.value = input.readEnum(this.enumClass);
        }
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(HolderLookup.Provider provider, CompoundTag compound) {
        CompoundTag nbt = new CompoundTag();
        if (this.value == null) {
            nbt.putBoolean("null", true);
        } else {
            nbt.putByte("value", this.valueToIndex.get(this.value).byteValue());
        }
        compound.put(this.name, (Tag)nbt);
    }

    @Override
    public void fromNBT(HolderLookup.Provider provider, CompoundTag compound) {
        if (compound.contains(this.name, 10)) {
            CompoundTag nbt = compound.getCompound(this.name);
            this.value = nbt.contains("null") ? null : (Enum)this.indexToValue.get(MathHelper.clip((int)(nbt.getByte("value") & 0xFF), (int)0, (int)(this.indexToValue.size() - 1)));
        }
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + String.valueOf(this.value) + "]";
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean notNull() {
        return this.value != null;
    }
}

