/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import codechicken.lib.inventory.InventorySimple;
import com.brandon3055.brandonscore.BCContent;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ContainerPlayerAccess
extends AbstractContainerMenu {
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public Player player;
    public Player playerAccess;
    private Container targetInventory;
    private MinecraftServer server;
    private int tick = 0;

    public ContainerPlayerAccess(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        super((MenuType)BCContent.MENU_PLAYER_ACCESS.get(), windowId);
        this.player = playerInv.player;
        this.playerAccess = null;
        this.targetInventory = new InventorySimple(41);
        this.layoutSlots();
    }

    public ContainerPlayerAccess(int id, Inventory playerInv, Player playerAccess, MinecraftServer server) {
        super((MenuType)BCContent.MENU_PLAYER_ACCESS.get(), id);
        this.player = playerInv.player;
        this.playerAccess = playerAccess;
        this.targetInventory = playerAccess.getInventory();
        this.server = server;
        this.layoutSlots();
    }

    public void broadcastChanges() {
        if (this.tick++ % 10 == 0 && this.player instanceof ServerPlayer && this.playerAccess != null) {
            BCoreNetwork.sendPlayerAccessUIUpdate((ServerPlayer)this.player, this.playerAccess);
        }
        super.broadcastChanges();
    }

    public void layoutSlots() {
        int i;
        int x;
        int y;
        int x2;
        int xPos = 9;
        int yPos = 21;
        for (x2 = 0; x2 < 9; ++x2) {
            this.addSlot(new Slot(this.targetInventory, x2, xPos + 21 + 18 * x2, yPos + 54 + 3));
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlot(new Slot(this.targetInventory, x + y * 9 + 9, xPos + 21 + 18 * x, yPos + y * 18));
            }
        }
        for (i = 0; i < 4; ++i) {
            this.addSlot(new ArmorSlot(this.targetInventory, 36 + (3 - i), xPos, yPos + i * 19, VALID_EQUIPMENT_SLOTS[i], this.player));
        }
        this.addSlot(new OffhandSlot(this.targetInventory, 40, xPos + 186, yPos + 54 + 3));
        xPos = 9;
        yPos = 168;
        for (x2 = 0; x2 < 9; ++x2) {
            this.addSlot(new Slot((Container)this.player.getInventory(), x2, xPos + 21 + 18 * x2, yPos + 54 + 3));
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)this.player.getInventory(), x + y * 9 + 9, xPos + 21 + 18 * x, yPos + y * 18));
            }
        }
        for (i = 0; i < 4; ++i) {
            this.addSlot(new ArmorSlot((Container)this.player.getInventory(), 36 + (3 - i), xPos, yPos + i * 19, VALID_EQUIPMENT_SLOTS[i], this.player));
        }
        this.addSlot(new OffhandSlot((Container)this.player.getInventory(), 40, xPos + 186, yPos + 54 + 3));
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        return ItemStack.EMPTY;
    }

    private static class ArmorSlot
    extends Slot {
        private final EquipmentSlot eSlot;
        private final Player aPlayer;

        public ArmorSlot(Container inventoryIn, int index, int xPosition, int yPosition, EquipmentSlot eSlot, Player aPlayer) {
            super(inventoryIn, index, xPosition, yPosition);
            this.eSlot = eSlot;
            this.aPlayer = aPlayer;
        }

        public int getMaxStackSize() {
            return 64;
        }

        public boolean mayPlace(ItemStack stack) {
            return true;
        }

        public boolean mayPickup(Player playerIn) {
            ItemStack itemstack = this.getItem();
            return (itemstack.isEmpty() || playerIn.isCreative() || !EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) && super.mayPickup(playerIn);
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public String getSlotTexture() {
            return InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS.toString();
        }
    }

    private static class OffhandSlot
    extends Slot {
        public OffhandSlot(Container inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public String getSlotTexture() {
            return "minecraft:items/empty_armor_slot_shield";
        }
    }
}

