/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import java.util.function.IntPredicate;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public record TierPredicate(int tier, boolean matchExact) implements IntPredicate
{
    private static final String MATCH_EXACT = Util.makeDescriptionId((String)"block", (ResourceLocation)ForbiddenArcanus.location("hephaestus_forge.tier.match_exact"));
    private static final String AT_LEAST = Util.makeDescriptionId((String)"block", (ResourceLocation)ForbiddenArcanus.location("hephaestus_forge.tier.at_least"));
    public static final TierPredicate ANY = new TierPredicate(1, false);
    public static final MapCodec<TierPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("forge_tier", (Object)1).forGetter(predicate -> predicate.tier), (App)Codec.BOOL.optionalFieldOf("match_tier_exact", (Object)false).forGetter(predicate -> predicate.matchExact)).apply((Applicative)instance, TierPredicate::new));

    public static TierPredicate min(int tier) {
        return new TierPredicate(tier, false);
    }

    public static TierPredicate exact(int tier) {
        return new TierPredicate(tier, true);
    }

    @Override
    public boolean test(int value) {
        return this.matchExact ? this.tier == value : this.tier <= value;
    }

    public Component getDescription() {
        return Component.translatable((String)(this.matchExact ? MATCH_EXACT : AT_LEAST), (Object[])new Object[]{this.tier});
    }
}

