/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.world.flat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class FlatLayerConfig {
    public static final Codec<FlatLayerConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").orElse((Object)Blocks.AIR).forGetter(inst -> inst.getBlockState().getBlock()), (App)Codec.INT.optionalFieldOf("height", (Object)1).forGetter(FlatLayerConfig::getHeight), (App)Extras.CODEC.optionalFieldOf("extras", (Object)Extras.EMPTY).forGetter(inst -> inst.extras)).apply((Applicative)instance, FlatLayerConfig::new));
    private final Block block;
    private final int height;
    private final Extras extras;
    private WeightedRandomList<WeightedBlockEntry> weightedBlockEntries;

    public FlatLayerConfig(Block block) {
        this(block, 1);
    }

    public FlatLayerConfig(Block block, int height) {
        this(block, height, Extras.EMPTY);
    }

    public FlatLayerConfig(Block block, int height, Extras extras) {
        this.block = block;
        this.height = height;
        this.extras = extras;
    }

    public BlockState getBlockState() {
        return this.block.defaultBlockState();
    }

    public int getHeight() {
        return this.height;
    }

    public boolean hasExtra() {
        return !this.extras.isEmpty();
    }

    public boolean checkChance(RandomSource random) {
        return random.nextDouble() < this.extras.chance;
    }

    public WeightedRandomList<WeightedBlockEntry> getExtraBlocks() {
        if (this.weightedBlockEntries == null) {
            this.weightedBlockEntries = WeightedRandomList.create(this.extras.extraBlocks());
        }
        return this.weightedBlockEntries;
    }

    @Nullable
    public static FlatLayerConfig getLayerConfig(String setting, int currentLayers) {
        Block block;
        int i;
        String[] info = setting.split("\\*", 2);
        if (info.length == 2) {
            try {
                i = Math.max(Integer.parseInt(info[0]), 0);
            }
            catch (NumberFormatException numberformatexception) {
                SkyblockBuilder.getLogger().error("Error while parsing surface settings string => {}", (Object)numberformatexception.getMessage());
                return null;
            }
        } else {
            i = 1;
        }
        int maxLayers = Math.min(currentLayers + i, 384);
        int height = maxLayers - currentLayers;
        String blockName = info[info.length - 1];
        ResourceLocation blockId = ResourceLocation.tryParse((String)blockName);
        try {
            block = (Block)BuiltInRegistries.BLOCK.get(blockId);
        }
        catch (Exception exception) {
            SkyblockBuilder.getLogger().error("Error while parsing surface settings string => {}", (Object)exception.getMessage());
            return null;
        }
        if (block == Blocks.AIR && !BuiltInRegistries.BLOCK.getKey((Object)Blocks.AIR).equals((Object)blockId)) {
            SkyblockBuilder.getLogger().error("Error while parsing surface settings string => Unknown block, {}", (Object)blockName);
        }
        return new FlatLayerConfig(block, height);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.height > 1) {
            sb.append(this.height);
            sb.append("*");
        }
        sb.append(BuiltInRegistries.BLOCK.getKey((Object)this.block));
        return sb.toString();
    }

    public record Extras(List<WeightedBlockEntry> extraBlocks, double chance) {
        public static final Extras EMPTY = new Extras(List.of(), 0.0);
        public static final Codec<Extras> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)WeightedBlockEntry.CODEC.listOf().fieldOf("blocks").forGetter(Extras::extraBlocks), (App)Codec.DOUBLE.fieldOf("chance").forGetter(Extras::chance)).apply((Applicative)instance, Extras::new));

        public boolean isEmpty() {
            return this == EMPTY || this.extraBlocks.isEmpty();
        }
    }

    public record WeightedBlockEntry(Block block, int weight) implements WeightedEntry
    {
        public static final Codec<WeightedBlockEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").orElse((Object)Blocks.AIR).forGetter(WeightedBlockEntry::block), (App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(WeightedBlockEntry::weight)).apply((Applicative)instance, WeightedBlockEntry::new));

        @Nonnull
        public Weight getWeight() {
            return Weight.of((int)this.weight);
        }
    }
}

