/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.WorldUtil;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CommandUtil {
    public static boolean mayNotTeleport(CommandSourceStack source, SkyblockSavedData data, ServerPlayer player) {
        if (!PermissionManager.INSTANCE.mayBypassLimitation((Player)player) && !PermissionsConfig.Teleports.teleportationDimensions.test(player.level().dimension().location())) {
            source.sendFailure((Component)SkyComponents.ERROR_TELEPORTATION_NOT_ALLOWED_DIMENSION);
            return true;
        }
        if (!PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TELEPORT_ACROSS_DIMENSIONS) && player.level() != data.getLevel()) {
            source.sendFailure((Component)SkyComponents.ERROR_TELEPORT_ACROSS_DIMENSIONS);
            return true;
        }
        if (PermissionsConfig.Teleports.disallowTeleportationDuringFalling && player.fallDistance > 1.0f) {
            source.sendFailure((Component)SkyComponents.ERROR_PREVENT_WHILE_FALLING);
            return true;
        }
        return false;
    }

    @Nullable
    public static ValidationResult validatePlayerTeam(CommandSourceStack source) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.getLevel();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer player = source.getPlayerOrException();
        Team team = data.getTeamFromPlayer((Player)player);
        if (team == null) {
            source.sendFailure((Component)SkyComponents.ERROR_USER_HAS_NO_TEAM);
            return null;
        }
        return new ValidationResult(player, data, team);
    }

    @Nullable
    public static ValidationResult validateTeamExistence(CommandSourceStack source, String name) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.getLevel();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer player = source.getPlayerOrException();
        Team team = data.getTeam(name);
        if (team == null) {
            source.sendFailure((Component)SkyComponents.ERROR_TEAM_NOT_EXIST);
            return null;
        }
        return new ValidationResult(player, data, team);
    }

    public record ValidationResult(ServerPlayer player, SkyblockSavedData data, Team team) {
    }
}

