/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.config.values.providers;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.config.values.TemplateSpreads;

public interface SpreadsProvider {
    public static final SpreadsProvider EMPTY = new Direct(TemplateSpreads.EMPTY);

    public TemplateSpreads templateSpreads();

    public JsonElement toJson();

    public boolean isEmpty();

    public static SpreadsProvider fromJson(JsonElement json) {
        if (json.isJsonPrimitive()) {
            return new Reference(json.getAsString());
        }
        if (json.isJsonArray()) {
            return new Direct((TemplateSpreads)((Pair)TemplateSpreads.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst());
        }
        throw new IllegalArgumentException("Unknown spreads: " + String.valueOf(json));
    }

    public record Reference(String name) implements SpreadsProvider
    {
        @Override
        public TemplateSpreads templateSpreads() {
            if (!TemplatesConfig.spreadReferences.containsKey(this.name)) {
                throw new IllegalArgumentException("Unknown spreads: " + this.name);
            }
            return TemplatesConfig.spreadReferences.get(this.name);
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive(this.name);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    public record Direct(TemplateSpreads templateSpreads) implements SpreadsProvider
    {
        @Override
        public JsonElement toJson() {
            return (JsonElement)TemplateSpreads.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.templateSpreads).getOrThrow();
        }

        @Override
        public boolean isEmpty() {
            return this.templateSpreads.spreads().isEmpty();
        }
    }
}

