/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.client;

import de.melanx.skyblockbuilder.client.screens.StructureSaverScreen;
import de.melanx.skyblockbuilder.util.SkyComponents;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.loading.FMLPaths;
import org.moddingx.libx.screen.text.ComponentLayout;
import org.moddingx.libx.screen.text.TextScreen;

public class ClientUtil {
    public static void openPath(Path dir) {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Util.getPlatform().openUri(dir.toUri());
        }
        catch (IOException e) {
            Minecraft.getInstance().player.displayClientMessage((Component)SkyComponents.SCREEN_OPEN_FOLDER_ERROR.apply(dir.toString()), false);
        }
    }

    public static void openItemScreen(ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new StructureSaverScreen(stack));
    }

    public static void openErrorScreen(final Path configPath, String reason) {
        Minecraft.getInstance().setScreen((Screen)new TextScreen(ComponentLayout.simple((Component)SkyComponents.SCREEN_ERROR_TITLE, List.of(Component.literal((String)("Failed to overwrite config " + String.valueOf(FMLPaths.GAMEDIR.get().relativize(configPath)))), Component.literal((String)reason))), 230){

            protected void init() {
                super.init();
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_OK, button -> Minecraft.getInstance().setScreen(null)).pos(this.width / 2 - 115, this.height - 27).width(110).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Open Config"), button -> Util.getPlatform().openFile(configPath.toFile())).pos(this.width / 2 + 5, this.height - 27).width(110).build());
            }
        });
    }
}

