/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network.messages;

import com.mojang.serialization.Codec;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PushEntityMessage(int entityId, Vec3 vec) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PushEntityMessage> TYPE = new CustomPacketPayload.Type(MiscUtil.RL("push_entity"));
    public static final StreamCodec<FriendlyByteBuf, PushEntityMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PushEntityMessage::entityId, (StreamCodec)ByteBufCodecs.fromCodec((Codec)Vec3.CODEC), PushEntityMessage::vec, PushEntityMessage::new);

    public static PushEntityMessage forEntity(Entity entity, Vec3 vec) {
        return new PushEntityMessage(entity.getId(), vec);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleData(PushEntityMessage message, IPayloadContext context) {
        Entity entity = context.player().level().getEntity(message.entityId());
        if (entity != null) {
            Vec3 vec = message.vec();
            entity.setDeltaMovement(vec.x, vec.y, vec.z);
            entity.horizontalCollision = false;
            entity.verticalCollision = false;
            if (entity instanceof LivingEntity) {
                LivingEntity l = (LivingEntity)entity;
                l.setJumping(true);
            }
        }
    }
}

