/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network.messages;

import java.util.Optional;
import me.desht.modularrouters.container.BulkItemFilterMenu;
import me.desht.modularrouters.item.smartfilter.BulkItemFilter;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.settings.ModuleFlags;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record BulkFilterUpdateMessage(FilterOp op, MFLocator locator, Optional<ModuleTarget> targetInv) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<BulkFilterUpdateMessage> TYPE = new CustomPacketPayload.Type(MiscUtil.RL("filter_settings"));
    public static final StreamCodec<FriendlyByteBuf, BulkFilterUpdateMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(FilterOp.class), BulkFilterUpdateMessage::op, MFLocator.STREAM_CODEC, BulkFilterUpdateMessage::locator, (StreamCodec)ModuleTarget.STREAM_CODEC.apply(ByteBufCodecs::optional), BulkFilterUpdateMessage::targetInv, BulkFilterUpdateMessage::new);

    public static BulkFilterUpdateMessage targeted(FilterOp op, MFLocator locator, ModuleTarget target) {
        return new BulkFilterUpdateMessage(op, locator, Optional.of(target));
    }

    public static BulkFilterUpdateMessage untargeted(FilterOp op, MFLocator locator) {
        return new BulkFilterUpdateMessage(op, locator, Optional.empty());
    }

    public CustomPacketPayload.Type<BulkFilterUpdateMessage> type() {
        return TYPE;
    }

    public Optional<IItemHandler> getTargetInventory() {
        return this.targetInv.flatMap(ModuleTarget::getItemHandler);
    }

    public static void handleData(BulkFilterUpdateMessage message, IPayloadContext context) {
        AbstractContainerMenu abstractContainerMenu;
        ServerPlayer player = (ServerPlayer)context.player();
        MFLocator locator = message.locator();
        if (locator.getTargetItem((Player)player).getItem() instanceof BulkItemFilter && (abstractContainerMenu = player.containerMenu) instanceof BulkItemFilterMenu) {
            BulkItemFilterMenu filterMenu = (BulkItemFilterMenu)abstractContainerMenu;
            ModuleFlags flags = ModuleFlags.forItem(locator.getModuleStack((Player)player));
            switch (message.op().ordinal()) {
                case 0: {
                    filterMenu.clearSlots();
                    break;
                }
                case 1: {
                    message.getTargetInventory().ifPresent(h -> filterMenu.mergeInventory((IItemHandler)h, flags, false));
                    break;
                }
                case 2: {
                    message.getTargetInventory().ifPresent(h -> filterMenu.mergeInventory((IItemHandler)h, flags, true));
                }
            }
        }
    }

    public static enum FilterOp {
        CLEAR_ALL,
        MERGE,
        LOAD;

    }
}

