/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.module.IPickaxeUser;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.TranslatableEnum;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class CompiledBreakerModule
extends CompiledModule {
    private final ItemStack pickaxe;
    private final BreakerSettings settings;

    public CompiledBreakerModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        ItemStack itemStack;
        this.settings = (BreakerSettings)stack.getOrDefault(ModDataComponents.BREAKER_SETTINGS, (Object)BreakerSettings.DEFAULT);
        Item item = stack.getItem();
        if (item instanceof IPickaxeUser) {
            IPickaxeUser p = (IPickaxeUser)item;
            itemStack = p.getPickaxe(stack);
        } else {
            itemStack = ItemStack.EMPTY;
        }
        this.pickaxe = itemStack;
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        if (this.isRegulationOK(router, true)) {
            Level world = router.getLevel();
            if (!(world instanceof ServerLevel)) {
                return false;
            }
            BlockPos pos = this.getTarget().gPos.pos();
            BlockState oldState = world.getBlockState(pos);
            if (BlockUtil.tryBreakBlock(router, world, pos, this.getFilter(), this.pickaxe, this.getMatchType() == MatchType.BLOCK)) {
                if (((Boolean)ConfigHolder.common.module.breakerParticles.get()).booleanValue() && router.getUpgradeCount((UpgradeItem)ModItems.MUFFLER_UPGRADE.get()) == 0) {
                    world.levelEvent(2001, pos, Block.getId((BlockState)oldState));
                }
                return true;
            }
        }
        return false;
    }

    public MatchType getMatchType() {
        return this.settings.matchType;
    }

    public record BreakerSettings(MatchType matchType) {
        public static final BreakerSettings DEFAULT = new BreakerSettings(MatchType.ITEM);
        public static final Codec<BreakerSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)StringRepresentable.fromEnum(MatchType::values).optionalFieldOf("action", (Object)MatchType.ITEM).forGetter(BreakerSettings::matchType)).apply((Applicative)builder, BreakerSettings::new));
        public static final StreamCodec<FriendlyByteBuf, BreakerSettings> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(MatchType.class), BreakerSettings::matchType, BreakerSettings::new);
    }

    public static enum MatchType implements TranslatableEnum,
    StringRepresentable
    {
        ITEM("item"),
        BLOCK("block");

        private final String name;

        private MatchType(String name) {
            this.name = name;
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.guiText.label.breakMatchType." + this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

