/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import java.util.List;
import javax.annotation.Nullable;
import me.desht.modularrouters.api.matching.IItemMatcher;
import me.desht.modularrouters.client.gui.filter.FilterScreenFactory;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.container.AbstractSmartFilterMenu;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.MRBaseItem;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class SmartFilterItem
extends MRBaseItem {
    public SmartFilterItem() {
        super(ModItems.defaultProps());
    }

    public SmartFilterItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public abstract IItemMatcher compile(ItemStack var1, ItemStack var2);

    public abstract int getSize(ItemStack var1);

    public boolean hasMenu() {
        return true;
    }

    public AbstractSmartFilterMenu createMenu(int windowId, Inventory invPlayer, MFLocator loc) {
        return null;
    }

    @Override
    protected void addExtraInformation(ItemStack stack, List<Component> list) {
    }

    protected final void addCountInfo(List<Component> list, int count) {
        list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.filter.count", count).withStyle(ChatFormatting.YELLOW));
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        SmartFilterItem filter = (SmartFilterItem)stack.getItem();
        MFLocator loc = MFLocator.heldFilter(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (filter.hasMenu()) {
                sp.openMenu((MenuProvider)new FilterMenuProvider(player, loc), loc::toNetwork);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
        }
        if (!world.isClientSide) return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        if (this.hasMenu()) return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        FilterScreenFactory.openFilterGui(loc);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static class FilterMenuProvider
    implements MenuProvider {
        private final MFLocator loc;
        private final ItemStack filterStack;

        public FilterMenuProvider(Player player, MFLocator loc) {
            this.loc = loc;
            this.filterStack = loc.getTargetItem(player);
        }

        public Component getDisplayName() {
            return this.filterStack.getHoverName();
        }

        @Nullable
        public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
            return ((SmartFilterItem)this.filterStack.getItem()).createMenu(windowId, playerInventory, this.loc);
        }
    }
}

