/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import java.util.List;
import me.desht.modularrouters.api.matching.IItemMatcher;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.logic.filter.matchers.InspectionMatcher;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InspectionFilter
extends SmartFilterItem {
    public static final int MAX_SIZE = 6;

    public InspectionFilter() {
        super(ModItems.defaultProps().component(ModDataComponents.COMPARISON_LIST, (Object)InspectionMatcher.ComparisonList.DEFAULT));
    }

    @Override
    @NotNull
    public IItemMatcher compile(ItemStack filterStack, ItemStack moduleStack) {
        return new InspectionMatcher(InspectionFilter.getComparisonList(filterStack));
    }

    @Override
    public boolean hasMenu() {
        return false;
    }

    @Override
    public void addExtraInformation(ItemStack itemstack, List<Component> list) {
        super.addExtraInformation(itemstack, list);
        InspectionMatcher.ComparisonList comparisonList = InspectionFilter.getComparisonList(itemstack);
        if (!comparisonList.isEmpty()) {
            list.add((Component)ClientUtil.xlate("modularrouters.guiText.label.matchAll." + comparisonList.matchAll(), new Object[0]).append(":").withStyle(ChatFormatting.YELLOW));
            comparisonList.items().stream().map(c -> Component.literal((String)"\u2022 ").append((Component)c.asLocalizedText().withStyle(ChatFormatting.AQUA))).forEach(list::add);
        }
    }

    public static InspectionMatcher.ComparisonList getComparisonList(ItemStack filterStack) {
        return (InspectionMatcher.ComparisonList)filterStack.get(ModDataComponents.COMPARISON_LIST.get());
    }

    public static void setComparisonList(ItemStack filterStack, InspectionMatcher.ComparisonList comparisonList) {
        filterStack.set(ModDataComponents.COMPARISON_LIST.get(), (Object)comparisonList);
    }

    @Override
    public int getSize(ItemStack filterStack) {
        return InspectionFilter.getComparisonList(filterStack).items().size();
    }
}

