/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.datagen;

import me.desht.modularrouters.block.ModularRouterBlock;
import me.desht.modularrouters.core.ModBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModBlockStateProvider
extends BlockStateProvider {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public ModBlockStateProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "modularrouters", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        String routerName = ModBlocks.MODULAR_ROUTER.getId().getPath();
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(routerName, "block/block")).texture("back", ModBlockStateProvider.modid("block/%s_back", routerName))).texture("side", ModBlockStateProvider.modid("block/%s_side", routerName))).texture("top", ModBlockStateProvider.modid("block/%s_top", routerName))).texture("bottom", ModBlockStateProvider.modid("block/%s_bottom", routerName))).texture("particle", ModBlockStateProvider.modid("block/%s_other", routerName))).element().face(Direction.DOWN).texture("#bottom").cullface(Direction.DOWN).end().face(Direction.UP).texture("#top").cullface(Direction.UP).end().face(Direction.NORTH).texture("#front").cullface(Direction.NORTH).end().face(Direction.SOUTH).texture("#back").cullface(Direction.SOUTH).end().face(Direction.WEST).texture("#side").cullface(Direction.WEST).end().face(Direction.EAST).texture("#side").cullface(Direction.EAST).end().end();
        ModelBuilder routerOff = ((BlockModelBuilder)this.models().withExistingParent(routerName + "_off", ModBlockStateProvider.modid("block/%s", routerName))).texture("front", ModBlockStateProvider.modid("block/%s_front", routerName));
        ModelBuilder routerOn = ((BlockModelBuilder)this.models().withExistingParent(routerName + "_on", ModBlockStateProvider.modid("block/%s", routerName))).texture("front", ModBlockStateProvider.modid("block/%s_front_active", routerName));
        VariantBlockStateBuilder.PartialBlockstate builder = this.getVariantBuilder((Block)ModBlocks.MODULAR_ROUTER.get()).partialState();
        for (Direction d : HORIZONTALS) {
            builder.with((Property)ModularRouterBlock.ACTIVE, (Comparable)Boolean.valueOf(false)).with((Property)ModularRouterBlock.FACING, (Comparable)d).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)routerOff, 0, this.getYRotation(d), false)});
            builder.with((Property)ModularRouterBlock.ACTIVE, (Comparable)Boolean.valueOf(true)).with((Property)ModularRouterBlock.FACING, (Comparable)d).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)routerOn, 0, this.getYRotation(d), false)});
        }
        this.simpleBlock(ModBlocks.TEMPLATE_FRAME.get());
        this.simpleBlockItem((Block)ModBlocks.MODULAR_ROUTER.get(), (ModelFile)routerOff);
    }

    private int getYRotation(Direction d) {
        return switch (d) {
            case Direction.NORTH -> 0;
            case Direction.EAST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            default -> throw new IllegalArgumentException("invalid dir");
        };
    }

    public String getName() {
        return "Modular Routers Blockstates";
    }

    static String modid(String s, Object ... args) {
        return "modularrouters:" + String.format(s, args);
    }
}

