/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.util;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.gui.IResyncableGui;
import me.desht.modularrouters.client.gui.ModularRouterScreen;
import me.desht.modularrouters.container.RouterMenu;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class ClientUtil {
    public static Optional<ModularRouterBlockEntity> getOpenItemRouter() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof ModularRouterScreen) {
            ModularRouterScreen mrs = (ModularRouterScreen)screen;
            return Optional.of(((RouterMenu)mrs.getMenu()).getRouter());
        }
        return Optional.empty();
    }

    public static void resyncGui(ItemStack stack) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof IResyncableGui) {
            IResyncableGui syncable = (IResyncableGui)screen;
            syncable.resync(stack);
        }
    }

    public static MutableComponent xlate(String key, Object ... args) {
        return Component.translatable((String)key, (Object[])args);
    }

    public static Component colorText(Object text, ChatFormatting ... formats) {
        return Component.literal((String)text.toString()).withStyle(formats);
    }

    public static boolean isInvKey(int keyCode) {
        return keyCode == Minecraft.getInstance().options.keyInventory.getKey().getValue();
    }

    public static VertexConsumer posF(VertexConsumer builder, Matrix4f posMat, Vec3 vec) {
        return builder.addVertex(posMat, (float)vec.x, (float)vec.y, (float)vec.z);
    }

    public static Slot getHoveredSlot() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen cs = (AbstractContainerScreen)screen;
            return cs.getSlotUnderMouse();
        }
        return null;
    }

    public static FormattedCharSequence ellipsize(Font font, String str, int maxWidth) {
        return Language.getInstance().getVisualOrder(font.ellipsize((FormattedText)Component.literal((String)str), maxWidth));
    }

    public static boolean isKeyDown(KeyMapping key) {
        return !key.isUnbound() && InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)key.getKey().getValue()) && key.getKeyConflictContext().isActive();
    }

    public static void setMultilineTooltip(AbstractWidget w, Component ... lines) {
        Arrays.stream(lines).reduce((c1, c2) -> c1.copy().append("\n").append(c2)).ifPresentOrElse(c -> w.setTooltip(Tooltip.create((Component)c)), () -> w.setTooltip(null));
    }

    public static void setMultilineTooltip(AbstractWidget w, Collection<Component> lines) {
        lines.stream().reduce((c1, c2) -> c1.copy().append("\n").append(c2)).ifPresentOrElse(c -> w.setTooltip(Tooltip.create((Component)c)), () -> w.setTooltip(null));
    }
}

