/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import me.desht.modularrouters.client.gui.ISendToServer;
import me.desht.modularrouters.client.gui.module.ModuleScreen;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.logic.compiled.CompiledDistributorModule;
import me.desht.modularrouters.logic.settings.TransferDirection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DistributorModuleScreen
extends ModuleScreen {
    private static final ItemStack ROUTER_STACK = new ItemStack((ItemLike)ModBlocks.MODULAR_ROUTER.get());
    private StrategyButton sb;
    private DirectionButton db;

    public DistributorModuleScreen(ModuleMenu container, Inventory inv, Component displayText) {
        super(container, inv, displayText);
    }

    @Override
    public void init() {
        super.init();
        CompiledDistributorModule cdm = new CompiledDistributorModule(null, this.moduleItemStack);
        this.addRenderableWidget((GuiEventListener)new TooltipButton(this.leftPos + 127, this.topPos + 23, ModItems.DISTRIBUTOR_MODULE.toStack()));
        this.sb = new StrategyButton(this.leftPos + 147, this.topPos + 23, 16, 16, cdm.getDistributionStrategy(), (ISendToServer)this);
        this.addRenderableWidget((GuiEventListener)this.sb);
        this.db = new DirectionButton(this.leftPos + 147, this.topPos + 43, cdm.isPulling(), this);
        this.addRenderableWidget((GuiEventListener)this.db);
        this.getMouseOverHelp().addHelpRegion(this.leftPos + 125, this.topPos + 21, this.leftPos + 165, this.topPos + 41, (Component)ClientUtil.xlate("modularrouters.guiText.popup.distributor.strategy", new Object[0]).withStyle(ChatFormatting.YELLOW));
        this.getMouseOverHelp().addHelpRegion(this.leftPos + 125, this.topPos + 41, this.leftPos + 165, this.topPos + 61, (Component)ClientUtil.xlate("modularrouters.guiText.popup.distributor.direction", new Object[0]).withStyle(ChatFormatting.YELLOW));
    }

    @Override
    protected void buildComponentPatch(DataComponentPatch.Builder builder) {
        super.buildComponentPatch(builder);
        builder.set(ModDataComponents.DISTRIBUTOR_SETTINGS.get(), (Object)new CompiledDistributorModule.DistributorSettings((CompiledDistributorModule.DistributionStrategy)this.sb.getState(), this.db.isToggled() ? TransferDirection.TO_ROUTER : TransferDirection.FROM_ROUTER));
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        graphics.renderItem(ROUTER_STACK, this.leftPos + 127, this.topPos + 43);
    }

    static class TooltipButton
    extends ItemStackButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(176, 16);

        TooltipButton(int x, int y, ItemStack stack) {
            super(x, y, 16, 16, stack, true, p -> {});
            this.setTooltip(Tooltip.create((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.distributor.strategy", new Object[0])));
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        public void playDownSound(SoundManager soundHandlerIn) {
        }

        @Override
        protected XYPoint getTextureXY() {
            return TEXTURE_XY;
        }
    }

    static class StrategyButton
    extends TexturedCyclerButton<CompiledDistributorModule.DistributionStrategy> {
        StrategyButton(int x, int y, int width, int height, CompiledDistributorModule.DistributionStrategy initialVal, ISendToServer sendToServer) {
            super(x, y, width, height, initialVal, sendToServer);
        }

        @Override
        protected XYPoint getTextureXY() {
            return new XYPoint(160 + ((CompiledDistributorModule.DistributionStrategy)this.getState()).ordinal() * 16, 32);
        }
    }

    static class DirectionButton
    extends TexturedToggleButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(176, 16);
        private static final XYPoint TEXTURE_XY_TOGGLED = new XYPoint(160, 16);

        public DirectionButton(int x, int y, boolean initialVal, ISendToServer sender) {
            super(x, y, 16, 16, initialVal, sender);
            this.setTooltips((Component)ClientUtil.xlate("modularrouters.itemText.transfer_direction.from_router", new Object[0]), (Component)ClientUtil.xlate("modularrouters.itemText.transfer_direction.to_router", new Object[0]));
        }

        @Override
        protected XYPoint getTextureXY() {
            return this.isToggled() ? TEXTURE_XY_TOGGLED : TEXTURE_XY;
        }
    }
}

