/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.neoforge.create;

import com.simibubi.create.api.behaviour.display.DisplayTarget;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.BlackboardItem;
import net.mehvahdjukaar.supplementaries.common.items.components.BlackboardData;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.neoforge.CreateCompatImpl;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BlackboardDisplayTarget
extends DisplayTarget {
    private static final Pattern PATTERN = Pattern.compile("\\((\\d\\d?),(\\d\\d?)\\)->(\\S+)");

    public void acceptText(int line, List<MutableComponent> text, DisplayLinkContext context) {
        BlockEntity te = context.getTargetBlockEntity();
        if (te instanceof BlackboardBlockTile) {
            BlackboardBlockTile tile = (BlackboardBlockTile)te;
            if (!text.isEmpty() && !tile.isWaxed()) {
                BlockEntity source = context.getSourceBlockEntity();
                if (!this.parseText(text.get(0).getString(), tile)) {
                    ItemStack copyStack = CreateCompatImpl.getDisplayedItem(context, source, i -> i.getItem() instanceof BlackboardItem);
                    if (!copyStack.isEmpty() && BlackboardDisplayTarget.copyBlackboard(line, context, te, tile, copyStack)) {
                        return;
                    }
                    long[] pixels = CommonConfigs.Building.BLACKBOARD_COLOR.get() != false ? BlackboardData.unpackPixelsFromString(text.getFirst().getString()) : BlackboardData.unpackPixelsFromStringWhiteOnly(text.getFirst().getString());
                    tile.setPixels(BlackboardData.unpackPixels(pixels));
                }
                context.level().sendBlockUpdated(context.getTargetPos(), te.getBlockState(), te.getBlockState(), 2);
                BlackboardDisplayTarget.reserve((int)line, (BlockEntity)te, (DisplayLinkContext)context);
            }
        }
    }

    private boolean parseText(String string, BlackboardBlockTile tile) {
        Matcher m = PATTERN.matcher(string);
        if (m.matches()) {
            int x = Integer.parseInt(m.group(1));
            int y = Integer.parseInt(m.group(2));
            DyeColor dye = DyeColor.byName((String)m.group(3), null);
            if (x >= 0 && x <= 15 && y >= 0 && y <= 15 && dye != null) {
                if (dye != DyeColor.WHITE && dye != DyeColor.BLACK && !CommonConfigs.Building.BLACKBOARD_COLOR.get().booleanValue()) {
                    return false;
                }
                tile.setPixel(x, y, BlackboardBlock.colorToByte(dye));
                return true;
            }
        }
        return false;
    }

    private static boolean copyBlackboard(int line, DisplayLinkContext context, BlockEntity te, BlackboardBlockTile tile, ItemStack stack) {
        BlackboardData beData = (BlackboardData)stack.get(ModComponents.BLACKBOARD.get());
        if (beData != null) {
            tile.setPixels(beData.getPixelsUnsafe());
            context.level().sendBlockUpdated(context.getTargetPos(), te.getBlockState(), te.getBlockState(), 2);
            BlackboardDisplayTarget.reserve((int)line, (BlockEntity)te, (DisplayLinkContext)context);
            return true;
        }
        return false;
    }

    public DisplayTargetStats provideStats(DisplayLinkContext context) {
        return new DisplayTargetStats(1, 32, (DisplayTarget)this);
    }
}

