/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.goals;

import com.google.common.base.Preconditions;
import java.util.List;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.vehicle.Boat;

public class IAmTheCaptainGoal
extends Goal {
    private final Mob mob;

    public IAmTheCaptainGoal(Mob mob) {
        this.mob = mob;
        Preconditions.checkArgument((boolean)mob.getType().is(ModTags.CAN_STEER_BOAT));
    }

    public boolean canUse() {
        Entity entity = this.mob.getVehicle();
        if (entity instanceof Boat) {
            Boat b = (Boat)entity;
            LivingEntity captain = b.getControllingPassenger();
            if (captain == null || captain == this.mob) {
                return false;
            }
            if (captain.getType().is(ModTags.CAN_STEER_BOAT)) {
                return false;
            }
        }
        return false;
    }

    public void start() {
        Entity entity = this.mob.getVehicle();
        if (entity instanceof Boat) {
            Boat b = (Boat)entity;
            List allPassengers = b.getPassengers();
            b.ejectPassengers();
            this.mob.startRiding((Entity)b, true);
            for (Entity other : allPassengers) {
                if (other == this.mob) continue;
                other.startRiding((Entity)b, true);
            }
        }
    }
}

